package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * プリペアドステートメントに対するパラメータ設定の抽象化インタフェースです
 * 
 * @author nkoseki
 * 
 */
public interface SQLParameter {
	
	/**
	 * 与えられたクラスオブジェクトに対して、このインスタンスが許容するかテストします
	 * 
	 * @param parameterType
	 * @return
	 */
	public boolean accept(Class<?> parameterType);
	
	/**
	 * 与えられた引数を用いてプリペアドステートメントに値を設定します
	 * 
	 * @param pstmt
	 * @param index
	 * @param parameter
	 * @param parameterType
	 * @throws SQLException
	 */
	public void setParameter(PreparedStatement pstmt, int index,
			Object parameter, Class<?> parameterType) throws SQLException;
}
