package org.dyndns.nuda.mapper.parameter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public class StringSQLParameter implements SQLParameter {
	
	@Override
	public boolean accept(final Class<?> parameterType) {
		return parameterType == String.class;
	}
	
	@Override
	public void setParameter(final PreparedStatement pstmt, final int index,
			final Object parameter, final Class<?> parameterType)
			throws SQLException {
		pstmt.setString(index, String.class.cast(parameter));
	}
	
}
