/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.parser;

import java.util.ArrayList;
import java.util.List;

import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.mapper.SQLContainer;
import org.dyndns.nuda.mapper.SQLMapperException;
import org.dyndns.nuda.plugin.PluginLoader;

public class AutoSQLParser implements SQLParser {

	private static List<SQLParser> parsers = new ArrayList<SQLParser>();

	private static RUN_STATE state = RUN_STATE.SLEEP;

	public AutoSQLParser() {
		if (state.equals(RUN_STATE.SLEEP)) {
			System.out.println("SQLParserPlugin");
			PluginLoader loader = new PluginLoader();
			loader.loadPlugin(SQLParser.class);

			state = RUN_STATE.RUNNING;
		}
		// this.parsers.add(new InsertSQLParser());
		// this.parsers.add(new UpdateSQLParser());
		// this.parsers.add(new DeleteSQLParser());
		// this.parsers.add(new SelectSQLParser());
		// this.parsers.add(new CreateSQLParser());
		// this.parsers.add(new OtherSQLParser());
		// this.parsers.add(new NOPSQLParser());
	}

	@Override
	public boolean accept(final String queryType, final String sql) {
		for (SQLParser parser : parsers) {
			System.out.println(parser.getClass());
			if (parser.accept(queryType, sql)) {
				return true;
			}
		}
		return true;
	}

	@Override
	public SQLContainer parse(final String queryId, final String queryType,
			final String sql) {
		for (SQLParser parser : parsers) {
			System.out.println(parser.getClass());
			if (parser.accept(queryType, sql)) {
				return parser.parse(queryId, queryType, sql);
				
			}
		}
		throw new SQLMapperException("指定されたSQLを解析可能なパーサクラスが存在しませんでした");
	}

	public static void addParser(final SQLParser parser) {
		if (parser != null) {
			parsers.add(parser);
		}
	}

	@Override
	public void init() {
		// TODO 自動生成されたメソッド・スタブ

	}

}
