/*
 * [概要]
 * 
 * =====================================================================================
 * [履歴]
 * 2014-05-09 n.koseki 新規作成
 * 
 * =====================================================================================
 * 
 */
package org.dyndns.nuda.mapper.parser;

import org.dyndns.nuda.mapper.SQLMapperException;
import org.dyndns.nuda.tools.util.StringUtil;

public enum QUERY_TYPE {
	
	SELECT, UPDATE, DELETE, INSERT, CREATE, OTHER;
	
	public static QUERY_TYPE is(final String queryType) {
		QUERY_TYPE[] types = QUERY_TYPE.values();
		if (queryType == null) {
			String message =
				StringUtil.format(
					"method=[{}#{}] cause={}",
					"QUERY_TYPE",
					"is",
					"parameter[queryType] is NULL");
			throw new SQLMapperException(message);
		}
		if (queryType.isEmpty()) {
			String message =
				StringUtil.format(
					"method=[{}#{}] cause={}",
					"QUERY_TYPE",
					"is",
					"parameter[queryType] is EMPTY");
			throw new SQLMapperException(message);
		}
		
		String strType = queryType.toUpperCase();
		for (QUERY_TYPE type : types) {
			String typeName = type.name();
			if (typeName.equals(strType)) {
				return type;
			}
		}
		
		return OTHER;
	}
	
}
