/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.mapper.ConnectionBean;
import org.dyndns.nuda.mapper.QueryXMLBean;
import org.dyndns.nuda.mapper.QueryXMLReader;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class QueryXMLReaderTest
extends TestCase {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetResult01() {
        QueryXMLReader reader = new QueryXMLReader();
        String path = "org/dyndns/nuda/sormap/sample/query.xml";
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(path);
            reader.read(is);
            List querys = reader.getResult();
            Assert.assertEquals((int)8, (int)querys.size());
            for (QueryXMLBean xml : querys) {
                String id = xml.getId();
                if (id.equals("select")) {
                    if (xml.getType().equals("SELECT")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:select");
                    continue;
                }
                if (id.equals("selectBy")) {
                    if (xml.getType().equals("SELECT")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:selectBy");
                    continue;
                }
                if (id.equals("insert")) {
                    if (xml.getType().equals("INSERT")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:insert");
                    continue;
                }
                if (id.equals("update")) {
                    if (xml.getType().equals("UPDATE")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:update");
                    continue;
                }
                if (id.equals("delete")) {
                    if (xml.getType().equals("DELETE")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:delete");
                    continue;
                }
                if (id.equals("create")) {
                    if (xml.getType().equals("CREATE")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:create");
                    continue;
                }
                if (id.equals("other01")) {
                    if (xml.getType().equals("OTHER")) continue;
                    Assert.fail((String)("ID\u4e0d\u6b63:" + id));
                    continue;
                }
                if (!id.equals("other02") || xml.getType().equals("OTHER")) continue;
                Assert.fail((String)("ID\u4e0d\u6b63:" + id));
            }
            ConnectionBean conBean = reader.getConnectionInfo();
            String url = conBean.url;
            Properties prop = conBean.prop;
            Assert.assertEquals((String)"url\u4e0d\u6b63", (String)"jdbc:sormap://localhost:3306/testdb?subProtocol=mysql", (String)url);
            Assert.assertEquals((String)"\u30e6\u30fc\u30b6ID\u4e0d\u6b63", (String)"[\u30e6\u30fc\u30b6ID]", (String)prop.get("user").toString());
            Assert.assertEquals((String)"\u30d1\u30b9\u30ef\u30fc\u30c9\u4e0d\u6b63", (String)"[\u30d1\u30b9\u30ef\u30fc\u30c9]", (String)prop.get("password").toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResult02() {
        QueryXMLReader reader = new QueryXMLReader();
        String path = "sample/org/dyndns/nuda/sormap/sample/query.xml";
        File file = new File(path);
        try {
            reader.read(file);
            List querys = reader.getResult();
            Assert.assertEquals((int)8, (int)querys.size());
            for (QueryXMLBean xml : querys) {
                String id = xml.getId();
                if (id.equals("select")) {
                    if (xml.getType().equals("SELECT")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:select");
                    continue;
                }
                if (id.equals("selectBy")) {
                    if (xml.getType().equals("SELECT")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:selectBy");
                    continue;
                }
                if (id.equals("insert")) {
                    if (xml.getType().equals("INSERT")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:insert");
                    continue;
                }
                if (id.equals("update")) {
                    if (xml.getType().equals("UPDATE")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:update");
                    continue;
                }
                if (id.equals("delete")) {
                    if (xml.getType().equals("DELETE")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:delete");
                    continue;
                }
                if (id.equals("create")) {
                    if (xml.getType().equals("CREATE")) continue;
                    Assert.fail((String)"TYPE\u4e0d\u6b63:create");
                    continue;
                }
                if (id.equals("other01")) {
                    if (xml.getType().equals("OTHER")) continue;
                    Assert.fail((String)("ID\u4e0d\u6b63:" + id));
                    continue;
                }
                if (!id.equals("other02") || xml.getType().equals("OTHER")) continue;
                Assert.fail((String)("ID\u4e0d\u6b63:" + id));
            }
            ConnectionBean conBean = reader.getConnectionInfo();
            String url = conBean.url;
            Properties prop = conBean.prop;
            Assert.assertEquals((String)"url\u4e0d\u6b63", (String)"jdbc:sormap://localhost:3306/testdb?subProtocol=mysql", (String)url);
            Assert.assertEquals((String)"\u30e6\u30fc\u30b6ID\u4e0d\u6b63", (String)"[\u30e6\u30fc\u30b6ID]", (String)prop.get("user").toString());
            Assert.assertEquals((String)"\u30d1\u30b9\u30ef\u30fc\u30c9\u4e0d\u6b63", (String)"[\u30d1\u30b9\u30ef\u30fc\u30c9]", (String)prop.get("password").toString());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResult03() {
        QueryXMLReader reader = new QueryXMLReader();
        String path = "org2/dyndns/nuda/sormap/sample/query.xml";
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(path);
            reader.read(is);
            Assert.fail((String)"testGetResult03");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)true);
        }
    }

    @Test
    public void testGetResult04() {
        QueryXMLReader reader = new QueryXMLReader();
        String path = "sample/org2/dyndns/nuda/sormap/sample/query.xml";
        File file = new File(path);
        try {
            reader.read(file);
            Assert.fail((String)"testGetResult04");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)true);
        }
    }

    @Test
    public void testGetResult05() {
        QueryXMLReader reader = new QueryXMLReader();
        String path = "org/dyndns/nuda/sormap/sample/query2.xml";
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(path);
            reader.read(is);
            Assert.fail((String)"testGetResult05");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)true);
        }
    }

    @Test
    public void testGetResult06() {
        QueryXMLReader reader = new QueryXMLReader();
        String path = "sample/org/dyndns/nuda/sormap/sample/query2.xml";
        File file = new File(path);
        try {
            reader.read(file);
            Assert.fail((String)"testGetResult06");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)true);
        }
    }
}

