/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.connection;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dyndns.nuda.mapper.SQLInterfaceBean;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;
import org.dyndns.nuda.mapper.event.SQLInterfaceEvent;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventListener;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventProcessor;
import org.dyndns.nuda.mapper.event.implementation.ManualTransactionEvent;
import org.dyndns.nuda.mapper.helper.CommandDataPair;
import org.dyndns.nuda.tools.Listener;
import org.dyndns.nuda.tools.MethodCall;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SQLInterfaceConnectionTest
extends TestCase {
    private SQLInterfaceConnection target = null;
    private Connection con = null;
    private Connection con02 = null;
    private MethodCall methodCall = null;
    private static final Map<Integer, String> map = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1, "aaa");
            this.put(2, "bbb");
            this.put(3, "ccc");
        }
    };
    private static boolean isAutoCommit = false;

    @Before
    public void setUp() throws Exception {
        this.methodCall = MethodCall.newInstance();
        isAutoCommit = false;
        this.con = new Connection(){

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("unwrap[Class<T>]");
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isWrapperFor[Class<T>]");
                return false;
            }

            @Override
            public Statement createStatement() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStatement[]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String]");
                return null;
            }

            @Override
            public CallableStatement prepareCall(String sql) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareCall[String]");
                return null;
            }

            @Override
            public String nativeSQL(String sql) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("nativeSQL[String]");
                return null;
            }

            @Override
            public void setAutoCommit(boolean autoCommit) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setAutoCommit[boolean]");
                isAutoCommit = autoCommit;
            }

            @Override
            public boolean getAutoCommit() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getAutoCommit[]");
                return isAutoCommit;
            }

            @Override
            public void commit() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("commit[]");
            }

            @Override
            public void rollback() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("rollback[]");
            }

            @Override
            public void close() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("close[]");
            }

            @Override
            public boolean isClosed() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isClosed[]");
                return false;
            }

            @Override
            public DatabaseMetaData getMetaData() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getMetaData[]");
                return null;
            }

            @Override
            public void setReadOnly(boolean readOnly) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setReadOnly[boolean]");
            }

            @Override
            public boolean isReadOnly() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isReadOnly[]");
                return false;
            }

            @Override
            public void setCatalog(String catalog) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setCatalog[String]");
            }

            @Override
            public String getCatalog() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getCatalog[]");
                return null;
            }

            @Override
            public void setTransactionIsolation(int level) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setTransactionIsolation[int]");
            }

            @Override
            public int getTransactionIsolation() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getTransactionIsolation[]");
                return 0;
            }

            @Override
            public SQLWarning getWarnings() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getWarnings[]");
                return null;
            }

            @Override
            public void clearWarnings() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("clearWarnings[]");
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStatement[int,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int,int]");
                return null;
            }

            @Override
            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareCall[String,int,int]");
                return null;
            }

            @Override
            public Map<String, Class<?>> getTypeMap() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getTypeMap[]");
                return null;
            }

            @Override
            public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setTypeMap[Map<String, Class<?>>]");
            }

            @Override
            public void setHoldability(int holdability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setHoldability[int]");
            }

            @Override
            public int getHoldability() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getHoldability[]");
                return 0;
            }

            @Override
            public Savepoint setSavepoint() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setSavepoint[]");
                return null;
            }

            @Override
            public Savepoint setSavepoint(String name) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setSavepoint[String]");
                return null;
            }

            @Override
            public void rollback(Savepoint savepoint) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("rollback[Savepoint]");
            }

            @Override
            public void releaseSavepoint(Savepoint savepoint) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("releaseSavepoint[Savepoint]");
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStatement[int,int,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int,int,int]");
                return null;
            }

            @Override
            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareCall[String,int,int,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int[]]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,String[]]");
                return null;
            }

            @Override
            public Clob createClob() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createClob[]");
                return null;
            }

            @Override
            public Blob createBlob() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createBlob[]");
                return null;
            }

            @Override
            public NClob createNClob() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createNClob[]");
                return null;
            }

            @Override
            public SQLXML createSQLXML() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createSQLXML[]");
                return null;
            }

            @Override
            public boolean isValid(int timeout) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isValid[int]");
                return false;
            }

            @Override
            public void setClientInfo(String name, String value) throws SQLClientInfoException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setClientInfo[String,String]");
            }

            @Override
            public void setClientInfo(Properties properties) throws SQLClientInfoException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setClientInfo[Properties]");
            }

            @Override
            public String getClientInfo(String name) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getClientInfo[String]");
                return null;
            }

            @Override
            public Properties getClientInfo() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getClientInfo[]");
                return null;
            }

            @Override
            public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createArrayOf[String,Object[]]");
                return null;
            }

            @Override
            public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStruct[String,Object[]]");
                return null;
            }
        };
        this.con02 = new Connection(){

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("unwrap[Class<T>]");
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isWrapperFor[Class<T>]");
                return false;
            }

            @Override
            public Statement createStatement() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStatement[]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String]");
                return null;
            }

            @Override
            public CallableStatement prepareCall(String sql) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareCall[String]");
                return null;
            }

            @Override
            public String nativeSQL(String sql) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("nativeSQL[String]");
                return null;
            }

            @Override
            public void setAutoCommit(boolean autoCommit) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setAutoCommit[boolean]");
                isAutoCommit = autoCommit;
            }

            @Override
            public boolean getAutoCommit() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getAutoCommit[]");
                return isAutoCommit;
            }

            @Override
            public void commit() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("commit[]");
                throw new SQLException("commit error");
            }

            @Override
            public void rollback() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("rollback[]");
                throw new SQLException("rollback error");
            }

            @Override
            public void close() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("close[]");
            }

            @Override
            public boolean isClosed() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isClosed[]");
                return false;
            }

            @Override
            public DatabaseMetaData getMetaData() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getMetaData[]");
                return null;
            }

            @Override
            public void setReadOnly(boolean readOnly) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setReadOnly[boolean]");
            }

            @Override
            public boolean isReadOnly() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isReadOnly[]");
                return false;
            }

            @Override
            public void setCatalog(String catalog) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setCatalog[String]");
            }

            @Override
            public String getCatalog() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getCatalog[]");
                return null;
            }

            @Override
            public void setTransactionIsolation(int level) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setTransactionIsolation[int]");
            }

            @Override
            public int getTransactionIsolation() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getTransactionIsolation[]");
                return 0;
            }

            @Override
            public SQLWarning getWarnings() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getWarnings[]");
                return null;
            }

            @Override
            public void clearWarnings() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("clearWarnings[]");
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStatement[int,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int,int]");
                return null;
            }

            @Override
            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareCall[String,int,int]");
                return null;
            }

            @Override
            public Map<String, Class<?>> getTypeMap() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getTypeMap[]");
                return null;
            }

            @Override
            public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setTypeMap[Map<String, Class<?>>]");
            }

            @Override
            public void setHoldability(int holdability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setHoldability[int]");
            }

            @Override
            public int getHoldability() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getHoldability[]");
                return 0;
            }

            @Override
            public Savepoint setSavepoint() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setSavepoint[]");
                return null;
            }

            @Override
            public Savepoint setSavepoint(String name) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setSavepoint[String]");
                return null;
            }

            @Override
            public void rollback(Savepoint savepoint) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("rollback[Savepoint]");
            }

            @Override
            public void releaseSavepoint(Savepoint savepoint) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("releaseSavepoint[Savepoint]");
            }

            @Override
            public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStatement[int,int,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int,int,int]");
                return null;
            }

            @Override
            public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareCall[String,int,int,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,int[]]");
                return null;
            }

            @Override
            public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("prepareStatement[String,String[]]");
                return null;
            }

            @Override
            public Clob createClob() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createClob[]");
                return null;
            }

            @Override
            public Blob createBlob() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createBlob[]");
                return null;
            }

            @Override
            public NClob createNClob() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createNClob[]");
                return null;
            }

            @Override
            public SQLXML createSQLXML() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createSQLXML[]");
                return null;
            }

            @Override
            public boolean isValid(int timeout) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("isValid[int]");
                return false;
            }

            @Override
            public void setClientInfo(String name, String value) throws SQLClientInfoException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setClientInfo[String,String]");
            }

            @Override
            public void setClientInfo(Properties properties) throws SQLClientInfoException {
                SQLInterfaceConnectionTest.this.methodCall.fire("setClientInfo[Properties]");
            }

            @Override
            public String getClientInfo(String name) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getClientInfo[String]");
                return null;
            }

            @Override
            public Properties getClientInfo() throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("getClientInfo[]");
                return null;
            }

            @Override
            public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createArrayOf[String,Object[]]");
                return null;
            }

            @Override
            public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
                SQLInterfaceConnectionTest.this.methodCall.fire("createStruct[String,Object[]]");
                return null;
            }
        };
        String caseName = this.getName();
        this.target = "testCommitError".equals(caseName) ? new SQLInterfaceConnection(this.con02) : ("testRollbackError".equals(caseName) ? new SQLInterfaceConnection(this.con02) : new SQLInterfaceConnection(this.con));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAddCommand() {
        CommandDataPair pair = new CommandDataPair();
        pair.addData((Object)"test object");
        SQLInterfaceBean intfBean = new SQLInterfaceBean();
        intfBean.id = "test";
        intfBean.sqlStr = "sql";
        intfBean.map = map;
        pair.setSqlInterfaceBean(intfBean);
        this.target.addCommand(pair);
    }

    @Test
    public void testGetSourceConnection() {
        Connection con = this.target.getSourceConnection();
        Assert.assertEquals((Object)this.con, (Object)con);
    }

    @Test
    public void testSetSourceConnection() {
        this.target.setSourceConnection(this.con);
        Connection con = this.target.getSourceConnection();
        Assert.assertEquals((Object)this.con, (Object)con);
    }

    @Test
    public void testIsUseManualTransaction() {
        boolean mt = this.target.isUseManualTransaction();
        Assert.assertEquals((boolean)false, (boolean)mt);
    }

    @Test
    public void testSetUseManualTransaction() {
        this.target.setUseManualTransaction(true);
        boolean mt = this.target.isUseManualTransaction();
        Assert.assertEquals((boolean)true, (boolean)mt);
    }

    @Test
    public void testSQLInterfaceConnection() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testUnwrap() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"unwrap[Class<T>]", (String)method);
                }
            });
            String wrapper = (String)this.target.unwrap(String.class);
            Assert.assertNull((Object)wrapper);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsWrapperFor() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isWrapperFor[Class<T>]", (String)method);
                }
            });
            boolean wrapperFor = this.target.isWrapperFor(String.class);
            Assert.assertEquals((boolean)false, (boolean)wrapperFor);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateStatement() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createStatement[]", (String)method);
                }
            });
            this.target.createStatement();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String]", (String)method);
                }
            });
            this.target.prepareStatement("");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementSQLInterfaceBean() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String]", (String)method);
                }
            });
            SQLInterfaceBean intfBean = new SQLInterfaceBean();
            intfBean.id = "test";
            intfBean.sqlStr = "sql";
            intfBean.map = map;
            this.target.prepareStatement(intfBean);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareCallString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareCall[String]", (String)method);
                }
            });
            this.target.prepareCall("");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNativeSQL() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"nativeSQL[String]", (String)method);
                }
            });
            this.target.nativeSQL("");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetCurrentEvent() {
        ManualTransactionEvent e = new ManualTransactionEvent();
        this.target.setCurrentEvent((SQLInterfaceEvent)e);
        Assert.assertEquals((Object)e, (Object)this.target.getCurrentEvent());
    }

    @Test
    public void testSetAutoCommit() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setAutoCommit[boolean]", (String)method);
                }
            });
            this.target.setAutoCommit(true);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAutoCommit() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getAutoCommit[]", (String)method);
                }
            });
            this.target.getAutoCommit();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCommit() {
        try {
            SQLInterfaceEventProcessor.newInstance().clearListener();
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"commit", (String)event.state);
                    List pairs = event.pair;
                    Assert.assertEquals((int)1, (int)pairs.size());
                    List data = ((CommandDataPair)pairs.get(0)).getData();
                    Assert.assertEquals((int)1, (int)data.size());
                    Assert.assertEquals((Object)"test object", data.get(0));
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    if (!"getAutoCommit[]".equals(method) && !"".equals(method)) {
                        Assert.assertEquals((String)"commit[]", (String)method);
                    }
                }
            });
            CommandDataPair pair = new CommandDataPair();
            pair.addData((Object)"test object");
            this.target.addCommand(pair);
            this.target.commit();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCommitError() {
        try {
            SQLInterfaceEventProcessor.newInstance().clearListener();
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"commit", (String)event.state);
                    List pairs = event.pair;
                    Assert.assertEquals((int)1, (int)pairs.size());
                    List data = ((CommandDataPair)pairs.get(0)).getData();
                    Assert.assertEquals((int)1, (int)data.size());
                    Assert.assertEquals((Object)"test object", data.get(0));
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    if (!"getAutoCommit[]".equals(method) && !"".equals(method)) {
                        Assert.assertEquals((String)"commit[]", (String)method);
                    }
                }
            });
            CommandDataPair pair = new CommandDataPair();
            pair.addData((Object)"test object");
            this.target.addCommand(pair);
            this.target.commit();
        }
        catch (SQLException e) {
            Assert.assertEquals((String)"commit error", (String)e.getMessage());
        }
    }

    @Test
    public void testCommit01() {
        try {
            SQLInterfaceEventProcessor.newInstance().clearListener();
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"commit", (String)event.state);
                    List pairs = event.pair;
                    Assert.assertEquals((int)1, (int)pairs.size());
                    List data = ((CommandDataPair)pairs.get(0)).getData();
                    Assert.assertEquals((int)1, (int)data.size());
                    Assert.assertEquals((Object)"test object", data.get(0));
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    if (!"getAutoCommit[]".equals(method) && !"setAutoCommit[boolean]".equals(method)) {
                        if ("commit[]".equals(method)) {
                            SQLInterfaceConnectionTest.fail((String)"invalid method call");
                        } else {
                            Assert.assertTrue((boolean)true);
                        }
                    }
                }
            });
            CommandDataPair pair = new CommandDataPair();
            pair.addData((Object)"test object");
            this.target.addCommand(pair);
            this.target.setAutoCommit(true);
            this.target.commit();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCommitWith() {
        try {
            SQLInterfaceEventProcessor.newInstance().clearListener();
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"commit", (String)event.state);
                    List pairs = event.pair;
                    Assert.assertEquals((int)1, (int)pairs.size());
                    List data = ((CommandDataPair)pairs.get(0)).getData();
                    Assert.assertEquals((int)1, (int)data.size());
                    Assert.assertEquals((Object)"test object", data.get(0));
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    if (!"getAutoCommit[]".equals(method) && !"".equals(method)) {
                        Assert.assertEquals((String)"commit[]", (String)method);
                    }
                }
            });
            ManualTransactionEvent e = new ManualTransactionEvent();
            e.state = "commit";
            CommandDataPair pair = new CommandDataPair();
            pair.addData((Object)"test object");
            e.pair.add(pair);
            this.target.commitWith((SQLInterfaceEvent)e);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRollback() {
        try {
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().clearListener();
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"rollback", (String)event.state);
                    List pairs = event.pair;
                    Assert.assertEquals((int)1, (int)pairs.size());
                    List data = ((CommandDataPair)pairs.get(0)).getData();
                    Assert.assertEquals((int)1, (int)data.size());
                    Assert.assertEquals((Object)"test object", data.get(0));
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"rollback[]", (String)method);
                }
            });
            CommandDataPair pair = new CommandDataPair();
            pair.addData((Object)"test object");
            this.target.addCommand(pair);
            this.target.rollback();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRollbackError() {
        try {
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().clearListener();
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"rollback", (String)event.state);
                    List pairs = event.pair;
                    Assert.assertEquals((int)1, (int)pairs.size());
                    List data = ((CommandDataPair)pairs.get(0)).getData();
                    Assert.assertEquals((int)1, (int)data.size());
                    Assert.assertEquals((Object)"test object", data.get(0));
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"rollback[]", (String)method);
                }
            });
            CommandDataPair pair = new CommandDataPair();
            pair.addData((Object)"test object");
            this.target.addCommand(pair);
            this.target.rollback();
        }
        catch (SQLException e) {
            Assert.assertEquals((String)"rollback error", (String)e.getMessage());
        }
    }

    @Test
    public void testRollbackWith() {
        try {
            this.target.setUseManualTransaction(true);
            SQLInterfaceEventProcessor.newInstance().clearListener();
            SQLInterfaceEventProcessor.newInstance().addEventListener((SQLInterfaceEventListener)new SQLInterfaceEventListener<ManualTransactionEvent>(){

                public void handle(ManualTransactionEvent event) {
                    Assert.assertEquals((String)"rollback", (String)event.state);
                }
            });
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"rollback[]", (String)method);
                }
            });
            ManualTransactionEvent e = new ManualTransactionEvent();
            e.state = "rollback";
            this.target.rollbackWith((SQLInterfaceEvent)e);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testClose() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"close[]", (String)method);
                }
            });
            this.target.close();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsClosed() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isClosed[]", (String)method);
                }
            });
            this.target.isClosed();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMetaData() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getMetaData[]", (String)method);
                }
            });
            this.target.getMetaData();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetReadOnly() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setReadOnly[boolean]", (String)method);
                }
            });
            this.target.setReadOnly(true);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsReadOnly() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isReadOnly[]", (String)method);
                }
            });
            this.target.isReadOnly();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetCatalog() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setCatalog[String]", (String)method);
                }
            });
            this.target.setCatalog("");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetCatalog() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getCatalog[]", (String)method);
                }
            });
            this.target.getCatalog();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTransactionIsolation() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setTransactionIsolation[int]", (String)method);
                }
            });
            this.target.setTransactionIsolation(0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetTransactionIsolation() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getTransactionIsolation[]", (String)method);
                }
            });
            this.target.getTransactionIsolation();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetWarnings() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getWarnings[]", (String)method);
                }
            });
            this.target.getWarnings();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testClearWarnings() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"clearWarnings[]", (String)method);
                }
            });
            this.target.clearWarnings();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateStatementIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createStatement[int,int]", (String)method);
                }
            });
            this.target.createStatement(0, 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementStringIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String,int,int]", (String)method);
                }
            });
            this.target.prepareStatement("", 0, 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareCallStringIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareCall[String,int,int]", (String)method);
                }
            });
            this.target.prepareCall("", 0, 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetTypeMap() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getTypeMap[]", (String)method);
                }
            });
            this.target.getTypeMap();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetTypeMap() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setTypeMap[Map<String, Class<?>>]", (String)method);
                }
            });
            this.target.setTypeMap(null);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetHoldability() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setHoldability[int]", (String)method);
                }
            });
            this.target.setHoldability(0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetHoldability() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getHoldability[]", (String)method);
                }
            });
            this.target.getHoldability();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetSavepoint() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setSavepoint[]", (String)method);
                }
            });
            this.target.setSavepoint();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetSavepointString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setSavepoint[String]", (String)method);
                }
            });
            this.target.setSavepoint("");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRollbackSavepoint() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"rollback[Savepoint]", (String)method);
                }
            });
            this.target.rollback(null);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReleaseSavepoint() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"releaseSavepoint[Savepoint]", (String)method);
                }
            });
            this.target.releaseSavepoint(null);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateStatementIntIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createStatement[int,int,int]", (String)method);
                }
            });
            this.target.createStatement(0, 0, 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementStringIntIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String,int,int,int]", (String)method);
                }
            });
            this.target.prepareStatement("", 0, 0, 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareCallStringIntIntInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareCall[String,int,int,int]", (String)method);
                }
            });
            this.target.prepareCall("", 0, 0, 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementStringInt() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String,int]", (String)method);
                }
            });
            this.target.prepareStatement("", 0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementStringIntArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String,int[]]", (String)method);
                }
            });
            this.target.prepareStatement("", new int[0]);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPrepareStatementStringStringArray() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"prepareStatement[String,String[]]", (String)method);
                }
            });
            this.target.prepareStatement("", new String[0]);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateClob() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createClob[]", (String)method);
                }
            });
            this.target.createClob();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateBlob() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createBlob[]", (String)method);
                }
            });
            this.target.createBlob();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateNClob() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createNClob[]", (String)method);
                }
            });
            this.target.createNClob();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateSQLXML() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createSQLXML[]", (String)method);
                }
            });
            this.target.createSQLXML();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsValid() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"isValid[int]", (String)method);
                }
            });
            this.target.isValid(0);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetClientInfoStringString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setClientInfo[String,String]", (String)method);
                }
            });
            this.target.setClientInfo("", "");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetClientInfoProperties() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"setClientInfo[Properties]", (String)method);
                }
            });
            this.target.setClientInfo(null);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetClientInfoString() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getClientInfo[String]", (String)method);
                }
            });
            this.target.getClientInfo("");
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetClientInfo() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"getClientInfo[]", (String)method);
                }
            });
            this.target.getClientInfo();
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateArrayOf() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createArrayOf[String,Object[]]", (String)method);
                }
            });
            this.target.createArrayOf("", new Object[0]);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateStruct() {
        try {
            this.methodCall.addListener(new Listener(){

                public void handle(String method) {
                    Assert.assertEquals((String)"createStruct[String,Object[]]", (String)method);
                }
            });
            this.target.createStruct("", new Object[0]);
        }
        catch (SQLException e) {
            SQLInterfaceConnectionTest.fail((String)e.getMessage());
        }
    }

    private static class MethodParameter {
        private Map<String, Object> paramMap = new LinkedHashMap<String, Object>();

        private MethodParameter() {
        }

        private void addParam(String className, Object param) {
            this.paramMap.put(className, param);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.paramMap == null ? 0 : this.paramMap.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodParameter other = (MethodParameter)obj;
            return !(this.paramMap == null ? other.paramMap != null : !this.paramMap.equals(other.paramMap));
        }
    }
}

