/*
 * Decompiled with CFR 0.152.
 */
package sos.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class JGenericPanel
extends JPanel {
    private int nItem = 0;
    private ArrayList<JSpinner> listNumberSpinner = new ArrayList();
    private ArrayList<JFormattedTextField> listNumberField = new ArrayList();
    private ArrayList<JComboBox> listChoiceField = new ArrayList();

    public JGenericPanel() {
        this.initComponents();
    }

    private GridBagConstraints getGridBagConstraints(int x, int y, boolean isLabel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = 1;
        if (isLabel) {
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 10, 0, 1);
        } else {
            constraints.fill = 2;
            constraints.insets = new Insets(0, 1, 0, 10);
        }
        return constraints;
    }

    public void addChoice(String label, String[] items, int defaultItemIndex) {
        JComboBox<String> comboBox = new JComboBox<String>();
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
        comboBox.setSelectedIndex(defaultItemIndex);
        this.addComponent(label, this.listChoiceField, comboBox);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMinimumFractionDigits(digits);
        nf.setMaximumFractionDigits(digits);
        JFormattedTextField formattedField = new JFormattedTextField(nf);
        formattedField.setValue(defaultValue);
        formattedField.setPreferredSize(new Dimension(80, 18));
        formattedField.setHorizontalAlignment(4);
        this.addComponent(label, this.listNumberField, formattedField);
    }

    public void addNumericSpinner(String label, SpinnerNumberModel model) {
        JSpinner spinner = new JSpinner(model);
        spinner.setPreferredSize(new Dimension(80, 18));
        this.addComponent(label, this.listNumberSpinner, spinner);
    }

    private void addComponent(String label, ArrayList list, JComponent component) {
        JLabel jLabel = new JLabel(label);
        this.add((Component)jLabel, this.getGridBagConstraints(0, this.nItem, true));
        this.add((Component)component, this.getGridBagConstraints(1, this.nItem, false));
        list.add(component);
        ++this.nItem;
    }

    public Object getSpinnerNumber(int componentIndex) {
        JSpinner spinner = this.listNumberSpinner.get(componentIndex);
        return spinner.getValue();
    }

    public double getFieldNumber(int componentIndex) {
        JFormattedTextField formattedField = this.listNumberField.get(componentIndex);
        try {
            formattedField.commitEdit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Number)formattedField.getValue()).doubleValue();
    }

    public int getChoiceIndex(int componentIndex) {
        JComboBox comboBox = this.listChoiceField.get(componentIndex);
        return comboBox.getSelectedIndex();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent evt) {
                JGenericPanel.this.formComponentHidden(evt);
            }

            public void componentShown(ComponentEvent evt) {
                JGenericPanel.this.formComponentShown(evt);
            }
        });
    }

    private void formComponentShown(ComponentEvent evt) {
        System.out.println("Hidden");
    }

    private void formComponentHidden(ComponentEvent evt) {
        System.out.println("Hidden");
    }
}

