/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import javax.swing.JPanel;
import sos.math.Unit;
import sos.process.ImageInfo;
import sos.util.Sets;

public abstract class Clustering {
    protected int dim;
    protected int nInput;
    protected double[][] inputD;
    protected int[] cluster;
    protected int nUnit;
    protected Unit[] units;
    protected double evaluatedValue = 0.0;
    protected double desiredValue;
    protected JPanel optionPanel;

    public abstract void setParameters(ImageInfo var1);

    public abstract void calculate();

    public abstract boolean isConvoluted();

    public void setInput(double[][] i) {
        this.inputD = i;
        this.nInput = i.length;
        this.cluster = new int[this.nInput];
        this.dim = this.inputD[0].length;
    }

    public final void setUnit(double[][] u) {
        this.nUnit = u.length;
        this.units = new Unit[this.nUnit];
        for (int un = 0; un < this.nUnit; ++un) {
            this.units[un] = new Unit(this.dim);
            System.arraycopy(u[un], 0, this.units[un].mean, 0, this.dim);
        }
    }

    public final int getNUnit() {
        return this.nUnit;
    }

    public final double getNumber(int index) {
        return this.units[index].nBelong;
    }

    public final double[][] getCopyOfUnitD() {
        double[][] result = new double[this.nUnit][this.dim];
        for (int un = 0; un < this.nUnit; ++un) {
            for (int d = 0; d < this.dim; ++d) {
                result[un][d] = this.units[un].mean[d];
            }
        }
        return result;
    }

    public final int[][] getMean() {
        int[][] meanInt = new int[this.nUnit][this.dim];
        for (int un = 0; un < this.nUnit; ++un) {
            for (int d = 0; d < this.dim; ++d) {
                meanInt[un][d] = (int)Math.round(this.units[un].mean[d]);
            }
        }
        return meanInt;
    }

    public final int[] getMean(int index) {
        int[] meanInt = new int[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            meanInt[d] = (int)Math.round(this.units[index].mean[d]);
        }
        return meanInt;
    }

    public final double[][] getMeanD() {
        double[][] result = new double[this.nUnit][];
        for (int un = 0; un < this.nUnit; ++un) {
            result[un] = this.units[un].mean;
        }
        return result;
    }

    public final double[] getMeanD(int index) {
        return this.units[index].mean;
    }

    protected final void calcMean(boolean needBackup) {
        int un;
        if (needBackup) {
            for (un = 0; un < this.nUnit; ++un) {
                this.units[un].backupMean();
            }
        }
        this.evaluatedValue = 0.0;
        for (un = 0; un < this.nUnit; ++un) {
            this.units[un].calcMean();
            this.evaluatedValue += this.units[un].calcMeanDifference();
        }
    }

    public final void setCluster(int[] cluster) {
        this.cluster = cluster;
    }

    public final void setCluster(int index, int value) {
        this.cluster[index] = value;
    }

    public final int[] getCluster() {
        return this.cluster;
    }

    public void sortUnits(int[] order) {
        Unit[] newUnits = new Unit[this.nUnit];
        for (int un = 0; un < this.nUnit; ++un) {
            newUnits[un] = this.units[order[un]];
        }
        this.units = newUnits;
    }

    public double getEvaluatedValue() {
        return this.evaluatedValue;
    }

    public void setDesiredValue(double value) {
        this.desiredValue = value;
    }

    public JPanel getOptionPanel() {
        return this.optionPanel;
    }

    protected void initCalculation() {
        for (int un = 0; un < this.nUnit; ++un) {
            this.units[un].initCalculation();
        }
    }

    public void moveUnitsToNearestInputs() {
        for (int un = 0; un < this.nUnit; ++un) {
            int m = Sets.findNearest(this.inputD, this.units[un].mean);
            System.arraycopy(this.inputD[m], 0, this.units[un].mean, 0, this.dim);
        }
    }
}

