/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import ij.IJ;

public final class MathMx {
    static final double EPS = 1.0E-16;
    static final double TINY = 1.0E-32;
    static final int MAX_ITER = 30000;

    public static final void copy(double[][] source, double[][] dist) {
        for (int y = 0; y < source.length; ++y) {
            System.arraycopy(source[y], 0, dist[y], 0, source[y].length);
        }
    }

    public static final double[][] copy(double[][] mx) {
        double[][] newMx = new double[mx.length][mx[0].length];
        MathMx.copy(mx, newMx);
        return newMx;
    }

    public static final void clear(double[][] mx) {
        for (int y = 0; y < mx.length; ++y) {
            for (int x = 0; x < mx[0].length; ++x) {
                mx[y][x] = 0.0;
            }
        }
    }

    public static final void toUnit(double[][] mx, double alfa) {
        MathMx.clear(mx);
        for (int y = 0; y < mx.length; ++y) {
            mx[y][y] = alfa;
        }
    }

    public static final int[][] transpose(int[][] mx) {
        int[][] result = new int[mx[0].length][mx.length];
        for (int y = 0; y < mx.length; ++y) {
            for (int x = 0; x < mx[0].length; ++x) {
                result[x][y] = mx[y][x];
            }
        }
        return result;
    }

    public static final double[][] transpose(double[][] mx) {
        double[][] result = new double[mx[0].length][mx.length];
        for (int y = 0; y < mx.length; ++y) {
            for (int x = 0; x < mx[0].length; ++x) {
                result[x][y] = mx[y][x];
            }
        }
        return result;
    }

    public static final double[][] exchangeRow(double[][] mx) {
        if (mx.length != 2) {
            return null;
        }
        double[][] newMx = new double[2][];
        newMx[1] = mx[0];
        newMx[0] = mx[1];
        return newMx;
    }

    public static final void exchangeRow(int i, int j, double[][] mx) {
        double[] temp = mx[i];
        mx[i] = mx[j];
        mx[j] = temp;
    }

    public static final void add(int[][] mx1, int[][] mx2) {
        for (int y = 0; y < mx1.length; ++y) {
            for (int x = 0; x < mx1[0].length; ++x) {
                int[] nArray = mx1[y];
                int n = x;
                nArray[n] = nArray[n] + mx2[y][x];
            }
        }
    }

    public static final void add(double[][] mx1, double[][] mx2) {
        for (int y = 0; y < mx1.length; ++y) {
            for (int x = 0; x < mx1[0].length; ++x) {
                double[] dArray = mx1[y];
                int n = x;
                dArray[n] = dArray[n] + mx2[y][x];
            }
        }
    }

    public static final void scale(double[][] mx, double value) {
        for (int y = 0; y < mx.length; ++y) {
            int x = 0;
            while (x < mx[0].length) {
                double[] dArray = mx[y];
                int n = x++;
                dArray[n] = dArray[n] * value;
            }
        }
    }

    public static final void scaleDivide(int[][] mx, int value) {
        for (int y = 0; y < mx.length; ++y) {
            for (int x = 0; x < mx[0].length; ++x) {
                mx[y][x] = (int)Math.round(1.0 * (double)mx[y][x] / (double)value);
            }
        }
    }

    public static final void scaleDivide(double[][] mx, double value) {
        for (int y = 0; y < mx.length; ++y) {
            int x = 0;
            while (x < mx[0].length) {
                double[] dArray = mx[y];
                int n = x++;
                dArray[n] = dArray[n] / value;
            }
        }
    }

    public static final double[][] harmonicMean(double[][] mx1, double[][] mx2, double r1, double r2) {
        double[][] result = new double[mx1.length][mx1[0].length];
        double r = r1 + r2;
        for (int y = 0; y < mx1.length; ++y) {
            for (int x = 0; x < mx1[0].length; ++x) {
                result[y][x] = (r1 * mx1[y][x] + r2 * mx2[y][x]) / r;
            }
        }
        return result;
    }

    public static final double[][] random(double[][] mx) {
        double[][] result = new double[mx.length][mx[0].length];
        for (int y = 0; y < mx.length; ++y) {
            for (int x = 0; x < mx[0].length; ++x) {
                result[y][x] = mx[y][x] * (0.2 * Math.random() + 0.9);
            }
        }
        return result;
    }

    public static final double[] multiple(double[] vec, double[][] mx) {
        double[] result = new double[vec.length];
        MathMx.multiple(vec, mx, result);
        return result;
    }

    public static final void multiple(double[] vec, double[][] mx, double[] result) {
        for (int i = 0; i < mx[0].length; ++i) {
            double value = 0.0;
            for (int j = 0; j < mx.length; ++j) {
                value += vec[j] * mx[j][i];
            }
            result[i] = value;
        }
    }

    public static final void multiple(int[] vec, double[][] mx, double[] result) {
        for (int i = 0; i < mx[0].length; ++i) {
            double value = 0.0;
            for (int j = 0; j < mx.length; ++j) {
                value += (double)vec[j] * mx[j][i];
            }
            result[i] = value;
        }
    }

    public static final void multiple(double[][] mx, int[] vec, double[] result) {
        for (int y = 0; y < mx.length; ++y) {
            double value = 0.0;
            for (int x = 0; x < mx[0].length; ++x) {
                value += (double)vec[x] * mx[y][x];
            }
            result[y] = value;
        }
    }

    public static final void multiple(double[] vec, double[][] mx, int[] result) {
        for (int i = 0; i < mx[0].length; ++i) {
            double value = 0.0;
            for (int j = 0; j < mx.length; ++j) {
                value += vec[j] * mx[j][i];
            }
            result[i] = (int)Math.round(value);
        }
    }

    public static final void multiple(int[] vec, double[][] mx, int[] result) {
        if (vec == result) {
            int[] dist = new int[vec.length];
            MathMx.multiple(vec, mx, dist);
            result = dist;
        }
        for (int i = 0; i < mx[0].length; ++i) {
            double value = 0.0;
            for (int j = 0; j < mx.length; ++j) {
                value += (double)vec[j] * mx[j][i];
            }
            result[i] = (int)Math.round(value);
        }
    }

    public static final double[][] multiple(double[][] mx1, double[][] mx2) {
        double[][] result = new double[mx1.length][mx2[0].length];
        MathMx.multiple(mx1, mx2, result);
        return result;
    }

    public static final void multiple(double[][] mx1, double[][] mx2, double[][] result) {
        for (int y = 0; y < result.length; ++y) {
            for (int x = 0; x < result[y].length; ++x) {
                result[y][x] = 0.0;
                for (int i = 0; i < mx1[y].length; ++i) {
                    double[] dArray = result[y];
                    int n = x;
                    dArray[n] = dArray[n] + mx1[y][i] * mx2[i][x];
                }
            }
        }
    }

    public static final int[][] multiple(int[][] mx1, int[][] mx2) {
        int[][] result = new int[mx1.length][mx2[0].length];
        for (int y = 0; y < result.length; ++y) {
            for (int x = 0; x < result[y].length; ++x) {
                int value = 0;
                for (int i = 0; i < mx1[y].length; ++i) {
                    value += mx1[y][i] * mx2[i][x];
                }
                result[y][x] = value;
            }
        }
        return result;
    }

    public static final int[][] multiple(int[][] mx1, double[][] mx2) {
        int[][] result = new int[mx1.length][mx2[0].length];
        for (int y = 0; y < result.length; ++y) {
            for (int x = 0; x < result[y].length; ++x) {
                double value = 0.0;
                for (int i = 0; i < mx1[y].length; ++i) {
                    value += (double)mx1[y][i] * mx2[i][x];
                }
                result[y][x] = (int)Math.round(value);
            }
        }
        return result;
    }

    public static final double inverse(double[][] originalMx, double[][] iMx) {
        double[][] mx = new double[originalMx.length][originalMx[0].length];
        MathMx.copy(originalMx, mx);
        MathMx.clear(iMx);
        int nRow = mx.length;
        int[] rowOrder = new int[nRow];
        double det = MathMx.lu(mx, rowOrder);
        if (det == 0.0) {
            return 0.0;
        }
        for (int x = 0; x < nRow; ++x) {
            int j;
            double value;
            int row;
            int y;
            for (y = 0; y < nRow; ++y) {
                row = rowOrder[y];
                value = row == x ? 1.0 : 0.0;
                for (j = 0; j < y; ++j) {
                    value -= mx[row][j] * iMx[j][x];
                }
                iMx[y][x] = value;
            }
            for (y = nRow - 1; y >= 0; --y) {
                value = iMx[y][x];
                row = rowOrder[y];
                for (j = y + 1; j < nRow; ++j) {
                    value -= mx[row][j] * iMx[j][x];
                }
                iMx[y][x] = value / mx[row][y];
            }
        }
        return det;
    }

    private static final double lu(double[][] mx, int[] rowOrder) {
        double value;
        double sentinel;
        int nRow = mx.length;
        double[] weight = new double[nRow];
        for (int y = 0; y < nRow; ++y) {
            rowOrder[y] = y;
            sentinel = 0.0;
            for (int x = 0; x < nRow; ++x) {
                value = Math.abs(mx[y][x]);
                if (!(value > sentinel)) continue;
                sentinel = value;
            }
            if (sentinel == 0.0) {
                return 0.0;
            }
            weight[y] = 1.0 / sentinel;
        }
        double det = 1.0;
        int m = nRow;
        for (int y = 0; y < nRow; ++y) {
            int ii;
            int i;
            sentinel = -1.0;
            for (i = y; i < nRow; ++i) {
                ii = rowOrder[i];
                value = Math.abs(mx[ii][y]) * weight[ii];
                if (!(value > sentinel)) continue;
                sentinel = value;
                m = i;
            }
            int iy = rowOrder[m];
            if (m != y) {
                rowOrder[m] = rowOrder[y];
                rowOrder[y] = iy;
                det = -det;
            }
            sentinel = mx[iy][y];
            det *= sentinel;
            if (sentinel == 0.0) {
                return 0.0;
            }
            for (i = y + 1; i < nRow; ++i) {
                ii = rowOrder[i];
                double[] dArray = mx[ii];
                int n = y;
                dArray[n] = dArray[n] / sentinel;
                value = mx[ii][y];
                for (int x = y + 1; x < nRow; ++x) {
                    double[] dArray2 = mx[ii];
                    int n2 = x;
                    dArray2[n2] = dArray2[n2] - value * mx[iy][x];
                }
            }
        }
        return det;
    }

    public static boolean eigenJacobi(double[][] a, double[][] w) {
        double t;
        int k;
        int iter;
        int n = a.length;
        double s = 0.0;
        double offdiag = 0.0;
        for (int j = 0; j < n; ++j) {
            int k2;
            for (k2 = 0; k2 < n; ++k2) {
                w[j][k2] = 0.0;
            }
            w[j][j] = 1.0;
            s += a[j][j] * a[j][j];
            for (k2 = j + 1; k2 < n; ++k2) {
                offdiag += a[j][k2] * a[j][k2];
            }
        }
        double tolerance = 9.999999999999999E-33 * (s / 2.0 + offdiag);
        for (iter = 1; iter <= 30000; ++iter) {
            int j;
            offdiag = 0.0;
            for (j = 0; j < n - 1; ++j) {
                for (k = j + 1; k < n; ++k) {
                    offdiag += a[j][k] * a[j][k];
                }
            }
            if (offdiag < tolerance) break;
            for (j = 0; j < n - 1; ++j) {
                for (k = j + 1; k < n; ++k) {
                    int i;
                    if (Math.abs(a[j][k]) < 1.0E-32) continue;
                    t = (a[k][k] - a[j][j]) / (2.0 * a[j][k]);
                    t = t >= 0.0 ? 1.0 / (t + Math.sqrt(t * t + 1.0)) : 1.0 / (t - Math.sqrt(t * t + 1.0));
                    double c = 1.0 / Math.sqrt(t * t + 1.0);
                    double u = t * c;
                    double[] dArray = a[j];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - (t *= a[j][k]);
                    double[] dArray2 = a[k];
                    int n3 = k;
                    dArray2[n3] = dArray2[n3] + t;
                    a[j][k] = 0.0;
                    for (i = 0; i < j; ++i) {
                        MathMx.rotate(a, i, j, i, k, c, u);
                    }
                    for (i = j + 1; i < k; ++i) {
                        MathMx.rotate(a, j, i, i, k, c, u);
                    }
                    for (i = k + 1; i < n; ++i) {
                        MathMx.rotate(a, j, i, k, i, c, u);
                    }
                    for (i = 0; i < n; ++i) {
                        MathMx.rotate(w, j, i, k, i, c, u);
                    }
                }
            }
        }
        if (iter > 30000) {
            return false;
        }
        for (int i = 0; i < n - 1; ++i) {
            k = i;
            t = a[k][k];
            for (int j = i + 1; j < n; ++j) {
                if (!(a[j][j] > t)) continue;
                k = j;
                t = a[k][k];
            }
            a[k][k] = a[i][i];
            a[i][i] = t;
            double[] v = w[k];
            w[k] = w[i];
            w[i] = v;
        }
        return true;
    }

    private static void rotate(double[][] a, int i, int j, int k, int l, double c, double s) {
        double x = a[i][j];
        double y = a[k][l];
        a[i][j] = x * c - y * s;
        a[k][l] = x * s + y * c;
    }

    public static void write(double[][] mx, int dec) {
        for (int y = 0; y < mx.length; ++y) {
            String arg = "";
            for (int x = 0; x < mx[y].length; ++x) {
                arg = arg + IJ.d2s((double)mx[y][x], (int)dec) + ", ";
            }
            IJ.write((String)arg);
        }
    }
}

