/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import java.util.Arrays;
import sos.math.MathMx;

public final class Statistics {
    static final double LN2 = Math.log(2.0);
    int dim;
    int nInput;
    double[] mean;
    double[] variance;
    double[] sd;
    double[] min;
    double[] max;
    double[] midpoint;
    double[] eigenValue;
    double[] entropyBit;
    double[] entropyDigit;
    double[] conditionalEntropy;
    double[][] covarMx;
    double[][] correlMx;
    double[][] eigenVector;
    double[][] eigenValuedVector;
    double[][] relativeCumHistogram;
    int[][] histogram;
    int[][] cumHistogram;
    private double[][] input;

    public Statistics(double[][] data) {
        this.input = data;
        this.nInput = this.input.length;
        this.dim = this.input[0].length;
    }

    public final void reset() {
        this.input = null;
        this.nInput = 0;
    }

    public final double[][] getInput() {
        return this.input;
    }

    public final void addInput(double[][] additional) {
        double[][] newInput = new double[this.nInput + additional.length][this.dim];
        System.arraycopy(this.input, 0, newInput, 0, this.nInput);
        System.arraycopy(additional, 0, newInput, this.nInput, additional.length);
        this.input = newInput;
        this.nInput = this.input.length;
        this.clear();
    }

    public final void clear() {
        this.mean = null;
        this.variance = null;
        this.sd = null;
        this.min = null;
        this.max = null;
        this.midpoint = null;
        this.eigenValue = null;
        this.covarMx = null;
        this.correlMx = null;
        this.eigenVector = null;
        this.eigenValuedVector = null;
        this.relativeCumHistogram = null;
        this.histogram = null;
        this.cumHistogram = null;
        this.entropyBit = null;
        this.entropyDigit = null;
        this.conditionalEntropy = null;
    }

    public final double[] getMean() {
        if (this.mean != null) {
            return this.mean;
        }
        this.mean = new double[this.dim];
        for (int in = 0; in < this.nInput; ++in) {
            for (int d = 0; d < this.dim; ++d) {
                int n = d;
                this.mean[n] = this.mean[n] + this.input[in][d];
            }
        }
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.mean[n] = this.mean[n] / (double)this.nInput;
        }
        return this.mean;
    }

    public final double[] getEntropyBit() {
        if (this.entropyBit != null) {
            return this.entropyBit;
        }
        this.getMean();
        int[] histogram = new int[2];
        this.entropyBit = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            Arrays.fill(histogram, 0);
            for (int in = 0; in < this.nInput; ++in) {
                if (this.input[in][d] <= this.mean[d]) {
                    histogram[0] = histogram[0] + 1;
                    continue;
                }
                histogram[1] = histogram[1] + 1;
            }
            this.entropyBit[d] = this.calcEntropy(histogram);
        }
        return this.entropyBit;
    }

    public final double getEntropyBit(int index, int[] neighbor) {
        if (this.conditionalEntropy != null && this.conditionalEntropy[index] > 0.0) {
            return this.conditionalEntropy[index];
        }
        if (this.conditionalEntropy == null) {
            this.conditionalEntropy = new double[this.dim];
            Arrays.fill(this.conditionalEntropy, -1.0);
        }
        this.getMean();
        int[][] map = new int[2][2];
        for (int in = 0; in < this.nInput; ++in) {
            int i = this.input[in][index] <= this.mean[index] ? 0 : 1;
            int j = this.input[neighbor[in]][index] <= this.mean[index] ? 0 : 1;
            int[] nArray = map[i];
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        this.conditionalEntropy[index] = this.calcEntropy(map);
        return this.conditionalEntropy[index];
    }

    public final double[] getEntropyDigit() {
        if (this.entropyDigit != null) {
            return this.entropyDigit;
        }
        this.calcMinMax();
        this.entropyDigit = new double[this.dim];
        this.getHistogram(10);
        for (int d = 0; d < this.dim; ++d) {
            this.entropyDigit[d] = this.calcEntropy(this.histogram[d]);
        }
        return this.entropyDigit;
    }

    private double calcEntropy(int[] histogram) {
        double entropy = 0.0;
        for (int h = 0; h < histogram.length; ++h) {
            double p = 1.0 * (double)histogram[h] / (double)this.nInput;
            if (!(p > 0.0)) continue;
            entropy -= p * Math.log(p);
        }
        return entropy /= LN2;
    }

    private double calcEntropy(int[][] map) {
        double entropyMarkov = 0.0;
        for (int i = 0; i < map.length; ++i) {
            int j;
            int sum = 0;
            for (j = 0; j < map[i].length; ++j) {
                sum += map[i][j];
            }
            if (sum <= 0) continue;
            double entropyNeighbor = 0.0;
            for (j = 0; j < map[i].length; ++j) {
                double piJ = 1.0 * (double)map[i][j] / (double)sum;
                if (map[i][j] <= 0) continue;
                entropyNeighbor += -piJ * Math.log(piJ);
            }
            entropyMarkov += entropyNeighbor * (double)sum / (double)this.nInput;
        }
        return entropyMarkov /= LN2;
    }

    public final double[] getVariance() {
        if (this.variance != null) {
            return this.variance;
        }
        if (this.mean == null) {
            this.getMean();
        }
        this.variance = new double[this.dim];
        for (int in = 0; in < this.nInput; ++in) {
            for (int d = 0; d < this.dim; ++d) {
                int n = d;
                this.variance[n] = this.variance[n] + (this.mean[d] - this.input[in][d]) * (this.mean[d] - this.input[in][d]);
            }
        }
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.variance[n] = this.variance[n] / (double)this.nInput;
        }
        return this.variance;
    }

    public final double[] getSD() {
        if (this.sd != null) {
            return this.sd;
        }
        if (this.variance == null) {
            this.getVariance();
        }
        this.sd = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.sd[d] = Math.sqrt(this.variance[d]);
        }
        return this.sd;
    }

    public final double[] getMin() {
        this.calcMinMax();
        return this.min;
    }

    public final double[] getMax() {
        this.calcMinMax();
        return this.max;
    }

    private final void calcMinMax() {
        if (this.min != null && this.max != null) {
            return;
        }
        this.min = new double[this.dim];
        this.max = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.min[d] = this.input[0][d];
            this.max[d] = this.input[0][d];
        }
        for (int in = 0; in < this.nInput; ++in) {
            for (int d = 0; d < this.dim; ++d) {
                if (this.input[in][d] < this.min[d]) {
                    this.min[d] = this.input[in][d];
                    continue;
                }
                if (!(this.max[d] < this.input[in][d])) continue;
                this.max[d] = this.input[in][d];
            }
        }
    }

    public final double[] getMidpoint() {
        if (this.min == null || this.max == null) {
            this.calcMinMax();
        }
        this.midpoint = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            this.midpoint[d] = (this.min[d] + this.max[d]) / 2.0;
        }
        return this.midpoint;
    }

    public final double[][] getCovariance() {
        int x;
        int y;
        if (this.covarMx != null) {
            return this.covarMx;
        }
        this.getMean();
        this.covarMx = new double[this.dim][this.dim];
        double[] difVec = new double[this.dim];
        for (int n = 0; n < this.nInput; ++n) {
            for (int d = 0; d < this.dim; ++d) {
                difVec[d] = this.input[n][d] - this.mean[d];
            }
            for (int y2 = 0; y2 < this.dim; ++y2) {
                for (int x2 = y2; x2 < this.dim; ++x2) {
                    double[] dArray = this.covarMx[y2];
                    int n2 = x2;
                    dArray[n2] = dArray[n2] + difVec[y2] * difVec[x2];
                }
            }
        }
        for (y = 0; y < this.dim; ++y) {
            x = y;
            while (x < this.dim) {
                double[] dArray = this.covarMx[y];
                int n = x++;
                dArray[n] = dArray[n] / (double)this.nInput;
            }
        }
        for (y = 0; y < this.dim; ++y) {
            for (x = y + 1; x < this.dim; ++x) {
                this.covarMx[x][y] = this.covarMx[y][x];
            }
        }
        return this.covarMx;
    }

    public final double[][] getCorrelation() {
        if (this.correlMx != null) {
            return this.correlMx;
        }
        this.getCovariance();
        if (this.sd == null) {
            if (this.variance == null) {
                for (int d = 0; d < this.dim; ++d) {
                    this.variance[d] = this.covarMx[d][d];
                }
            } else {
                this.getSD();
            }
        }
        this.correlMx = new double[this.dim][this.dim];
        for (int y = 0; y < this.dim; ++y) {
            for (int x = 0; x < this.dim; ++x) {
                this.correlMx[y][x] = this.covarMx[y][x] / (this.sd[y] * this.sd[x]);
            }
        }
        return this.correlMx;
    }

    public final double[] getEigenValue() {
        this.calcEigen();
        return this.eigenValue;
    }

    public final double[][] getEigenVector() {
        this.calcEigen();
        return this.eigenVector;
    }

    private final void calcEigen() {
        if (this.eigenValue != null && this.eigenVector != null) {
            return;
        }
        this.getCovariance();
        this.eigenValue = new double[this.dim];
        this.eigenVector = new double[this.dim][this.dim];
        double[][] mx = MathMx.copy(this.covarMx);
        MathMx.eigenJacobi(mx, this.eigenVector);
        for (int d = 0; d < this.dim; ++d) {
            this.eigenValue[d] = mx[d][d];
        }
    }

    public final double[][] getEigenValuedVector() {
        if (this.eigenValuedVector != null) {
            return this.eigenValuedVector;
        }
        this.calcEigen();
        this.eigenValuedVector = new double[this.dim][this.dim];
        for (int n = 0; n < this.dim; ++n) {
            double value = Math.sqrt(this.eigenValue[n]);
            for (int d = 0; d < this.dim; ++d) {
                this.eigenValuedVector[n][d] = this.eigenVector[n][d] * value;
            }
        }
        return this.eigenValuedVector;
    }

    public final int[][] getHistogram(int histMin, int histMax) {
        if (this.histogram != null) {
            return this.histogram;
        }
        int number = Math.abs(histMax - histMin) + 1;
        this.histogram = new int[this.dim][number];
        for (int in = 0; in < this.nInput; ++in) {
            for (int d = 0; d < this.dim; ++d) {
                int index = (int)this.input[in][d];
                if (index < histMin) {
                    index = histMin;
                } else if (histMax < index) {
                    index = histMax;
                }
                int[] nArray = this.histogram[d];
                int n = index - histMin;
                nArray[n] = nArray[n] + 1;
            }
        }
        return this.histogram;
    }

    public final int[][] getCumulativeHistogram(int histMin, int histMax) {
        if (this.cumHistogram != null) {
            return this.cumHistogram;
        }
        this.getHistogram(histMin, histMax);
        this.cumHistogram = new int[this.dim][];
        for (int d = 0; d < this.dim; ++d) {
            this.cumHistogram[d] = new int[this.histogram[d].length];
            this.cumHistogram[d][0] = this.histogram[d][0];
            for (int h = 1; h < this.histogram[d].length; ++h) {
                this.cumHistogram[d][h] = this.cumHistogram[d][h - 1] + this.histogram[d][h];
            }
        }
        return this.cumHistogram;
    }

    public final double[][] getRelativeCumHistogram(int histMin, int histMax) {
        if (this.relativeCumHistogram != null) {
            return this.relativeCumHistogram;
        }
        this.getCumulativeHistogram(histMin, histMax);
        this.relativeCumHistogram = new double[this.dim][];
        for (int d = 0; d < this.dim; ++d) {
            this.relativeCumHistogram[d] = new double[this.cumHistogram[d].length];
            for (int h = 0; h < this.cumHistogram[d].length; ++h) {
                this.relativeCumHistogram[d][h] = 1.0 * (double)this.cumHistogram[d][h] / (double)this.nInput;
            }
        }
        return this.relativeCumHistogram;
    }

    public final int[][] getHistogram(int number) {
        if (this.histogram != null && this.histogram[0].length == number) {
            return this.histogram;
        }
        this.calcMinMax();
        this.histogram = new int[this.dim][number];
        for (int d = 0; d < this.dim; ++d) {
            double classInterval = (this.max[d] - this.min[d]) / (double)number;
            for (int in = 0; in < this.nInput; ++in) {
                int classID = (int)((this.input[in][d] - this.min[d]) / classInterval);
                if (classID >= number) {
                    classID = number - 1;
                }
                int[] nArray = this.histogram[d];
                int n = classID;
                nArray[n] = nArray[n] + 1;
            }
        }
        return this.histogram;
    }

    public final int getMeanClass(int index) {
        return (int)((this.mean[index] - this.min[index]) * (double)this.histogram[index].length / (this.max[index] - this.min[index]));
    }

    public final int[][] getCumulativeHistogram(int number) {
        if (this.cumHistogram != null && this.cumHistogram[0].length == number) {
            return this.cumHistogram;
        }
        this.getHistogram(number);
        this.cumHistogram = new int[this.dim][number];
        for (int d = 0; d < this.dim; ++d) {
            this.cumHistogram[d][0] = this.histogram[d][0];
            for (int h = 1; h < number; ++h) {
                this.cumHistogram[d][h] = this.cumHistogram[d][h - 1] + this.histogram[d][h];
            }
        }
        return this.cumHistogram;
    }

    public final double[][] getRelativeCumHistogram(int number) {
        if (this.relativeCumHistogram != null && this.relativeCumHistogram[0].length == number) {
            return this.relativeCumHistogram;
        }
        this.getCumulativeHistogram(number);
        this.relativeCumHistogram = new double[this.dim][number];
        for (int d = 0; d < this.dim; ++d) {
            for (int h = 0; h < number; ++h) {
                this.relativeCumHistogram[d][h] = 1.0 * (double)this.cumHistogram[d][h] / (double)this.nInput;
            }
        }
        return this.relativeCumHistogram;
    }
}

