/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import ij.IJ;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import sos.math.MathMx;
import sos.math.MathVector;
import sos.math.Statistics;
import sos.util.Nucleus;

public class NuclearArray {
    public int maxWidth = 0;
    public int maxHeight = 0;
    Nucleus[] nuclei;
    Statistics stat;
    public int maxRWidth;
    public int maxRHeight;
    private Point[] rTopLefts;
    private int[] rWidths;
    private int[] rHeights;
    public int[][] rTexture;
    public int[] sortedIndex;
    public int totalArea;
    private double[][] results = null;
    public int[] nearestNeighbor;
    public int[] distance;
    private int imageWidth;

    public NuclearArray(int n, int width) {
        int i;
        this.nuclei = new Nucleus[n];
        for (i = 0; i < this.nuclei.length; ++i) {
            this.nuclei[i] = new Nucleus();
        }
        this.maxRWidth = 0;
        this.maxRHeight = 0;
        this.rTopLefts = new Point[n];
        this.rTexture = new int[n][];
        this.rWidths = new int[n];
        this.rHeights = new int[n];
        this.sortedIndex = new int[n];
        for (i = 0; i < n; ++i) {
            this.sortedIndex[i] = i;
        }
        this.imageWidth = width;
    }

    public final int[] getSizes() {
        int[] sizes = new int[this.nuclei.length];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.nuclei[i].size;
        }
        return sizes;
    }

    public final int getSize(int index) {
        return this.nuclei[index].size;
    }

    public final int[] getTexture(int index) {
        return this.nuclei[index].texture;
    }

    public final int getWidth(int index) {
        return this.nuclei[index].width;
    }

    public final int getHeight(int index) {
        return this.nuclei[index].height;
    }

    public final int getRotateWidth(int index) {
        return this.rWidths[index];
    }

    public final int getRotateHeight(int index) {
        return this.rHeights[index];
    }

    public final void adjustBound(int[] cluster, int threshold) {
        for (int pn = 0; pn < cluster.length; ++pn) {
            if (cluster[pn] <= threshold) continue;
            int x = pn % this.imageWidth;
            int y = pn / this.imageWidth;
            int index = cluster[pn];
            if (this.nuclei[index].topLeft == null) {
                this.nuclei[index].topLeft = new Point(x, y);
                continue;
            }
            if (x < this.nuclei[index].topLeft.x) {
                this.nuclei[index].width += this.nuclei[index].topLeft.x - x;
                this.nuclei[index].topLeft.x = x;
            } else if (x > this.nuclei[index].topLeft.x + this.nuclei[index].width - 1) {
                this.nuclei[index].width = x - this.nuclei[index].topLeft.x + 1;
            }
            if (y < this.nuclei[index].topLeft.y) {
                this.nuclei[index].height += this.nuclei[index].topLeft.y - y;
                this.nuclei[index].topLeft.y = y;
                continue;
            }
            if (y <= this.nuclei[index].topLeft.y + this.nuclei[index].height - 1) continue;
            this.nuclei[index].height = y - this.nuclei[index].topLeft.y + 1;
        }
        for (int n = 0; n < this.nuclei.length; ++n) {
            if (this.maxWidth < this.nuclei[n].width) {
                this.maxWidth = this.nuclei[n].width;
            }
            if (this.maxHeight >= this.nuclei[n].height) continue;
            this.maxHeight = this.nuclei[n].height;
        }
    }

    public final void setTexture(int[][] colorData, int[] cluster, int threshold) {
        for (int n = 0; n < this.nuclei.length; ++n) {
            this.nuclei[n].initTexture();
        }
        this.totalArea = 0;
        for (int pn = 0; pn < colorData.length; ++pn) {
            if (cluster[pn] <= threshold) continue;
            int x = pn % this.imageWidth;
            int y = pn / this.imageWidth;
            int index = cluster[pn];
            int offset = x - this.nuclei[index].topLeft.x + (y - this.nuclei[index].topLeft.y) * this.nuclei[index].width;
            this.nuclei[index].texture[offset] = colorData[pn][0] << 16 | colorData[pn][1] << 8 | colorData[pn][2];
            ++this.nuclei[index].size;
            ++this.totalArea;
        }
    }

    public final void rotate() {
        double[][] v = new double[2][2];
        double[] xy = new double[2];
        int[] intXY = new int[2];
        for (int n = 0; n < this.nuclei.length; ++n) {
            double[] loc = new double[this.nuclei[n].size * 2];
            int count = 0;
            for (int i = 0; i < this.nuclei[n].texture.length; ++i) {
                if (this.nuclei[n].texture[i] <= -1) continue;
                loc[count] = i % this.nuclei[n].width;
                loc[++count] = i / this.nuclei[n].width;
                ++count;
            }
            double[][] cov = MathVector.covariance(loc, 2);
            if (!MathMx.eigenJacobi(cov, v)) {
                IJ.write((String)"eigen error!");
            }
            AffineTransform at = new AffineTransform(v[0][0], -v[0][1], v[0][1], v[0][0], 0.0, 0.0);
            double[] rectPoints = new double[]{0.0, 0.0, 0.0, this.nuclei[n].height - 1, this.nuclei[n].width - 1, 0.0, this.nuclei[n].width - 1, this.nuclei[n].height - 1};
            at.transform(rectPoints, 0, rectPoints, 0, 4);
            this.getBounds(n, rectPoints);
            if (this.rWidths[n] > this.maxRWidth) {
                this.maxRWidth = this.rWidths[n];
            }
            if (this.rHeights[n] > this.maxRHeight) {
                this.maxRHeight = this.rHeights[n];
            }
            this.rTexture[n] = new int[this.rWidths[n] * this.rHeights[n]];
            Arrays.fill(this.rTexture[n], -1);
            for (int y = 0; y < this.rHeights[n]; ++y) {
                for (int x = 0; x < this.rWidths[n]; ++x) {
                    int index;
                    try {
                        at.inverseTransform(new double[]{this.rTopLefts[n].x + x, this.rTopLefts[n].y + y}, 0, xy, 0, 1);
                    }
                    catch (Exception e) {
                        IJ.write((String)"error inverse");
                    }
                    intXY[0] = (int)Math.round(xy[0]);
                    intXY[1] = (int)Math.round(xy[1]);
                    if (!this.contain(intXY[0], intXY[1], n) || this.nuclei[n].texture[index = intXY[0] + intXY[1] * this.nuclei[n].width] <= -1) continue;
                    this.rTexture[n][x + y * this.rWidths[n]] = this.nuclei[n].texture[index];
                }
            }
        }
    }

    private void getBounds(int index, double[] bounds) {
        double minX = bounds[0];
        double minY = bounds[1];
        double maxX = bounds[0];
        double maxY = bounds[1];
        for (int i = 2; i < bounds.length; i += 2) {
            if (bounds[i] < minX) {
                minX = bounds[i];
            } else if (maxX < bounds[i]) {
                maxX = bounds[i];
            }
            if (bounds[i + 1] < minY) {
                minY = bounds[i + 1];
                continue;
            }
            if (!(maxY < bounds[i + 1])) continue;
            maxY = bounds[i + 1];
        }
        this.rTopLefts[index] = new Point(minX < 0.0 ? (int)minX - 1 : (int)minX, minY < 0.0 ? (int)minY - 1 : (int)minY);
        this.rWidths[index] = (int)maxX - this.rTopLefts[index].x + 2;
        this.rHeights[index] = (int)maxY - this.rTopLefts[index].y + 2;
    }

    private boolean contain(int x, int y, int index) {
        return 0 <= x && x < this.nuclei[index].width && 0 <= y && y < this.nuclei[index].height;
    }

    public final Point getCenter(int index) {
        return this.nuclei[index].getCenter();
    }

    public final double[] getResults(int index) {
        if (this.results == null) {
            this.calcResults();
        }
        return this.results[index];
    }

    private void calcResults() {
        this.results = new double[7][4];
        double[][] input = new double[this.nuclei.length][4];
        for (int i = 0; i < input.length; ++i) {
            input[i][0] = this.nuclei[i].size;
            input[i][1] = this.nuclei[i].getFormFactor();
            input[i][2] = this.distance[i];
            input[i][3] = this.nuclei[i].getCenterDifference();
        }
        this.stat = new Statistics(input);
        this.results[0] = this.stat.getMin();
        this.results[1] = this.stat.getMax();
        this.results[2] = this.stat.getMean();
        this.results[3] = this.stat.getSD();
        this.results[4] = this.stat.getEntropyBit();
        this.results[5] = this.stat.getEntropyDigit();
        this.results[6][0] = this.stat.getEntropyBit(0, this.nearestNeighbor);
        this.results[6][1] = this.stat.getEntropyBit(1, this.nearestNeighbor);
        this.results = MathMx.transpose(this.results);
    }

    public final int[] getHistogram(int index, int number) {
        int[][] histogram = this.stat.getHistogram(number);
        return histogram[index];
    }

    public final int getMeanClass(int index) {
        return this.stat.getMeanClass(index);
    }

    public final void setCenterDifference(int index, double x, double y) {
        this.nuclei[index].setCenterDifference(new Point2D.Double(x, y));
    }
}

