/*
 * Decompiled with CFR 0.152.
 */
package taktstock;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import sos.awt.ImageTransform;
import sos.io.SOSImageIO;
import taktstock.KeyFrame;
import taktstock.TaktstockFile;
import taktstock.TaktstockViewer;
import taktstock.animation.AnimationMaker;

public class Conductor {
    private TaktstockViewer viewer;
    private AnimationMaker animationMaker;
    private TaktstockFile currentTaktstockFile;
    private ImageTransform imageTransform;
    private AffineTransform samplingTransform = new AffineTransform();
    private AffineTransform invSamplingTransform = new AffineTransform();
    private Timer timerFine = new Timer();
    private TimerTask taskFine;
    private Rectangle fineBuffer;
    private Point offsetFineImage = new Point();
    private AffineTransform fineTransform = new AffineTransform();
    private TimerTask taskAnimation;
    private Timer timerAnimation = new Timer();
    private ArrayList<KeyFrame> keyFrameArray = new ArrayList();
    private volatile KeyFrame currentKeyFrame;
    private volatile boolean frameSuspended;
    private volatile long startTime;

    public Conductor() {
        this.viewer = new TaktstockViewer(this);
        this.viewer.setVisible(true);
        this.imageTransform = this.viewer.getImageTransform();
        this.animationMaker = new AnimationMaker(this, this.viewer);
        this.animationMaker.setSize(this.viewer.getWidth(), this.animationMaker.getHeight());
        this.animationMaker.setLocation(this.viewer.getX(), this.viewer.getHeight());
        this.createFineImageTask();
        this.timerFine = new Timer();
        this.timerFine.schedule(this.taskFine, 0L, 1000L);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new Conductor();
            }
        });
    }

    private void createFineImageTask() {
        this.taskFine = new TimerTask(){

            public void run() {
                if (Conductor.this.fineBuffer != null) {
                    Rectangle source = Conductor.this.fineBuffer;
                    BufferedImage fineImage = (BufferedImage)SOSImageIO.getPartialImage(Conductor.this.currentTaktstockFile.getFile(), source);
                    if (source.equals(Conductor.this.fineBuffer)) {
                        Conductor.this.viewer.drawFineImageToOffScreen(fineImage, source.width, source.height);
                        fineImage = null;
                    }
                    if (source.equals(Conductor.this.fineBuffer)) {
                        Conductor.this.fineBuffer = null;
                        Conductor.this.viewer.updateCanvas();
                    }
                }
            }
        };
    }

    public void setPlayList() {
        this.animationMaker.getPlayList(this.keyFrameArray);
        if (0 < this.keyFrameArray.size()) {
            this.currentKeyFrame = this.keyFrameArray.get(0);
            this.frameSuspended = this.currentKeyFrame.isPauseFrame();
            this.viewer.setCurrentComment(this.currentKeyFrame.getComment());
        }
    }

    public void playAnimation(int fps) {
        this.setPlayList();
        if (0 < this.keyFrameArray.size()) {
            this.viewer.setSpinnerEnabled(false);
            if (!this.currentTaktstockFile.equals(this.currentKeyFrame.getFile())) {
                this.currentTaktstockFile = this.currentKeyFrame.getTaktstockFile();
                this.loadThumbnail();
            }
            if (this.currentKeyFrame.isPauseFrame()) {
                double[] matrix = this.currentKeyFrame.transform(0L);
                this.setFrameMatrix(matrix);
                this.viewer.drawImage();
            }
            this.createAnimationTask();
            this.startTime = System.currentTimeMillis();
            this.timerAnimation.scheduleAtFixedRate(this.taskAnimation, 0L, (long)(100 / fps));
            this.viewer.setAnimationScreen();
        }
    }

    private void createAnimationTask() {
        this.taskAnimation = new TimerTask(){

            public void run() {
                if (!Conductor.this.frameSuspended) {
                    long elapsedTime = System.currentTimeMillis() - Conductor.this.startTime;
                    Conductor.this.processFrame(elapsedTime);
                    Conductor.this.viewer.drawThumbnail();
                }
            }
        };
    }

    public void processFrame(long elapsedTime) {
        if (elapsedTime < this.currentKeyFrame.getEndTime()) {
            double[] matrix = this.currentKeyFrame.transform(elapsedTime);
            this.setFrameMatrix(matrix);
        } else if (this.currentKeyFrame.equals(this.currentKeyFrame.getNextFrame())) {
            this.viewer.setSpinnerEnabled(true);
            this.taskAnimation.cancel();
            this.viewer.drawImage();
            this.viewer.setCurrentComment(null);
        } else {
            this.currentKeyFrame = this.currentKeyFrame.getNextFrame();
            if (this.currentKeyFrame.isShowComment()) {
                this.viewer.setCurrentComment(this.currentKeyFrame.getComment());
            } else {
                this.viewer.setCurrentComment(null);
            }
            if (this.currentKeyFrame.isPauseFrame()) {
                this.frameSuspended = true;
                this.viewer.drawImage();
            }
            if (!this.currentTaktstockFile.equals(this.currentKeyFrame.getTaktstockFile())) {
                this.startTime = System.currentTimeMillis();
                this.currentTaktstockFile = this.currentKeyFrame.getTaktstockFile();
                this.loadThumbnail();
            }
        }
    }

    public void resumeAnimation() {
        this.startTime = System.currentTimeMillis();
        if (!this.frameSuspended && this.currentKeyFrame != null) {
            this.startTime -= this.currentKeyFrame.getEndTime();
        }
        this.frameSuspended = false;
    }

    public void rewindAnimation() {
        this.frameSuspended = false;
        if (this.currentKeyFrame != null) {
            this.currentKeyFrame = this.currentKeyFrame.getPrevFrame();
            this.startTime = System.currentTimeMillis() - this.currentKeyFrame.getStartTime();
        }
    }

    public void saveFineImage(File exportFile) {
        Rectangle bounds = this.getFineBuffer();
        BufferedImage fineImage = (BufferedImage)SOSImageIO.getPartialImage(this.currentTaktstockFile.getFile(), bounds);
        Dimension destSize = this.imageTransform.getDestSize();
        this.fineTransform.setToScale(1.0 * (double)destSize.width / (double)bounds.width, 1.0 * (double)destSize.height / (double)bounds.height);
        BufferedImage saveImage = new BufferedImage(destSize.width, destSize.height, fineImage.getType());
        Graphics2D g2 = (Graphics2D)saveImage.getGraphics();
        g2.drawImage(fineImage, this.fineTransform, this.viewer);
        SOSImageIO.writeImage(exportFile, SOSImageIO.TYPE_JPEG, saveImage);
    }

    public void setFrameMatrix(double[] matrix) {
        AffineTransform currentAT = this.imageTransform.getAffineTransform();
        currentAT.setTransform(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]);
        currentAT.concatenate(this.invSamplingTransform);
        currentAT.preConcatenate(this.viewer.getScreenTransform());
        this.imageTransform.calcMagnification();
    }

    public void loadThumbnail() {
        if (this.currentTaktstockFile == null) {
            return;
        }
        this.imageTransform.setImage(null);
        File file = this.currentTaktstockFile.getFile();
        Dimension originalSize = SOSImageIO.getImageSize(file);
        Image img = null;
        int samplingRate = this.currentTaktstockFile.getSamplingRate();
        img = 1 < samplingRate ? SOSImageIO.getSubsampledImage(file, samplingRate, samplingRate) : SOSImageIO.readImage(file);
        this.imageTransform.setImage(img);
        double x = 1.0 * (double)img.getWidth(null) / (double)originalSize.width;
        double y = 1.0 * (double)img.getHeight(null) / (double)originalSize.height;
        this.samplingTransform.setToScale(x, y);
        try {
            this.invSamplingTransform = this.samplingTransform.createInverse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.viewer.showSize(originalSize.width, originalSize.height);
    }

    public void setFineBuffer() {
        this.fineBuffer = 1.0 < this.imageTransform.getMagnification() ? this.getFineBuffer() : null;
    }

    private Rectangle getFineBuffer() {
        return this.invSamplingTransform.createTransformedShape(this.imageTransform.getVisibleBounds()).getBounds();
    }

    public double[] getTransformMatrix() {
        AffineTransform transform = new AffineTransform(this.imageTransform.getAffineTransform());
        transform.concatenate(this.samplingTransform);
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        return matrix;
    }

    public void setCurrentTaktstockFile(TaktstockFile taktstockFile) {
        this.currentTaktstockFile = taktstockFile;
    }

    public void cancelAllTimerTask() {
        this.timerAnimation.cancel();
        this.timerFine.cancel();
        this.viewer.setCurrentComment(null);
    }

    public void showAnimationMaker() {
        this.animationMaker.setVisible(true);
    }

    public void saveCurrentImage() {
        if (this.currentTaktstockFile != null) {
            this.currentTaktstockFile.save();
        } else {
            System.out.println("Null file!");
        }
    }

    public void addAnimationFile(File file, int samplingRate) {
        this.animationMaker.addFile(file, samplingRate);
    }

    public void changeSamplingRate(int samplingRate) {
        if (this.currentTaktstockFile == null) {
            return;
        }
        this.currentTaktstockFile.setSamplingRate(samplingRate);
        AffineTransform transform = this.imageTransform.getAffineTransform();
        transform.concatenate(this.samplingTransform);
        this.loadThumbnail();
        transform.concatenate(this.invSamplingTransform);
        this.imageTransform.calcMagnification();
        this.viewer.drawImage();
    }

    public int calculateSamplingRate(File file, Dimension size) {
        Dimension imageSize = SOSImageIO.getImageSize(file);
        int widthRate = (int)Math.ceil(1.0 * (double)imageSize.width / (double)size.width);
        int heightRate = (int)Math.ceil(1.0 * (double)imageSize.height / (double)size.height);
        return Math.max(widthRate, heightRate);
    }
}

