/*
 * Decompiled with CFR 0.152.
 */
package taktstock.animation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import sos.gui.JProgressDialog;
import sos.io.SOSFileIO;
import taktstock.CommentInfo;
import taktstock.Conductor;
import taktstock.KeyFrame;
import taktstock.TaktstockFile;
import taktstock.TaktstockViewer;
import taktstock.animation.KeyFrameEditor;
import taktstock.animation.KeyFrameRenderer;
import taktstock.animation.PlayListEditor;
import taktstock.animation.PlayListRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationMaker
extends JFrame
implements TableModelListener {
    private static int COLUMN_SCHEDULE = 2;
    private static int COLUMN_PAUSE = 3;
    private static int COLUMN_DURATION = 4;
    private static final DecimalFormat decimal = new DecimalFormat("0000");
    private static PlayListEditor playListEditor;
    private Conductor conductor;
    private TaktstockViewer viewer;
    private int indexOldFile = -1;
    private DefaultListModel modelFileList;
    private DefaultTableModel modelPlayList;
    private SOSFileIO fileIO = new SOSFileIO();
    private JButton jButtonAddFrame;
    private JButton jButtonCancelExport;
    private JButton jButtonClearPlayList;
    private JButton jButtonExport;
    private JButton jButtonRemoveFrame;
    private JButton jButtonRemovePlayList;
    private JButton jButtonSelectExprotDir;
    private JButton jButtonToPlayList;
    private JComboBox jComboBox1;
    private JDialog jDialogExport;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jListAnimationFile;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuExport;
    private JMenu jMenuFile;
    private JMenuItem jMenuOpenPlayList;
    private JMenuItem jMenuSavePlayList;
    private JPanel jPanel1;
    private JPanel jPanelFrame;
    private JPanel jPanelFrameButton;
    private JPanel jPanelPlayList;
    private JPanel jPanelPlayListButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSpinner jSpinnerFrameRate;
    private JTable jTableKeyFrames;
    private JTable jTablePlayList;
    private JTextField jTextExportDir;
    private JTextField jTextExportFileName;

    public AnimationMaker(Conductor conduct, TaktstockViewer taktstockViewer) {
        this.conductor = conduct;
        this.viewer = taktstockViewer;
        this.initComponents();
        this.modelFileList = new DefaultListModel();
        this.jListAnimationFile.setModel(this.modelFileList);
        KeyFrameRenderer keyFrameRenderer = new KeyFrameRenderer();
        this.jTableKeyFrames.setDefaultRenderer(Object.class, keyFrameRenderer);
        KeyFrameEditor keyFrameEditor = new KeyFrameEditor(this.viewer);
        DefaultTableColumnModel columnModelFrame = (DefaultTableColumnModel)this.jTableKeyFrames.getColumnModel();
        columnModelFrame.getColumn(0).setPreferredWidth(10);
        columnModelFrame.getColumn(1).setCellEditor(keyFrameEditor);
        ListSelectionModel selectionModel = this.jTableKeyFrames.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int rowIndex = AnimationMaker.this.jTableKeyFrames.getSelectedRow();
                if (rowIndex == -1) {
                    return;
                }
                double[] matrix = (double[])AnimationMaker.this.jTableKeyFrames.getValueAt(rowIndex, 0);
                AnimationMaker.this.conductor.setFrameMatrix(matrix);
                AnimationMaker.this.viewer.setCurrentComment((CommentInfo)AnimationMaker.this.jTableKeyFrames.getValueAt(rowIndex, 1));
                AnimationMaker.this.viewer.drawImage();
            }
        });
        this.jTablePlayList.setDefaultRenderer(Object.class, new PlayListRenderer(this.jListAnimationFile));
        DefaultTableColumnModel columnModelPlayList = (DefaultTableColumnModel)this.jTablePlayList.getColumnModel();
        playListEditor = new PlayListEditor();
        columnModelPlayList.getColumn(3).setCellEditor(playListEditor);
        columnModelPlayList.getColumn(4).setCellEditor(playListEditor);
        this.modelPlayList = (DefaultTableModel)this.jTablePlayList.getModel();
        this.modelPlayList.addTableModelListener(this);
        SpinnerNumberModel fpsModel = new SpinnerNumberModel(15, 1, 60, 1);
        this.jSpinnerFrameRate.setModel(fpsModel);
        this.jDialogExport.pack();
    }

    public void getPlayList(ArrayList<KeyFrame> keyFrameArray) {
        int i;
        if (this.modelPlayList.getRowCount() == 0) {
            this.selectionsToPlayList();
        }
        if (this.modelPlayList.getRowCount() <= 1) {
            return;
        }
        playListEditor.stopCellEditing();
        keyFrameArray.clear();
        for (i = 0; i < this.modelPlayList.getRowCount(); ++i) {
            int indexFile = (Integer)this.modelPlayList.getValueAt(i, 0);
            TaktstockFile file = (TaktstockFile)this.modelFileList.getElementAt(indexFile);
            int indexFrame = (Integer)this.modelPlayList.getValueAt(i, 1);
            boolean pause = (Boolean)this.modelPlayList.getValueAt(i, 3);
            int time = (Integer)this.modelPlayList.getValueAt(i, 4);
            boolean showComment = (Boolean)this.modelPlayList.getValueAt(i, 5);
            KeyFrame keyFrame = new KeyFrame(file, indexFrame, pause, time, showComment);
            keyFrameArray.add(keyFrame);
        }
        for (i = 0; i < keyFrameArray.size() - 1; ++i) {
            keyFrameArray.get(i).setNextFrame(keyFrameArray.get(i + 1));
        }
    }

    private void selectionsToPlayList() {
        int[] selection = this.jTableKeyFrames.getSelectedRows();
        if (selection.length == 0) {
            int rowCount = this.jTableKeyFrames.getRowCount();
            if (rowCount == 0) {
                return;
            }
            this.jTableKeyFrames.setRowSelectionInterval(0, rowCount - 1);
            selection = this.jTableKeyFrames.getSelectedRows();
        }
        int indexFile = this.jListAnimationFile.getSelectedIndex();
        for (int i = 0; i < selection.length; ++i) {
            this.addPlayList(indexFile, selection[i]);
        }
        this.jTableKeyFrames.clearSelection();
    }

    public void addFile(File file, int samplingRate) {
        int index = -1;
        for (int i = 0; i < this.modelFileList.getSize(); ++i) {
            TaktstockFile taktstockFile = (TaktstockFile)this.modelFileList.getElementAt(i);
            if (!taktstockFile.getFile().equals(file)) continue;
            index = i;
            break;
        }
        if (-1 == index) {
            TaktstockFile taktstockFile = new TaktstockFile(file, samplingRate);
            this.modelFileList.addElement(taktstockFile);
            this.jListAnimationFile.setSelectedIndex(this.modelFileList.getSize() - 1);
        } else {
            this.jListAnimationFile.setSelectedIndex(index);
        }
    }

    private void addPlayList(int indexFile, int indexFrame) {
        if (indexFile == -1 || indexFrame == -1) {
            return;
        }
        int rowIndex = this.modelPlayList.getRowCount() - 1;
        long schedule = 0L;
        if (0 <= rowIndex) {
            long preDuration = ((Integer)this.modelPlayList.getValueAt(rowIndex, COLUMN_DURATION)).intValue();
            if (preDuration == 0L) {
                this.modelPlayList.setValueAt(3000, rowIndex, COLUMN_DURATION);
            }
            if (!((Boolean)this.modelPlayList.getValueAt(rowIndex, COLUMN_PAUSE)).booleanValue()) {
                schedule = this.sumTime(rowIndex);
            }
        }
        Object[] playListItem = new Object[]{indexFile, indexFrame, schedule, false, 0, true};
        this.modelPlayList.addRow(playListItem);
    }

    private void addPlayList(String[] str) {
        this.modelPlayList.setRowCount(0);
        Object[] playListItem = new Object[]{Integer.valueOf(str[0]), Integer.valueOf(str[1]), Long.valueOf(str[2]), Boolean.valueOf(str[3]), Integer.valueOf(str[4]), Boolean.valueOf(str[5])};
        this.modelPlayList.addRow(playListItem);
    }

    private long sumTime(int rowIndex) {
        long result = ((Integer)this.modelPlayList.getValueAt(rowIndex, COLUMN_DURATION)).intValue();
        return result += ((Long)this.modelPlayList.getValueAt(rowIndex, COLUMN_SCHEDULE)).longValue();
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (evt.getType() == 0) {
            int rowCount;
            int row = evt.getFirstRow();
            int column = evt.getColumn();
            if ((column == COLUMN_SCHEDULE || column == COLUMN_DURATION) && row < (rowCount = this.modelPlayList.getRowCount()) - 1) {
                long value = this.sumTime(row);
                this.modelPlayList.setValueAt(value, row + 1, COLUMN_SCHEDULE);
            }
        }
    }

    private void initComponents() {
        this.jDialogExport = new JDialog();
        this.jLabel1 = new JLabel();
        this.jTextExportDir = new JTextField();
        this.jButtonSelectExprotDir = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextExportFileName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jSpinnerFrameRate = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jButtonExport = new JButton();
        this.jButtonCancelExport = new JButton();
        this.jPanelFrame = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableKeyFrames = new JTable();
        this.jPanelFrameButton = new JPanel();
        this.jButtonAddFrame = new JButton();
        this.jButtonRemoveFrame = new JButton();
        this.jButtonToPlayList = new JButton();
        this.jListAnimationFile = new JList();
        this.jPanelPlayList = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTablePlayList = new JTable();
        this.jPanelPlayListButton = new JPanel();
        this.jButtonRemovePlayList = new JButton();
        this.jButtonClearPlayList = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuOpenPlayList = new JMenuItem();
        this.jMenuSavePlayList = new JMenuItem();
        this.jMenuExport = new JMenuItem();
        this.jDialogExport.getContentPane().setLayout(new GridBagLayout());
        this.jDialogExport.setTitle("Export");
        this.jLabel1.setText("Directory: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jDialogExport.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jTextExportDir.setPreferredSize(new Dimension(200, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        this.jDialogExport.getContentPane().add((Component)this.jTextExportDir, gridBagConstraints);
        this.jButtonSelectExprotDir.setText("Select");
        this.jButtonSelectExprotDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonSelectExprotDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.jDialogExport.getContentPane().add((Component)this.jButtonSelectExprotDir, gridBagConstraints);
        this.jLabel2.setText("FileName: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jDialogExport.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jTextExportFileName.setText("images");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jDialogExport.getContentPane().add((Component)this.jTextExportFileName, gridBagConstraints);
        this.jLabel3.setText("FrameRate: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jDialogExport.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jDialogExport.getContentPane().add((Component)this.jSpinnerFrameRate, gridBagConstraints);
        this.jLabel4.setText("FileType: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jDialogExport.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"jpeg", "bmp"}));
        this.jComboBox1.setPreferredSize(new Dimension(70, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jDialogExport.getContentPane().add((Component)this.jComboBox1, gridBagConstraints);
        this.jButtonExport.setText("Export");
        this.jButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonExport);
        this.jButtonCancelExport.setText("Cancel");
        this.jButtonCancelExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonCancelExportActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancelExport);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jDialogExport.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.setDefaultCloseOperation(3);
        this.setTitle("TAKTSTOCK ANIMATION");
        this.jPanelFrame.setLayout(new BorderLayout());
        this.jPanelFrame.setBackground(new Color(230, 230, 255));
        this.jPanelFrame.setBorder(new TitledBorder("Key Frames"));
        this.jScrollPane1.setPreferredSize(new Dimension(150, 200));
        this.jTableKeyFrames.setModel(new DefaultTableModel(new Object[0][], new String[]{"NO", "COMMENTS"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableKeyFrames.setAutoCreateColumnsFromModel(false);
        this.jScrollPane1.setViewportView(this.jTableKeyFrames);
        this.jPanelFrame.add((Component)this.jScrollPane1, "Center");
        this.jPanelFrameButton.setLayout(new GridBagLayout());
        this.jPanelFrameButton.setOpaque(false);
        this.jButtonAddFrame.setForeground(Color.gray);
        this.jButtonAddFrame.setText("ADD");
        this.jButtonAddFrame.setFocusPainted(false);
        this.jButtonAddFrame.setFocusable(false);
        this.jButtonAddFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonAddFrameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanelFrameButton.add((Component)this.jButtonAddFrame, gridBagConstraints);
        this.jButtonRemoveFrame.setForeground(Color.gray);
        this.jButtonRemoveFrame.setText("REMOVE");
        this.jButtonRemoveFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonRemoveFrameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanelFrameButton.add((Component)this.jButtonRemoveFrame, gridBagConstraints);
        this.jButtonToPlayList.setForeground(Color.gray);
        this.jButtonToPlayList.setText("To PlayList");
        this.jButtonToPlayList.setFocusPainted(false);
        this.jButtonToPlayList.setFocusable(false);
        this.jButtonToPlayList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonToPlayListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 5, 0);
        this.jPanelFrameButton.add((Component)this.jButtonToPlayList, gridBagConstraints);
        this.jPanelFrame.add((Component)this.jPanelFrameButton, "North");
        this.getContentPane().add((Component)this.jPanelFrame, "Center");
        this.jListAnimationFile.setBackground(new Color(230, 230, 255));
        this.jListAnimationFile.setBorder(new TitledBorder("File List"));
        this.jListAnimationFile.setSelectionMode(0);
        this.jListAnimationFile.setMinimumSize(new Dimension(50, 0));
        this.jListAnimationFile.setPreferredSize(new Dimension(100, 0));
        this.jListAnimationFile.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AnimationMaker.this.jListAnimationFileValueChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.jListAnimationFile, "West");
        this.jPanelPlayList.setLayout(new BorderLayout());
        this.jPanelPlayList.setBorder(new TitledBorder("Play List"));
        this.jScrollPane2.setPreferredSize(new Dimension(500, 200));
        this.jTablePlayList.setModel(new DefaultTableModel(new Object[0][], new String[]{"FILE", "FRAME", "SCHEDULE", "PAUSE", "DURATION", "COMMENT"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.jTablePlayList);
        this.jPanelPlayList.add((Component)this.jScrollPane2, "East");
        this.jButtonRemovePlayList.setText("REMOVE");
        this.jButtonRemovePlayList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonRemovePlayListActionPerformed(evt);
            }
        });
        this.jPanelPlayListButton.add(this.jButtonRemovePlayList);
        this.jButtonClearPlayList.setText("CLEAR");
        this.jButtonClearPlayList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jButtonClearPlayListActionPerformed(evt);
            }
        });
        this.jPanelPlayListButton.add(this.jButtonClearPlayList);
        this.jPanelPlayList.add((Component)this.jPanelPlayListButton, "North");
        this.getContentPane().add((Component)this.jPanelPlayList, "East");
        this.jMenuFile.setText("File");
        this.jMenuOpenPlayList.setText("Open PlayList");
        this.jMenuOpenPlayList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jMenuOpenPlayListActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuOpenPlayList);
        this.jMenuSavePlayList.setText("Save PlayList");
        this.jMenuSavePlayList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jMenuSavePlayListActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSavePlayList);
        this.jMenuExport.setText("Export");
        this.jMenuExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnimationMaker.this.jMenuExportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuExport);
        this.jMenuBar1.add(this.jMenuFile);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jButtonClearPlayListActionPerformed(ActionEvent evt) {
        this.modelPlayList.setRowCount(0);
    }

    private void jButtonRemovePlayListActionPerformed(ActionEvent evt) {
        int index = this.jTablePlayList.getSelectedRow();
        if (-1 < index) {
            this.modelPlayList.removeRow(index);
        }
    }

    private void jButtonSelectExprotDirActionPerformed(ActionEvent evt) {
        File export = this.fileIO.getSaveDirectory();
        this.jTextExportDir.setText(export.getPath());
    }

    private void jButtonCancelExportActionPerformed(ActionEvent evt) {
        this.jDialogExport.setVisible(false);
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        this.conductor.setPlayList();
        String parent = this.jTextExportDir.getText() + System.getProperty("file.separator") + this.jTextExportFileName.getText();
        int frameRate = (Integer)this.jSpinnerFrameRate.getValue();
        int deltaTime = 1000 / frameRate;
        long totalTime = (Long)this.modelPlayList.getValueAt(this.modelPlayList.getRowCount() - 1, 2);
        int cycle = (int)(totalTime / (long)deltaTime);
        long elapsedTime = 0L;
        JProgressDialog progress = new JProgressDialog(this);
        progress.start("Saving the result image...", false);
        for (int i = 0; i <= cycle; ++i) {
            File exportFile = new File(parent + decimal.format(i + 1) + ".jpg");
            this.conductor.processFrame(elapsedTime);
            this.conductor.saveFineImage(exportFile);
            elapsedTime += (long)deltaTime;
            progress.setValue(100 * i / cycle);
        }
        progress.stop();
        this.jDialogExport.setVisible(false);
    }

    private void jMenuExportActionPerformed(ActionEvent evt) {
        this.jDialogExport.setVisible(true);
    }

    private void jMenuSavePlayListActionPerformed(ActionEvent evt) {
        if (this.modelPlayList.getRowCount() == 0) {
            return;
        }
        File f = this.fileIO.getSaveFile();
        if (f == null) {
            return;
        }
        String[] data = new String[this.modelFileList.getSize() + this.modelPlayList.getRowCount() + 1];
        data[0] = Integer.toString(this.modelFileList.getSize());
        for (int i = 0; i < this.modelFileList.getSize(); ++i) {
            TaktstockFile taktstockFile = (TaktstockFile)this.modelFileList.get(i);
            data[i + 1] = taktstockFile.toString();
        }
        for (int y = 0; y < this.modelPlayList.getRowCount(); ++y) {
            StringBuffer str = new StringBuffer(this.modelPlayList.getValueAt(y, 0).toString());
            for (int x = 1; x < this.modelPlayList.getColumnCount(); ++x) {
                str.append(",");
                str.append(this.modelPlayList.getValueAt(y, x));
            }
            data[y + 1 + this.modelFileList.getSize()] = str.toString();
        }
        SOSFileIO.writeStrings(f, data);
    }

    private void jMenuOpenPlayListActionPerformed(ActionEvent evt) {
        int i;
        File f = this.fileIO.getOpenFile();
        if (f == null) {
            return;
        }
        ArrayList<String> arg = SOSFileIO.readStrings(f);
        int nFileList = Integer.parseInt(arg.get(0)) + 1;
        String parent = f.getParent() + System.getProperty("file.separator");
        for (i = 1; i < nFileList; ++i) {
            File file = new File(parent + arg.get(i));
            this.addFile(file, this.viewer.getSamplingRate());
        }
        this.jListAnimationFile.setSelectedIndex(0);
        this.modelPlayList.setRowCount(0);
        for (i = nFileList; i < arg.size(); ++i) {
            String[] items = arg.get(i).split(",");
            this.addPlayList(items);
        }
    }

    private void jButtonRemoveFrameActionPerformed(ActionEvent evt) {
        int index = this.jTableKeyFrames.getSelectedRow();
        if (-1 < index) {
            DefaultTableModel modelKeyFrame = (DefaultTableModel)this.jTableKeyFrames.getModel();
            modelKeyFrame.removeRow(index);
        }
    }

    private void jListAnimationFileValueChanged(ListSelectionEvent evt) {
        int indexSelected = this.jListAnimationFile.getSelectedIndex();
        if (this.indexOldFile != indexSelected && indexSelected != -1) {
            TaktstockFile selectedFile = (TaktstockFile)this.jListAnimationFile.getSelectedValue();
            selectedFile.copyTableModel(this.jTableKeyFrames);
            this.conductor.setCurrentTaktstockFile(selectedFile);
            this.conductor.loadThumbnail();
            this.viewer.fitImageToCanvas();
            this.indexOldFile = indexSelected;
        }
    }

    private void jButtonToPlayListActionPerformed(ActionEvent evt) {
        this.selectionsToPlayList();
    }

    private void jButtonAddFrameActionPerformed(ActionEvent evt) {
        if (this.jListAnimationFile.getSelectedIndex() == -1) {
            return;
        }
        Object[] rowData = new Object[]{this.conductor.getTransformMatrix(), new CommentInfo()};
        DefaultTableModel modelKeyFrame = (DefaultTableModel)this.jTableKeyFrames.getModel();
        modelKeyFrame.addRow(rowData);
    }
}

