/*
 * TaktStockFile.java
 *
 * Created on 2005/01/06, 15:54
 */

package taktstock;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Vector;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import sos.io.Extension;
import sos.io.SOSImageIO;


/**
 *
 * @author pathologist
 */
public class TaktstockFile {
	static private final String path = "UnknownChunks/UnknownChunk";
	static private final String[] attr = new String[]{"type/tkFl"};
	static private Vector<String> columnNames = new Vector<String>();
	
	private File file;
	private int samplingRate;
	private Vector<Vector<Object>> tableModelData = new Vector<Vector<Object>>();
	
	static{
		columnNames.add("NO");
		columnNames.add("COMMENTS");
	}
	
	/** Creates a new instance of TaktStockFile */
	public TaktstockFile(File file, int rate) {
		this.file = file;
		samplingRate = rate;
		
		loadKeyFrame();
	}
	
	private void loadKeyFrame(){
		IIOMetadata metadata = SOSImageIO.getMetadata(file);
		byte[] data = null;
		if (metadata!=null){
			try {
				IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
				IIOMetadataNode node = SOSImageIO.getNode(root, path, attr);
				if (node!=null){
					data = (byte[])node.getUserObject();
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
		if (data!=null){
			try{
				ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
				ObjectInputStream objectIn = new ObjectInputStream(byteIn);
				tableModelData = (Vector)objectIn.readObject();
				objectIn.close();
				byteIn.close();
			}catch(StreamCorruptedException e){
				// invalid data in the COMMENT_SEGMENT of the jpeg file
				System.out.println("Error but OK");
			}catch(ClassCastException e){
				// invalid data in the COMMENT_SEGMENT of the jpeg file
				System.out.println("Error but OK");
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		
	}
	
	public void save(){
		
		if (0<tableModelData.size()){
			byte[][] data = new byte[1][];
			try{
				ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
				ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
				objectOut.writeObject(tableModelData);
				objectOut.flush();
				data[0] = byteOut.toByteArray();
				
				objectOut.close();
				byteOut.close();
			}catch(NotSerializableException e){
				System.out.println("Serializable error");
				e.printStackTrace();
			}catch(Exception e){
				System.out.println("Other error");
			}
			
			// save data (byte[]) to the png file
			BufferedImage img = SOSImageIO.readImage(file);
			IIOMetadata metadata = SOSImageIO.getDefaultMetadata("png",img);
			
			IIOMetadataNode node = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
			IIOMetadataNode privateChunk = SOSImageIO.getNode(node, path, attr);
			if (privateChunk==null){
				privateChunk = SOSImageIO.addNode(node, path, attr);
			}
			privateChunk.setUserObject(data[0]);
			
			try{
				metadata.setFromTree(metadata.getNativeMetadataFormatName(), node);
			}catch(Exception e){
				e.printStackTrace();
			}
			File newFile = new File(Extension.replace(file.getPath(),"png"));
			SOSImageIO.writeImage(newFile, img, metadata);
		}
	}
	
	public File getFile(){
		return file;
	}
	
	public int getSamplingRate(){
		return samplingRate;
	}
	
	public void setSamplingRate(int rate){
		samplingRate = rate;
	}
	
	public void copyTableModel(JTable distTable){
		DefaultTableModel model = (DefaultTableModel)distTable.getModel();
		model.setDataVector(tableModelData,columnNames);
	}
	
	/*
	public void setTableModel(ArrayList<KeyFrame> keyFrameArray){
		tableModel.setRowCount(0);
	 
		for (int i=0; i<keyFrameArray.size(); i++){
			KeyFrame keyFrame = keyFrameArray.get(i);
			Object[] data = keyFrame.toObjectArray();
			tableModel.addRow(data);
		}
	}*/
	
	public Vector getData(int index){
		Vector data = tableModelData.get(index);
		return data;
	}
	
	public CommentInfo getCommentInfo(int index){
		Vector vec = getData(index);
		return (CommentInfo)vec.get(3);
	}
	
	public String toString(){
		return file.getName();
	}
	
}
