/*
 * ImageViewer.java
 *
 * Created on 2004/12/24, 10:16
 */

package taktstock;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.Timer;
import javax.swing.SpinnerNumberModel;
import sos.awt.ImageTransform;
import sos.io.SOSFileIO;

/**
 *
 * @author  Gaku Tanaka
 */
public class TaktstockViewer extends javax.swing.JFrame{
	private GraphicsDevice device;
	private ArrayList<Integer> displayModeIndex = new ArrayList<Integer>();
	
	private Conductor conductor;
	
	private AffineTransform screenTransform = new AffineTransform();
	private AffineTransform fineTransform = new AffineTransform();
	private CommentInfo currentComment = null;
	
	private TimerTask taskFps;
	private Timer timerFps = null;
	private int fps = 15;
	private int frameCount;
	
	private int oldX,oldY;
	
	private SOSFileIO fileIO = new SOSFileIO();
	private boolean editingComment = false;
	
	/** Creates new form TaktStockViewer */
	public TaktstockViewer(Conductor conductor) {
		
		initComponents();
		
		//jTextComments.setVisible(false);
		
		setupGraphics();
		setupKeyInput();
		
		// setup for this
		SpinnerNumberModel subsampleModel = new SpinnerNumberModel(4,1,100,1);
		jSpinnerThumbnail.setModel(subsampleModel);
		pack();
		
		// setup for other JFrames
		jFrameFullScreen.setTitle(getTitle());
		
		this.conductor = conductor;
	}
	
	private void setupGraphics(){
		// setup for graphics
		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		device = ge.getDefaultScreenDevice();
		DisplayMode[] modes = device.getDisplayModes();
		DisplayMode mode = device.getDisplayMode();
		for (int i=0; i<modes.length; i++){
			if (modes[i].getBitDepth()==mode.getBitDepth()){
				jComboMode.addItem(modes[i].getWidth()+" x "+modes[i].getHeight());
				displayModeIndex.add(i);
				if (modes[i].equals(mode)){
					break;
				}
			}
		}
		jComboMode.setSelectedIndex(displayModeIndex.size()-1);
	}
	
	private void setupKeyInput(){
		// setup for key inputs
		KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
		keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){
			public boolean postProcessKeyEvent(KeyEvent evt){
				switch(evt.getID()){
					case KeyEvent.KEY_PRESSED:
						int keyCode = evt.getKeyCode();
						if (keyCode==KeyEvent.VK_PAGE_DOWN || keyCode==KeyEvent.VK_DOWN){
							conductor.resumeAnimation();
						}else if (keyCode==KeyEvent.VK_PAGE_UP || keyCode==KeyEvent.VK_UP){
							conductor.rewindAnimation();
						}
						break;
					case KeyEvent.KEY_RELEASED:
						break;
					case KeyEvent.KEY_TYPED:
						break;
				}
				return false;
			}
		});
	}
	
	private void createFpsTask(){
		taskFps = new TimerTask(){
			public void run(){
				jLabelFps.setText(frameCount+" FPS");
				frameCount = 0;
			}
		};
	}
	
	public void updateCanvas(){
		jCanvasMain.paintImmediately(0,0,jCanvasMain.getWidth(),jCanvasMain.getHeight());
		if (currentComment!=null){
			Graphics2D g = (Graphics2D)jCanvasMain.getGraphics();
			currentComment.draw(g);
		}
	}
	
	public void drawThumbnail(){
		jCanvasMain.clearCanvas();
		jCanvasMain.drawImage();
		updateCanvas();
		
		if (jCheckShowFps.isSelected()){
			frameCount++;
		}
	}
	
	public void drawImage(){
		drawThumbnail();
		conductor.setFineBuffer();
	}
	
	private void setFullScreen(){
		DisplayMode[] modes = device.getDisplayModes();
		int index = displayModeIndex.get(jComboMode.getSelectedIndex());
		double rateX = 1.0*modes[index].getWidth()/jCanvasMain.getWidth();
		double rateY = 1.0*modes[index].getHeight()/jCanvasMain.getHeight();
		double rate = Math.max(rateX,rateY);
		screenTransform.setToScale(rate,rate);
		
		jFrameFullScreen.getContentPane().add(jCanvasMain);
		setVisible(false);
		
		try{
			device.setFullScreenWindow(jFrameFullScreen);
			device.setDisplayMode(modes[index]);
		}catch(Exception e){
			device.setFullScreenWindow(null);
			e.printStackTrace();
			System.exit(0);
		}
	}
	
	public void fitImageToCanvas(){
		jCanvasMain.setFullSrc();
		drawImage();
	}
	
	public ImageTransform getImageTransform(){
		return jCanvasMain.getImageTransform();
	}
	
	public void drawFineImageToOffScreen(BufferedImage fineImage, int sourceWidth, int sourceHeight){
		fineTransform.setToScale(1.0*jCanvasMain.getWidth()/sourceWidth,1.0*jCanvasMain.getHeight()/sourceHeight);
		Graphics2D g2 = (Graphics2D)jCanvasMain.getOffGraphics();
		g2.drawImage(fineImage,fineTransform,jCanvasMain);
	}
	
	public void setSpinnerEnabled(boolean value){
		jSpinnerThumbnail.setEnabled(true);
	}
	
	public void showSize(int originalWidth, int originalHeight){
		jLabelThumbnailWidth.setText(Integer.toString(jCanvasMain.getImageWidth()));
		jLabelThumbnailHeight.setText(Integer.toString(jCanvasMain.getImageHeight()));
		jLabelImageWidth.setText(Integer.toString(originalWidth));
		jLabelImageHeight.setText(Integer.toString(originalHeight));
	}
	
	public void setAnimationScreen(){
		if (jCheckFullScreen.isSelected()){
			setFullScreen();
		}
	}
	
	public AffineTransform getScreenTransform(){
		return screenTransform;
	}
	
	public void setCurrentComment(CommentInfo comment){
		currentComment = comment;
	}
	
	public int getSamplingRate(){
		return (Integer)jSpinnerThumbnail.getValue();
	}

	public void setEditingComment(boolean editingComment) {
		this.editingComment = editingComment;
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jFrameFullScreen = new javax.swing.JFrame();
        buttonGroupPlayMode = new javax.swing.ButtonGroup();
        jCanvasMain = new sos.awt.JImageCanvas();
        jPanelSub = new javax.swing.JPanel();
        jPanelStatus = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jLabelThumbnailWidth = new javax.swing.JLabel();
        jLabelThumbnailHeight = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabelImageWidth = new javax.swing.JLabel();
        jLabelImageHeight = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jLabelFps = new javax.swing.JLabel();
        jCheckShowFps = new javax.swing.JCheckBox();
        jLabel13 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        jPanelSettings = new javax.swing.JPanel();
        jCheckAdaptCanvasSize = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jComboMode = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jSpinnerThumbnail = new javax.swing.JSpinner();
        jLabel7 = new javax.swing.JLabel();
        jCheckFullScreen = new javax.swing.JCheckBox();
        jButtonFullScreen = new javax.swing.JButton();
        jButtonPlayAnimation = new javax.swing.JButton();
        jButtonFitImage = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jSpinnerCanvasWidth = new javax.swing.JSpinner();
        jSpinnerCanvasHeight = new javax.swing.JSpinner();
        jButtonSetCanvasSize = new javax.swing.JButton();
        jMenuBarFile = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuItemOpen = new javax.swing.JMenuItem();
        jMenuItemSave = new javax.swing.JMenuItem();
        jMenuWindow = new javax.swing.JMenu();
        jMenuItemMakeAnimation = new javax.swing.JMenuItem();

        jFrameFullScreen.setUndecorated(true);
        jFrameFullScreen.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jFrameFullScreenKeyPressed(evt);
            }
        });

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("TAKTSTOCK 1.0RC");
        setFocusCycleRoot(false);
        setFocusable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jCanvasMain.setBackground(new java.awt.Color(0, 0, 0));
        jCanvasMain.setFocusCycleRoot(true);
        jCanvasMain.setOpaque(true);
        jCanvasMain.setPreferredSize(new java.awt.Dimension(640, 480));
        jCanvasMain.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                jCanvasMainComponentResized(evt);
            }
        });
        jCanvasMain.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jCanvasMainMouseDragged(evt);
            }
        });
        jCanvasMain.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jCanvasMainMouseClicked(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jCanvasMainMousePressed(evt);
            }
        });
        jCanvasMain.addMouseWheelListener(new java.awt.event.MouseWheelListener() {
            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                jCanvasMainMouseWheelMoved(evt);
            }
        });

        getContentPane().add(jCanvasMain, java.awt.BorderLayout.CENTER);

        jPanelSub.setLayout(new java.awt.BorderLayout());

        jPanelStatus.setLayout(new java.awt.GridBagLayout());

        jPanelStatus.setBackground(new java.awt.Color(230, 230, 255));
        jPanelStatus.setBorder(new javax.swing.border.TitledBorder("STATUS"));
        jPanelStatus.setFocusable(false);
        jPanelStatus.setMinimumSize(new java.awt.Dimension(130, 98));
        jPanelStatus.setPreferredSize(new java.awt.Dimension(150, 130));
        jLabel9.setForeground(new java.awt.Color(128, 126, 126));
        jLabel9.setText("Thumbnail: ");
        jLabel9.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelStatus.add(jLabel9, gridBagConstraints);

        jLabelThumbnailWidth.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelThumbnailWidth.setFocusable(false);
        jLabelThumbnailWidth.setPreferredSize(new java.awt.Dimension(60, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelStatus.add(jLabelThumbnailWidth, gridBagConstraints);

        jLabelThumbnailHeight.setPreferredSize(new java.awt.Dimension(60, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanelStatus.add(jLabelThumbnailHeight, gridBagConstraints);

        jLabel10.setForeground(new java.awt.Color(128, 126, 126));
        jLabel10.setText("Image:");
        jLabel10.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelStatus.add(jLabel10, gridBagConstraints);

        jLabelImageWidth.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelImageWidth.setFocusable(false);
        jLabelImageWidth.setPreferredSize(new java.awt.Dimension(60, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelStatus.add(jLabelImageWidth, gridBagConstraints);

        jLabelImageHeight.setPreferredSize(new java.awt.Dimension(60, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanelStatus.add(jLabelImageHeight, gridBagConstraints);

        jLabel14.setForeground(new java.awt.Color(128, 126, 126));
        jLabel14.setText("FPS: ");
        jLabel14.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelStatus.add(jLabel14, gridBagConstraints);

        jLabelFps.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelFps.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelStatus.add(jLabelFps, gridBagConstraints);

        jCheckShowFps.setForeground(new java.awt.Color(128, 126, 126));
        jCheckShowFps.setText("measure");
        jCheckShowFps.setFocusable(false);
        jCheckShowFps.setOpaque(false);
        jCheckShowFps.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckShowFpsItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelStatus.add(jCheckShowFps, gridBagConstraints);

        jLabel13.setText("x");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        jPanelStatus.add(jLabel13, gridBagConstraints);

        jLabel16.setText("x");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        jPanelStatus.add(jLabel16, gridBagConstraints);

        jPanelSub.add(jPanelStatus, java.awt.BorderLayout.NORTH);

        jPanelSettings.setLayout(new java.awt.GridBagLayout());

        jPanelSettings.setBackground(new java.awt.Color(230, 230, 255));
        jPanelSettings.setBorder(new javax.swing.border.TitledBorder("SETTINGS"));
        jPanelSettings.setFocusable(false);
        jCheckAdaptCanvasSize.setForeground(new java.awt.Color(128, 126, 126));
        jCheckAdaptCanvasSize.setSelected(true);
        jCheckAdaptCanvasSize.setText("adapt canvas size");
        jCheckAdaptCanvasSize.setOpaque(false);
        jCheckAdaptCanvasSize.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckAdaptCanvasSizeItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelSettings.add(jCheckAdaptCanvasSize, gridBagConstraints);

        jLabel1.setForeground(new java.awt.Color(102, 102, 255));
        jLabel1.setText("CANVAS");
        jLabel1.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 2, 0);
        jPanelSettings.add(jLabel1, gridBagConstraints);

        jLabel3.setForeground(new java.awt.Color(102, 102, 255));
        jLabel3.setText("ANIMATION");
        jLabel3.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 2, 0);
        jPanelSettings.add(jLabel3, gridBagConstraints);

        jComboMode.setForeground(new java.awt.Color(152, 152, 255));
        jComboMode.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanelSettings.add(jComboMode, gridBagConstraints);

        jLabel4.setForeground(new java.awt.Color(128, 126, 126));
        jLabel4.setText("rate: ");
        jLabel4.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelSettings.add(jLabel4, gridBagConstraints);

        jLabel5.setForeground(new java.awt.Color(128, 126, 126));
        jLabel5.setText("full: ");
        jLabel5.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelSettings.add(jLabel5, gridBagConstraints);

        jSpinnerThumbnail.setEnabled(false);
        jSpinnerThumbnail.setFocusable(false);
        jSpinnerThumbnail.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerThumbnailStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanelSettings.add(jSpinnerThumbnail, gridBagConstraints);

        jLabel7.setForeground(new java.awt.Color(102, 102, 255));
        jLabel7.setText("THUMBNAIL");
        jLabel7.setFocusable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 0);
        jPanelSettings.add(jLabel7, gridBagConstraints);

        jCheckFullScreen.setForeground(new java.awt.Color(128, 126, 126));
        jCheckFullScreen.setText("full screen");
        jCheckFullScreen.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelSettings.add(jCheckFullScreen, gridBagConstraints);

        jButtonFullScreen.setForeground(java.awt.Color.gray);
        jButtonFullScreen.setText("FULL SCREEN");
        jButtonFullScreen.setFocusPainted(false);
        jButtonFullScreen.setFocusable(false);
        jButtonFullScreen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFullScreenActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelSettings.add(jButtonFullScreen, gridBagConstraints);

        jButtonPlayAnimation.setForeground(java.awt.Color.gray);
        jButtonPlayAnimation.setText("PLAY");
        jButtonPlayAnimation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPlayAnimationActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelSettings.add(jButtonPlayAnimation, gridBagConstraints);

        jButtonFitImage.setForeground(java.awt.Color.gray);
        jButtonFitImage.setText("FIT TO CANVAS");
        jButtonFitImage.setFocusPainted(false);
        jButtonFitImage.setFocusable(false);
        jButtonFitImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFitImageActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelSettings.add(jButtonFitImage, gridBagConstraints);

        jLabel2.setForeground(new java.awt.Color(128, 126, 126));
        jLabel2.setText("width:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelSettings.add(jLabel2, gridBagConstraints);

        jLabel8.setForeground(new java.awt.Color(128, 126, 126));
        jLabel8.setText("height: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanelSettings.add(jLabel8, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanelSettings.add(jSpinnerCanvasWidth, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanelSettings.add(jSpinnerCanvasHeight, gridBagConstraints);

        jButtonSetCanvasSize.setForeground(java.awt.Color.gray);
        jButtonSetCanvasSize.setText("SET SIZE");
        jButtonSetCanvasSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetCanvasSizeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        jPanelSettings.add(jButtonSetCanvasSize, gridBagConstraints);

        jPanelSub.add(jPanelSettings, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanelSub, java.awt.BorderLayout.WEST);

        jMenuFile.setText("File");
        jMenuFile.setPreferredSize(new java.awt.Dimension(80, 17));
        jMenuItemOpen.setText("Open Image");
        jMenuItemOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemOpenActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemOpen);

        jMenuItemSave.setText("Save Image");
        jMenuItemSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveActionPerformed(evt);
            }
        });

        jMenuFile.add(jMenuItemSave);

        jMenuBarFile.add(jMenuFile);

        jMenuWindow.setText("Window");
        jMenuItemMakeAnimation.setText("Animation");
        jMenuItemMakeAnimation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemMakeAnimationActionPerformed(evt);
            }
        });

        jMenuWindow.add(jMenuItemMakeAnimation);

        jMenuBarFile.add(jMenuWindow);

        setJMenuBar(jMenuBarFile);

        pack();
    }//GEN-END:initComponents
	
	private void jCheckAdaptCanvasSizeItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckAdaptCanvasSizeItemStateChanged
		jSpinnerThumbnail.setEnabled(!jCheckAdaptCanvasSize.isSelected());
	}//GEN-LAST:event_jCheckAdaptCanvasSizeItemStateChanged
	
	private void jButtonSetCanvasSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSetCanvasSizeActionPerformed
		int width = (Integer)jSpinnerCanvasWidth.getValue();
		int height = (Integer)jSpinnerCanvasHeight.getValue();
		jCanvasMain.setSize(width,height);
		pack();
	}//GEN-LAST:event_jButtonSetCanvasSizeActionPerformed
	
	private void jButtonPlayAnimationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPlayAnimationActionPerformed
		conductor.playAnimation(fps);
	}//GEN-LAST:event_jButtonPlayAnimationActionPerformed
	
	private void jMenuItemMakeAnimationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemMakeAnimationActionPerformed
		conductor.showAnimationMaker();
	}//GEN-LAST:event_jMenuItemMakeAnimationActionPerformed
	
	private void jMenuItemSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveActionPerformed
		setCursor(new Cursor(Cursor.WAIT_CURSOR));
		conductor.saveCurrentImage();
		setCursor(Cursor.getDefaultCursor());
	}//GEN-LAST:event_jMenuItemSaveActionPerformed
	
	private void jMenuItemOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOpenActionPerformed
		File file = fileIO.getOpenFile();
		if (file!=null){
			setCursor(new Cursor(Cursor.WAIT_CURSOR));
			
			if (jCheckAdaptCanvasSize.isSelected()){
				int rate = conductor.calculateSamplingRate(file,jCanvasMain.getSize());
				jSpinnerThumbnail.setValue(rate);
			}
			
			int	samplingRate = (Integer)jSpinnerThumbnail.getValue();
			conductor.addAnimationFile(file,samplingRate);
			
			setCursor(Cursor.getDefaultCursor());
		}
	}//GEN-LAST:event_jMenuItemOpenActionPerformed
	
	private void jCanvasMainMouseWheelMoved(java.awt.event.MouseWheelEvent evt) {//GEN-FIRST:event_jCanvasMainMouseWheelMoved
		jCanvasMain.mouseWheelMoved(evt);
		drawImage();
	}//GEN-LAST:event_jCanvasMainMouseWheelMoved
	
	private void jCheckShowFpsItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckShowFpsItemStateChanged
		if (timerFps!=null){
			timerFps.cancel();
		}
		if (jCheckShowFps.isSelected()){
			timerFps = new Timer();
			createFpsTask();
			timerFps.scheduleAtFixedRate(taskFps,0, 1000);
		}else{
			jLabelFps.setText("");
		}
	}//GEN-LAST:event_jCheckShowFpsItemStateChanged
	
	private void jCanvasMainComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jCanvasMainComponentResized
		Dimension preSize = jCanvasMain.getPreSize();
		double rw = 1.0*jCanvasMain.getWidth()/preSize.width;
		double rh = 1.0*jCanvasMain.getHeight()/preSize.height;
		double ratio = 1.0;
		if (1.0<rw && 1.0<rh){
			ratio = Math.max(rw,rh);
		}else{
			ratio = Math.min(rw,rh);
		}
		jCanvasMain.scaleImage(ratio);
		drawImage();
		
		jSpinnerCanvasWidth.setValue(jCanvasMain.getWidth());
		jSpinnerCanvasHeight.setValue(jCanvasMain.getHeight());
	}//GEN-LAST:event_jCanvasMainComponentResized
	
	private void jSpinnerThumbnailStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerThumbnailStateChanged
		int samplingRate = (Integer)jSpinnerThumbnail.getValue();
		conductor.changeSamplingRate(samplingRate);
	}//GEN-LAST:event_jSpinnerThumbnailStateChanged
	
	private void jFrameFullScreenKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jFrameFullScreenKeyPressed
		if (evt.getKeyCode()==evt.VK_ESCAPE){
			getContentPane().add(jCanvasMain);
			Dimension preSize = jCanvasMain.getPreSize();
			setVisible(true);
			//jCanvasMain.setSize(preSize.width,preSize.height);
			
			device.setFullScreenWindow(null);
			jFrameFullScreen.setVisible(false);
		}
	}//GEN-LAST:event_jFrameFullScreenKeyPressed
	
	private void jButtonFullScreenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFullScreenActionPerformed
		setFullScreen();
	}//GEN-LAST:event_jButtonFullScreenActionPerformed
	
	private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
		conductor.cancelAllTimerTask();
	}//GEN-LAST:event_formWindowClosing
	
	private void jButtonFitImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFitImageActionPerformed
		jCanvasMain.setFullSrc();
		drawImage();
	}//GEN-LAST:event_jButtonFitImageActionPerformed
	
	private void jCanvasMainMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMousePressed
		if (editingComment){
			oldX = evt.getX();
			oldY = evt.getY();
		}else{
			jCanvasMain.mousePressed(evt);
		}
	}//GEN-LAST:event_jCanvasMainMousePressed
	
	private void jCanvasMainMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMouseDragged
		if (editingComment){
			int dx = evt.getX()-oldX;
			int dy = evt.getY()-oldY;
			currentComment.translate(dx,dy);
			oldX = evt.getX();
			oldY = evt.getY();
			updateCanvas();
		}else{
			jCanvasMain.mouseDragged(evt);
			drawImage();
		}
	}//GEN-LAST:event_jCanvasMainMouseDragged
	
	private void jCanvasMainMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasMainMouseClicked
		jCanvasMain.mouseClicked(evt);
		drawImage();
	}//GEN-LAST:event_jCanvasMainMouseClicked
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupPlayMode;
    private javax.swing.JButton jButtonFitImage;
    private javax.swing.JButton jButtonFullScreen;
    private javax.swing.JButton jButtonPlayAnimation;
    private javax.swing.JButton jButtonSetCanvasSize;
    private sos.awt.JImageCanvas jCanvasMain;
    private javax.swing.JCheckBox jCheckAdaptCanvasSize;
    private javax.swing.JCheckBox jCheckFullScreen;
    private javax.swing.JCheckBox jCheckShowFps;
    private javax.swing.JComboBox jComboMode;
    private javax.swing.JFrame jFrameFullScreen;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabelFps;
    private javax.swing.JLabel jLabelImageHeight;
    private javax.swing.JLabel jLabelImageWidth;
    private javax.swing.JLabel jLabelThumbnailHeight;
    private javax.swing.JLabel jLabelThumbnailWidth;
    private javax.swing.JMenuBar jMenuBarFile;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuItemMakeAnimation;
    private javax.swing.JMenuItem jMenuItemOpen;
    private javax.swing.JMenuItem jMenuItemSave;
    private javax.swing.JMenu jMenuWindow;
    private javax.swing.JPanel jPanelSettings;
    private javax.swing.JPanel jPanelStatus;
    private javax.swing.JPanel jPanelSub;
    private javax.swing.JSpinner jSpinnerCanvasHeight;
    private javax.swing.JSpinner jSpinnerCanvasWidth;
    private javax.swing.JSpinner jSpinnerThumbnail;
    // ϐ錾̏I//GEN-END:variables
	
}
