/*
 * Decompiled with CFR 0.152.
 */
package sos.process;

import java.util.Arrays;
import sos.math.MathVector;
import sos.process.NeighborFrame;
import sos.util.FirstInFirstOut;

public class Morphology {
    private static FirstInFirstOut fifo = null;
    private NeighborFrame neighborFrame = null;

    public Morphology(NeighborFrame neighborF) {
        this.neighborFrame = neighborF;
        fifo = new FirstInFirstOut(neighborF.size);
    }

    public Morphology(int width, int height) {
        this.neighborFrame = new NeighborFrame(width, height);
        fifo = new FirstInFirstOut(this.neighborFrame.size);
    }

    public final int getWidth() {
        return this.neighborFrame.width;
    }

    public final int getHeight() {
        return this.neighborFrame.height;
    }

    public final double[] calcSobel(int[][] color) {
        this.neighborFrame.set8();
        double[] gradient = new double[color.length];
        int[] n = new int[8];
        int[] vec = new int[3];
        boolean max = false;
        for (int pn = 0; pn < gradient.length; ++pn) {
            int v2;
            int v1;
            int d;
            n = this.neighborFrame.getDir(pn);
            for (d = 0; d < 3; ++d) {
                v1 = color[pn + n[0]][d] + 2 * color[pn + n[1]][d] + color[pn + n[2]][d];
                v2 = color[pn + n[4]][d] + 2 * color[pn + n[5]][d] + color[pn + n[6]][d];
                vec[d] = v1 - v2;
            }
            int value = MathVector.dot(vec, vec);
            for (d = 0; d < 3; ++d) {
                v1 = color[pn + n[2]][d] + 2 * color[pn + n[3]][d] + color[pn + n[4]][d];
                v2 = color[pn + n[6]][d] + 2 * color[pn + n[7]][d] + color[pn + n[0]][d];
                vec[d] = v1 - v2;
            }
            gradient[pn] = Math.sqrt(value += MathVector.dot(vec, vec));
        }
        return gradient;
    }

    public final double[] calcSobel(double[][] color) {
        this.neighborFrame.set8();
        double[] gradient = new double[color.length];
        int[] n = new int[8];
        double[] vec = new double[3];
        double max = 0.0;
        for (int pn = 0; pn < gradient.length; ++pn) {
            double v2;
            double v1;
            int d;
            n = this.neighborFrame.getDir(pn);
            for (d = 0; d < 3; ++d) {
                v1 = color[pn + n[0]][d] + 2.0 * color[pn + n[1]][d] + color[pn + n[2]][d];
                v2 = color[pn + n[4]][d] + 2.0 * color[pn + n[5]][d] + color[pn + n[6]][d];
                vec[d] = v1 - v2;
            }
            double value = MathVector.dot(vec, vec);
            for (d = 0; d < 3; ++d) {
                v1 = color[pn + n[2]][d] + 2.0 * color[pn + n[3]][d] + color[pn + n[4]][d];
                v2 = color[pn + n[6]][d] + 2.0 * color[pn + n[7]][d] + color[pn + n[0]][d];
                vec[d] = v1 - v2;
            }
            gradient[pn] = Math.sqrt(value += MathVector.dot(vec, vec));
        }
        return gradient;
    }

    public final double[] calcSobel(double[][] color, int[] table) {
        this.neighborFrame.set8();
        double[] gradient = new double[table.length];
        int[] n = new int[8];
        double[] vec = new double[3];
        for (int pn = 0; pn < gradient.length; ++pn) {
            double v2;
            double v1;
            int d;
            n = this.neighborFrame.getDir(pn);
            for (d = 0; d < 3; ++d) {
                v1 = color[table[pn + n[0]]][d] + 2.0 * color[table[pn + n[1]]][d] + color[table[pn + n[2]]][d];
                v2 = color[table[pn + n[4]]][d] + 2.0 * color[table[pn + n[5]]][d] + color[table[pn + n[6]]][d];
                vec[d] = v1 - v2;
            }
            double value = MathVector.dot(vec, vec);
            for (d = 0; d < 3; ++d) {
                v1 = color[table[pn + n[2]]][d] + 2.0 * color[table[pn + n[3]]][d] + color[table[pn + n[4]]][d];
                v2 = color[table[pn + n[6]]][d] + 2.0 * color[table[pn + n[7]]][d] + color[table[pn + n[0]]][d];
                vec[d] = v1 - v2;
            }
            gradient[pn] = Math.sqrt(value += MathVector.dot(vec, vec));
        }
        return gradient;
    }

    public final int[] mean4(int[] data) {
        this.neighborFrame.set4();
        return this.mean(data);
    }

    public final int[] mean8(int[] data) {
        this.neighborFrame.set8();
        return this.mean(data);
    }

    private final int[] mean(int[] data) {
        int[] result = new int[data.length];
        for (int pn = 0; pn < data.length; ++pn) {
            int value = data[pn];
            int[] se = this.neighborFrame.getExist(pn);
            for (int n = 0; n < se.length; ++n) {
                value += data[pn + se[n]];
            }
            result[pn] = (int)Math.round(1.0 * (double)value / (double)(1 + se.length));
        }
        return result;
    }

    public final int[] erode4(int[] data) {
        this.neighborFrame.set4();
        return this.erode(data);
    }

    public final int[] erode8(int[] data) {
        this.neighborFrame.set8();
        return this.erode(data);
    }

    private final int[] erode(int[] data) {
        int[] result = new int[data.length];
        for (int pn = 0; pn < data.length; ++pn) {
            int sentinel = data[pn];
            int[] se = this.neighborFrame.getExist(pn);
            for (int n = 0; n < se.length; ++n) {
                if (sentinel >= data[pn + se[n]]) continue;
                sentinel = data[pn + se[n]];
            }
            result[pn] = sentinel;
        }
        return result;
    }

    public final int[] dilate4(int[] data) {
        this.neighborFrame.set4();
        return this.dilate(data);
    }

    public final int[] dilate8(int[] data) {
        this.neighborFrame.set8();
        return this.dilate(data);
    }

    private final int[] dilate(int[] data) {
        int[] result = new int[data.length];
        for (int pn = 0; pn < data.length; ++pn) {
            int sentinel = data[pn];
            int[] se = this.neighborFrame.getExist(pn);
            for (int n = 0; n < se.length; ++n) {
                if (sentinel <= data[pn + se[n]]) continue;
                sentinel = data[pn + se[n]];
            }
            result[pn] = sentinel;
        }
        return result;
    }

    public final int[] open4(int[] data, int t) {
        this.neighborFrame.set4();
        return this.open(data, t);
    }

    public final int[] open8(int[] data, int t) {
        this.neighborFrame.set8();
        return this.open(data, t);
    }

    private final int[] open(int[] data, int t) {
        int i;
        int[] result = new int[data.length];
        for (i = 0; i < t; ++i) {
            result = this.erode(data);
        }
        for (i = 0; i < t; ++i) {
            result = this.dilate(result);
        }
        return result;
    }

    public final int[] close4(int[] data, int t) {
        this.neighborFrame.set4();
        return this.close(data, t);
    }

    public final int[] close8(int[] data, int t) {
        this.neighborFrame.set8();
        return this.close(data, t);
    }

    private final int[] close(int[] data, int t) {
        int i;
        int[] result = new int[data.length];
        for (i = 0; i < t; ++i) {
            result = this.dilate(data);
        }
        for (i = 0; i < t; ++i) {
            result = this.erode(result);
        }
        return result;
    }

    public final void reconstruct4(int[] iMask, int[] iMarker) {
        this.neighborFrame.set4();
        this.reconstruct(iMask, iMarker);
    }

    public final void reconstruct8(int[] iMask, int[] iMarker) {
        this.neighborFrame.set8();
        this.reconstruct(iMask, iMarker);
    }

    private final void reconstruct(int[] iMask, int[] iMarker) {
        int cn;
        int n;
        int[] neighbor;
        int max;
        int nHalf = this.neighborFrame.getNumber() / 2;
        for (int pn = 0; pn < iMask.length; ++pn) {
            max = iMarker[pn];
            neighbor = this.neighborFrame.getDir(pn);
            for (n = nHalf; n < neighbor.length; ++n) {
                cn = pn + neighbor[n];
                if (max >= iMarker[cn]) continue;
                max = iMarker[cn];
            }
            iMarker[pn] = Math.min(iMask[pn], max);
        }
        block2: for (int rpn = iMask.length - 1; rpn >= 0; --rpn) {
            max = iMarker[rpn];
            neighbor = this.neighborFrame.getDir(rpn);
            for (n = 0; n < nHalf; ++n) {
                cn = rpn + neighbor[n];
                if (max >= iMarker[cn]) continue;
                max = iMarker[cn];
            }
            iMarker[rpn] = Math.min(iMask[rpn], max);
            for (n = 0; n < nHalf; ++n) {
                cn = rpn + neighbor[n];
                if (iMarker[cn] >= iMarker[rpn] || iMarker[cn] >= iMask[cn]) continue;
                fifo.add(rpn);
                continue block2;
            }
        }
        while (!fifo.isEmpty()) {
            int cp = fifo.get();
            neighbor = this.neighborFrame.getDir(cp);
            for (n = 0; n < neighbor.length; ++n) {
                cn = cp + neighbor[n];
                if (iMarker[cn] >= iMarker[cp] || iMarker[cn] == iMask[cn]) continue;
                iMarker[cn] = Math.min(iMarker[cp], iMask[cn]);
                fifo.add(cn);
            }
        }
    }

    public final int[] geodesicDistance4(boolean[] binaryMap) {
        this.neighborFrame.set4();
        return this.geodesicDistance(binaryMap);
    }

    public final int[] geodesicDistance8(boolean[] binaryMap) {
        this.neighborFrame.set8();
        return this.geodesicDistance(binaryMap);
    }

    private final int[] geodesicDistance(boolean[] binaryMap) {
        int[] neighbor;
        int[] distanceMap = new int[binaryMap.length];
        block0: for (int pn = 0; pn < binaryMap.length; ++pn) {
            if (!binaryMap[pn]) continue;
            neighbor = this.neighborFrame.getExist(pn);
            for (int n = 0; n < neighbor.length; ++n) {
                if (binaryMap[pn + neighbor[n]]) continue;
                distanceMap[pn] = 1;
                fifo.add(pn);
                continue block0;
            }
        }
        while (!fifo.isEmpty()) {
            int cp = fifo.get();
            neighbor = this.neighborFrame.getExist(cp);
            for (int n = 0; n < neighbor.length; ++n) {
                int cn = cp + neighbor[n];
                if (distanceMap[cn] != 0 || !binaryMap[cn]) continue;
                distanceMap[cn] = distanceMap[cp] + 1;
                fifo.add(cn);
            }
        }
        return distanceMap;
    }

    public final int[][] erodeVector4(int[][] data, int[] order) {
        this.neighborFrame.set4();
        return this.erodeVector(data, order);
    }

    public final int[][] erodeVector8(int[][] data, int[] order) {
        this.neighborFrame.set8();
        return this.erodeVector(data, order);
    }

    private final int[][] erodeVector(int[][] data, int[] order) {
        int[][] result = new int[data.length][data[0].length];
        for (int pn = 0; pn < data.length; ++pn) {
            int sentinel = order[pn];
            int winner = pn;
            int[] se = this.neighborFrame.getExist(pn);
            for (int n = 0; n < se.length; ++n) {
                int cse = pn + se[n];
                if (sentinel >= order[cse]) continue;
                sentinel = order[cse];
                winner = cse;
            }
            System.arraycopy(data[winner], 0, result[pn], 0, data[0].length);
        }
        return result;
    }

    public final int[][] dilateVector4(int[][] data, int[] order) {
        this.neighborFrame.set4();
        return this.dilateVector(data, order);
    }

    public final int[][] dilateVector8(int[][] data, int[] order) {
        this.neighborFrame.set8();
        return this.dilateVector(data, order);
    }

    private final int[][] dilateVector(int[][] data, int[] order) {
        int[][] result = new int[data.length][data[0].length];
        for (int pn = 0; pn < data.length; ++pn) {
            int sentinel = order[pn];
            int winner = pn;
            int[] se = this.neighborFrame.getExist(pn);
            for (int n = 0; n < se.length; ++n) {
                int cse = pn + se[n];
                if (sentinel <= order[cse]) continue;
                sentinel = order[cse];
                winner = cse;
            }
            System.arraycopy(data[winner], 0, result[pn], 0, data[0].length);
        }
        return result;
    }

    public final int[][] openVector(int[][] data, int[] order) {
        int[][] result = this.erodeVector(data, order);
        result = this.dilateVector(result, order);
        return result;
    }

    public final int[][] closeVector(int[][] data, int[] order) {
        int[][] result = this.dilateVector(data, order);
        result = this.erodeVector(result, order);
        return result;
    }

    public final double texturalFeature(double[][] mx, int index) {
        int ng = mx.length;
        double mu = 0.0;
        for (int i = 0; i < ng; ++i) {
            for (int j = 0; j < ng; ++j) {
                mu += (double)i * mx[i][j];
            }
        }
        double[] pxpy = new double[ng * 2 - 1];
        for (int i = 0; i < ng; ++i) {
            for (int j = 0; j < ng; ++j) {
                int n = i + j;
                pxpy[n] = pxpy[n] + mx[i][j];
            }
        }
        double[] pxmy = new double[ng];
        for (int i = 0; i < ng; ++i) {
            for (int j = 0; j < ng; ++j) {
                int n = Math.abs(i - j);
                pxmy[n] = pxmy[n] + mx[i][j];
            }
        }
        double result = 0.0;
        switch (index) {
            case 0: {
                for (int i = 0; i < ng; ++i) {
                    for (int j = 0; j < ng; ++j) {
                        result += mx[i][j] * mx[i][j];
                    }
                }
                break;
            }
            case 1: {
                for (int n = 1; n < ng; ++n) {
                    int v = n * n;
                    for (int i = 0; i < ng; ++i) {
                        if (0 <= i - n) {
                            result += (double)v * mx[i][i - n];
                        }
                        if (i + n >= ng) continue;
                        result += (double)v * mx[i][i + n];
                    }
                }
                break;
            }
            case 2: {
                int j;
                int i;
                double sd = 0.0;
                for (i = 0; i < ng; ++i) {
                    double value = ((double)i - mu) * ((double)i - mu);
                    for (j = 0; j < ng; ++j) {
                        sd += value * mx[i][j];
                    }
                }
                for (i = 0; i < ng; ++i) {
                    for (j = 0; j < ng; ++j) {
                        result += (double)(i * j) * mx[i][j];
                    }
                }
                result = (result - mu * mu) / (sd * sd);
                break;
            }
            case 3: {
                for (int i = 0; i < ng; ++i) {
                    double value = ((double)i - mu) * ((double)i - mu);
                    for (int j = 0; j < ng; ++j) {
                        result += value * mx[i][j];
                    }
                }
                break;
            }
            case 4: {
                for (int i = 0; i < ng; ++i) {
                    for (int j = 0; j < ng; ++j) {
                        result += mx[i][j] / (double)(1 + (i - j) * (i - j));
                    }
                }
                break;
            }
            case 5: {
                for (int i = 0; i < pxpy.length; ++i) {
                    result += (double)(i + 2) * pxpy[i];
                }
                break;
            }
            case 6: {
                int i;
                double f8 = 0.0;
                for (i = 0; i < pxpy.length; ++i) {
                    if (!(0.0 < pxpy[i])) continue;
                    f8 -= pxpy[i] * Math.log(pxpy[i]);
                }
                for (i = 0; i < pxpy.length; ++i) {
                    if (!(0.0 < pxpy[i])) continue;
                    result += ((double)(i + 2) - f8) * ((double)(i + 2) - f8) * pxpy[i];
                }
                break;
            }
            case 7: {
                for (int i = 0; i < pxpy.length; ++i) {
                    if (!(0.0 < pxpy[i])) continue;
                    result -= pxpy[i] * Math.log(pxpy[i]);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < ng; ++i) {
                    for (int j = 0; j < ng; ++j) {
                        if (!(0.0 < mx[i][j])) continue;
                        result -= mx[i][j] * Math.log(mx[i][j]);
                    }
                }
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                for (int i = 0; i < pxmy.length; ++i) {
                    if (!(0.0 < pxmy[i])) continue;
                    result -= pxmy[i] * Math.log(pxmy[i]);
                }
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
        }
        return result;
    }

    public final int extractRegion4(boolean[] binaryMap, int[] resultMap) {
        this.neighborFrame.set4();
        return this.extractRegion(binaryMap, resultMap);
    }

    public final int extractRegion8(boolean[] binaryMap, int[] resultMap) {
        this.neighborFrame.set8();
        return this.extractRegion(binaryMap, resultMap);
    }

    private final int extractRegion(boolean[] binaryMap, int[] resultMap) {
        int start = 0;
        int background = start - 1;
        Arrays.fill(resultMap, background);
        int numberRegion = start;
        for (int pn = 0; pn < binaryMap.length; ++pn) {
            if (!binaryMap[pn] || resultMap[pn] != background) continue;
            resultMap[pn] = numberRegion;
            fifo.add(pn);
            do {
                int cp = fifo.get();
                int[] neighbor = this.neighborFrame.getExist(cp);
                for (int i = 0; i < neighbor.length; ++i) {
                    int cn = cp + neighbor[i];
                    if (!binaryMap[cn] || resultMap[cn] != background) continue;
                    resultMap[cn] = numberRegion;
                    fifo.add(cn);
                }
            } while (0 < fifo.getSize());
            ++numberRegion;
        }
        return numberRegion;
    }

    public final int makeConnectMap(int[][] connection, int[] map) {
        Arrays.fill(map, -1);
        int numberRegion = 0;
        int nHalf = this.neighborFrame.getNumber() / 2;
        for (int pn = 0; pn < this.neighborFrame.size; ++pn) {
            int cn;
            int i;
            int[] neighbor;
            if (map[pn] == -1) {
                neighbor = this.neighborFrame.getDir(pn);
                for (i = 0; i < neighbor.length; ++i) {
                    cn = pn + neighbor[i];
                    if (!this.checkConnection(pn, connection[pn], cn, connection[cn]) || map[cn] <= -1) continue;
                    map[pn] = map[cn];
                    break;
                }
            }
            if (map[pn] != -1) continue;
            int cp = pn;
            int direction = -1;
            block2: do {
                if (map[cp] == -1) {
                    map[cp] = numberRegion;
                }
                neighbor = this.neighborFrame.getDir(cp);
                for (i = 0; i < neighbor.length; ++i) {
                    cn = cp + neighbor[direction = (direction + 1) % neighbor.length];
                    if (!this.checkConnection(cp, connection[cp], cn, connection[cn])) continue;
                    cp = cn;
                    direction += nHalf;
                    continue block2;
                }
            } while (cp != pn);
            ++numberRegion;
        }
        return numberRegion;
    }

    private boolean checkConnection(int c, int[] cNeighbor, int n, int[] nNeighbor) {
        int i;
        if (c == n) {
            return false;
        }
        for (i = 0; i < cNeighbor.length; ++i) {
            if (cNeighbor[i] != n) continue;
            return true;
        }
        for (i = 0; i < nNeighbor.length; ++i) {
            if (nNeighbor[i] != c) continue;
            return true;
        }
        return false;
    }

    public int[] getHDome4(int h, int[] iMask) {
        int[] iMarker = new int[iMask.length];
        for (int pn = 0; pn < iMask.length; ++pn) {
            iMarker[pn] = iMask[pn] - h;
        }
        this.reconstruct4(iMask, iMarker);
        int[] result = new int[iMask.length];
        for (int pn = 0; pn < iMask.length; ++pn) {
            result[pn] = iMask[pn] - iMarker[pn];
        }
        return result;
    }

    public NeighborFrame getNeighborFrame() {
        return this.neighborFrame;
    }
}

