/*
 * Decompiled with CFR 0.152.
 */
package sos.process;

public class NeighborFrame {
    public int width;
    public int height;
    public int size;
    private int[] neighborIndex;
    private int neighborNumber;
    int[][] direct = null;
    int[][] exist = null;
    int[][] dir4 = new int[9][4];
    int[][] ex4 = new int[9][];
    int[][] dir8 = new int[9][8];
    int[][] ex8 = new int[9][];

    public NeighborFrame(int w, int h) {
        this.width = w;
        this.height = h;
        this.size = this.width * this.height;
        this.setNeighbors();
        this.setElements();
        this.set8();
    }

    private void setNeighbors() {
        int i;
        this.neighborIndex = new int[this.size];
        for (i = 0; i < this.neighborIndex.length; ++i) {
            this.neighborIndex[i] = 8;
        }
        for (i = 1; i < this.width - 1; ++i) {
            this.neighborIndex[i] = 5;
            this.neighborIndex[this.size - 1 - i] = 1;
        }
        for (i = 1; i < this.height - 1; ++i) {
            this.neighborIndex[this.width * i] = 7;
            this.neighborIndex[this.width * i + this.width - 1] = 3;
        }
        this.neighborIndex[0] = 6;
        this.neighborIndex[this.width - 1] = 4;
        this.neighborIndex[this.size - 1] = 2;
        this.neighborIndex[this.size - this.width] = 0;
    }

    private final void setElements() {
        this.dir8[0] = new int[]{0, 0, 0, 1, -this.width + 1, -this.width, 0, 0};
        this.dir8[1] = new int[]{0, 0, 0, 1, -this.width + 1, -this.width, -this.width - 1, -1};
        this.dir8[2] = new int[]{0, 0, 0, 0, 0, -this.width, -this.width - 1, -1};
        this.dir8[3] = new int[]{this.width - 1, this.width, 0, 0, 0, -this.width, -this.width - 1, -1};
        this.dir8[4] = new int[]{this.width - 1, this.width, 0, 0, 0, 0, 0, -1};
        this.dir8[5] = new int[]{this.width - 1, this.width, this.width + 1, 1, 0, 0, 0, -1};
        this.dir8[6] = new int[]{0, this.width, this.width + 1, 1, 0, 0, 0, 0};
        this.dir8[7] = new int[]{0, this.width, this.width + 1, 1, -this.width + 1, -this.width, 0, 0};
        this.dir8[8] = new int[]{this.width - 1, this.width, this.width + 1, 1, -this.width + 1, -this.width, -this.width - 1, -1};
        this.ex8[0] = new int[]{1, -this.width + 1, -this.width};
        this.ex8[1] = new int[]{1, -this.width + 1, -this.width, -this.width - 1, -1};
        this.ex8[2] = new int[]{-this.width, -this.width - 1, -1};
        this.ex8[3] = new int[]{this.width - 1, this.width, -this.width, -this.width - 1, -1};
        this.ex8[4] = new int[]{this.width - 1, this.width, -1};
        this.ex8[5] = new int[]{this.width - 1, this.width, this.width + 1, 1, -1};
        this.ex8[6] = new int[]{this.width, this.width + 1, 1};
        this.ex8[7] = new int[]{this.width, this.width + 1, 1, -this.width + 1, -this.width};
        this.ex8[8] = new int[]{this.width - 1, this.width, this.width + 1, 1, -this.width + 1, -this.width, -this.width - 1, -1};
        this.dir4[0] = new int[]{0, 1, -this.width, 0};
        this.dir4[1] = new int[]{0, 1, -this.width, -1};
        this.dir4[2] = new int[]{0, 0, -this.width, -1};
        this.dir4[3] = new int[]{this.width, 0, -this.width, -1};
        this.dir4[4] = new int[]{this.width, 0, 0, -1};
        this.dir4[5] = new int[]{this.width, 1, 0, -1};
        this.dir4[6] = new int[]{this.width, 1, 0, 0};
        this.dir4[7] = new int[]{this.width, 1, -this.width, 0};
        this.dir4[8] = new int[]{this.width, 1, -this.width, -1};
        this.ex4[0] = new int[]{1, -this.width};
        this.ex4[1] = new int[]{1, -this.width, -1};
        this.ex4[2] = new int[]{-this.width, -1};
        this.ex4[3] = new int[]{this.width, -this.width, -1};
        this.ex4[4] = new int[]{this.width, -1};
        this.ex4[5] = new int[]{this.width, 1, -1};
        this.ex4[6] = new int[]{this.width, 1};
        this.ex4[7] = new int[]{this.width, 1, -this.width};
        this.ex4[8] = new int[]{this.width, 1, -this.width, -1};
    }

    public final int[] getDir(int pn) {
        return this.direct[this.neighborIndex[pn]];
    }

    public final int[] getExist(int pn) {
        return this.exist[this.neighborIndex[pn]];
    }

    public final void set8() {
        this.direct = this.dir8;
        this.exist = this.ex8;
        this.neighborNumber = 8;
    }

    public final void set4() {
        this.direct = this.dir4;
        this.exist = this.ex4;
        this.neighborNumber = 4;
    }

    public final int getNumber() {
        return this.neighborNumber;
    }
}

