/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.util.ArrayList;
import sos.math.MathVector;
import sos.math.Statistics;
import sos.util.SortDouble;

public final class Sets {
    public static final int[][] enumerate(int dim, int[] template) {
        int[] number = new int[dim + 1];
        number[0] = 1;
        for (int d = 1; d <= dim; ++d) {
            number[d] = number[d - 1] * template.length;
        }
        int[][] result = new int[number[dim]][dim];
        for (int n = 0; n < result.length; ++n) {
            for (int d = 1; d <= dim; ++d) {
                result[n][dim - d] = template[n / number[d - 1] % template.length];
            }
        }
        return result;
    }

    public static final int permutation(int n) {
        int result = 1;
        for (int i = 2; i <= n; ++i) {
            result *= i;
        }
        return result;
    }

    public static final int[][] permutationSets(int first, int last) {
        int n = last - first + 1;
        int[] unit = new int[n];
        int[][] set = new int[Sets.permutation(n)][n];
        for (int i = first; i <= last; ++i) {
            unit[i] = i;
        }
        int[] c = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            c[i] = i;
        }
        int count = 0;
        int k = 1;
        while (k < n) {
            int i = k % 2 == 0 ? 0 : c[k];
            int swap = unit[k];
            unit[k] = unit[i];
            unit[i] = swap;
            System.arraycopy(unit, 0, set[count], 0, n);
            ++count;
            k = 1;
            while (c[k] == 0) {
                c[k] = k;
                ++k;
            }
            int n2 = k;
            c[n2] = c[n2] - 1;
        }
        return set;
    }

    public static final int matchCos(double[][] criteria, double[][] value) {
        double[][] zCriteria = MathVector.zeroSet(criteria, MathVector.mean(criteria));
        double[][] zValue = MathVector.zeroSet(value, MathVector.mean(value));
        int[][] matchSet = Sets.permutationSets(0, criteria.length - 1);
        int matchIndex = 0;
        double sentinel = 0.0;
        for (int n = 0; n < criteria.length; ++n) {
            sentinel += MathVector.cos(zCriteria[n], zValue[matchSet[0][n]]);
        }
        for (int m = 1; m < matchSet.length; ++m) {
            double totalCos = 0.0;
            for (int n = 0; n < criteria.length; ++n) {
                totalCos += MathVector.cos(zCriteria[n], zValue[matchSet[m][n]]);
            }
            if (!(sentinel < totalCos)) continue;
            sentinel = totalCos;
            matchIndex = m;
        }
        return matchIndex;
    }

    public static final int matchCos(int[][] criteria, int[][] value) {
        int[][] zCriteria = MathVector.zeroSet(criteria, MathVector.mean(criteria));
        int[][] zValue = MathVector.zeroSet(value, MathVector.mean(value));
        int[][] matchSet = Sets.permutationSets(0, criteria.length - 1);
        int matchIndex = 0;
        double sentinel = 0.0;
        for (int n = 0; n < criteria.length; ++n) {
            sentinel += MathVector.cos(zCriteria[n], zValue[matchSet[0][n]]);
        }
        for (int m = 1; m < matchSet.length; ++m) {
            double totalCos = 0.0;
            for (int n = 0; n < criteria.length; ++n) {
                totalCos += MathVector.cos(zCriteria[n], zValue[matchSet[m][n]]);
            }
            if (!(sentinel < totalCos)) continue;
            sentinel = totalCos;
            matchIndex = m;
        }
        return matchIndex;
    }

    public static final int matchNorm(double[][] criteria, double[][] value) {
        int[][] matchSet = Sets.permutationSets(0, criteria.length - 1);
        int matchIndex = 0;
        double sentinel = 0.0;
        for (int n = 0; n < criteria.length; ++n) {
            sentinel += MathVector.norm(criteria[n], value[matchSet[0][n]]);
        }
        for (int m = 1; m < matchSet.length; ++m) {
            double totalNorm = 0.0;
            for (int n = 0; n < criteria.length; ++n) {
                totalNorm += MathVector.norm(criteria[n], value[matchSet[m][n]]);
            }
            if (!(totalNorm < sentinel)) continue;
            sentinel = totalNorm;
            matchIndex = m;
        }
        return matchIndex;
    }

    public static final int matchNorm(int[][] criteria, int[][] value) {
        int[][] matchSet = Sets.permutationSets(0, criteria.length - 1);
        int matchIndex = 0;
        int sentinel = 0;
        for (int n = 0; n < criteria.length; ++n) {
            sentinel += MathVector.norm(criteria[n], value[matchSet[0][n]]);
        }
        for (int m = 1; m < matchSet.length; ++m) {
            int totalNorm = 0;
            for (int n = 0; n < criteria.length; ++n) {
                totalNorm += MathVector.norm(criteria[n], value[matchSet[m][n]]);
            }
            if (totalNorm >= sentinel) continue;
            sentinel = totalNorm;
            matchIndex = m;
        }
        return matchIndex;
    }

    public static final int[] matchOrderNorm(int[][] criteria, int[][] finValue) {
        int[] result = new int[criteria.length];
        ArrayList<int[]> initArray = new ArrayList<int[]>();
        ArrayList<int[]> finArray = new ArrayList<int[]>();
        for (int i = 0; i < result.length; ++i) {
            initArray.add(criteria[i]);
            finArray.add(finValue[i]);
        }
        for (int n = 0; n < result.length; ++n) {
            int indexInit = 0;
            int indexFin = 0;
            int sentinel = 999999999;
            for (int i = 0; i < initArray.size(); ++i) {
                if (initArray.get(i) == null) continue;
                for (int j = 0; j < finArray.size(); ++j) {
                    int difference;
                    if (finArray.get(j) == null || (difference = MathVector.norm((int[])initArray.get(i), (int[])finArray.get(j))) >= sentinel) continue;
                    sentinel = difference;
                    indexInit = i;
                    indexFin = j;
                }
            }
            result[indexInit] = indexFin;
            initArray.set(indexInit, null);
            finArray.set(indexFin, null);
        }
        return result;
    }

    public static final int[] match(double[][] data, int[] histogram, double[][] ref, double[][] dest, int[] cluster) {
        int i;
        int m;
        int nRef = ref.length;
        double[][] nMatch = new double[nRef][nRef];
        for (int n = 0; n < nRef; ++n) {
            m = Sets.findNearest(data, ref[n]);
            System.arraycopy(data[m], 0, ref[n], 0, 3);
        }
        if (histogram == null) {
            for (i = 0; i < data.length; ++i) {
                m = Sets.findNearest(ref, data[i]);
                double[] dArray = nMatch[cluster[i]];
                int n = m;
                dArray[n] = dArray[n] + 1.0;
            }
        } else {
            for (i = 0; i < data.length; ++i) {
                m = Sets.findNearest(ref, data[i]);
                double[] dArray = nMatch[cluster[i]];
                int n = m;
                dArray[n] = dArray[n] + (double)histogram[i];
            }
        }
        int[] order = new int[nRef];
        int indexOld = 0;
        int indexNew = 0;
        for (int n = 0; n < order.length; ++n) {
            double sentinel = -1.0;
            for (int i2 = 0; i2 < nRef; ++i2) {
                if (nMatch[i2] == null) continue;
                for (int j = 0; j < nRef; ++j) {
                    double r2;
                    if (ref[j] == null) continue;
                    if (nMatch[i2][j] > sentinel) {
                        sentinel = nMatch[i2][j];
                        indexOld = i2;
                        indexNew = j;
                        continue;
                    }
                    if (nMatch[i2][j] != sentinel || indexNew != j) continue;
                    double r1 = MathVector.norm(dest[indexNew], ref[indexOld]) / MathVector.normSum(dest, ref[indexOld]);
                    indexOld = r1 < (r2 = MathVector.norm(dest[indexNew], ref[i2]) / MathVector.normSum(dest, ref[i2])) ? indexOld : i2;
                }
            }
            order[indexNew] = indexOld;
            nMatch[indexOld] = null;
            ref[indexNew] = null;
        }
        return order;
    }

    public static final int findNearest(int[][] vec1, int[] vec2) {
        int m = 0;
        int minNorm = 0;
        for (int d = 0; d < vec2.length; ++d) {
            minNorm += (vec1[0][d] - vec2[d]) * (vec1[0][d] - vec2[d]);
        }
        for (int n = 1; n < vec1.length; ++n) {
            int norm = 0;
            for (int d = 0; d < vec2.length; ++d) {
                norm += (vec1[n][d] - vec2[d]) * (vec1[n][d] - vec2[d]);
            }
            if (norm >= minNorm) continue;
            m = n;
            minNorm = norm;
        }
        return m;
    }

    public static final int findNearest(double[][] vec1, double[] vec2) {
        int m = 0;
        double minNorm = 0.0;
        for (int d = 0; d < vec2.length; ++d) {
            minNorm += (vec1[0][d] - vec2[d]) * (vec1[0][d] - vec2[d]);
        }
        for (int n = 1; n < vec1.length; ++n) {
            double norm = 0.0;
            for (int d = 0; d < vec2.length; ++d) {
                norm += (vec1[n][d] - vec2[d]) * (vec1[n][d] - vec2[d]);
            }
            if (!(norm < minNorm)) continue;
            m = n;
            minNorm = norm;
        }
        return m;
    }

    public static final int findSecondNearest(double[][] vec1, double[] vec2, int first) {
        int d;
        int m = 0;
        double minNorm = 0.0;
        if (first != 0) {
            for (d = 0; d < vec2.length; ++d) {
                minNorm += (vec1[0][d] - vec2[d]) * (vec1[0][d] - vec2[d]);
            }
        } else {
            for (d = 0; d < vec2.length; ++d) {
                minNorm += (vec1[1][d] - vec2[d]) * (vec1[1][d] - vec2[d]);
            }
            m = 1;
        }
        for (int n = 0; n < vec1.length; ++n) {
            if (n == first) continue;
            double norm = 0.0;
            for (int d2 = 0; d2 < vec2.length; ++d2) {
                norm += (vec1[n][d2] - vec2[d2]) * (vec1[n][d2] - vec2[d2]);
            }
            if (!(norm < minNorm)) continue;
            m = n;
            minNorm = norm;
        }
        return m;
    }

    public static final int findLargestCos(double[][] vec1, double[] vec2) {
        int m = 0;
        double maxCos = MathVector.cos(vec1[0], vec2);
        for (int n = 1; n < vec1.length; ++n) {
            double cos = MathVector.cos(vec1[n], vec2);
            if (!(cos > maxCos)) continue;
            m = n;
            maxCos = cos;
        }
        return m;
    }

    public static final int[][] findKNearestNeighbor(double[][] input, int interval, int k) {
        int c;
        int b;
        int a;
        Statistics stat = new Statistics(input);
        double[] max = stat.getMax();
        double[] min = stat.getMin();
        int[] l = new int[max.length];
        for (int i = 0; i < max.length; ++i) {
            l[i] = (int)((max[i] - min[i]) / (double)interval) + 1;
        }
        ArrayList[][][] zone = new ArrayList[l[0]][l[1]][l[2]];
        for (int x = 0; x < l[0]; ++x) {
            for (int y = 0; y < l[1]; ++y) {
                for (int z = 0; z < l[2]; ++z) {
                    zone[x][y][z] = new ArrayList();
                }
            }
        }
        for (int i = 0; i < input.length; ++i) {
            a = (int)((input[i][0] - min[0]) / (double)interval);
            b = (int)((input[i][1] - min[1]) / (double)interval);
            c = (int)((input[i][2] - min[2]) / (double)interval);
            zone[a][b][c].add(Integer.toString(i));
        }
        int[][] nearestNeighbors = new int[input.length][k];
        for (int in = 0; in < input.length; ++in) {
            int nPoints;
            a = (int)((input[in][0] - min[0]) / (double)interval);
            b = (int)((input[in][1] - min[1]) / (double)interval);
            c = (int)((input[in][2] - min[2]) / (double)interval);
            int coef = 0;
            do {
                nPoints = 0;
                for (int x = -(++coef); x <= coef; ++x) {
                    if (0 > a + x || a + x >= l[0]) continue;
                    for (int y = -coef; y <= coef; ++y) {
                        if (0 > b + y || b + y >= l[1]) continue;
                        for (int z = -coef; z <= coef; ++z) {
                            if (0 > c + z || c + z >= l[2]) continue;
                            nPoints += zone[a + x][b + y][c + z].size();
                        }
                    }
                }
            } while (nPoints <= k);
            double[] norms = new double[nPoints - 1];
            int[] indices = new int[nPoints - 1];
            int count = 0;
            for (int x = -coef; x <= coef; ++x) {
                if (0 > a + x || a + x >= l[0]) continue;
                for (int y = -coef; y <= coef; ++y) {
                    if (0 > b + y || b + y >= l[1]) continue;
                    for (int z = -coef; z <= coef; ++z) {
                        if (0 > c + z || c + z >= l[2]) continue;
                        for (int n = 0; n < zone[a + x][b + y][c + z].size(); ++n) {
                            int index = Integer.parseInt((String)zone[a + x][b + y][c + z].get(n));
                            if (index == in) continue;
                            norms[count] = MathVector.norm(input[in], input[index]);
                            indices[count] = index;
                            ++count;
                        }
                    }
                }
            }
            SortDouble sd = new SortDouble(norms);
            for (int i = 0; i < k; ++i) {
                nearestNeighbors[in][i] = indices[sd.getOrder(i)];
            }
        }
        return nearestNeighbors;
    }
}

