/*
 * Decompiled with CFR 0.152.
 */
package orch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.JFrame;
import orch.ImagePiece;
import orch.SearchPoint;
import sos.canvas.JObjectCanvas;
import sos.graphics.GraphicsAffineTransform;
import sos.graphics.SOSRectangle;
import sos.util.MinMaxDouble;
import sos.util.MinMaxInteger;

public abstract class Matching
extends JFrame {
    protected static final int[] dX = new int[]{0, 1, 0, -1};
    protected static final int[] dY = new int[]{1, 0, -1, 0};
    private static Color transBlue = new Color(0, 0, 255, 15);
    protected volatile boolean pauseFlag;
    protected Rectangle searchBounds = new Rectangle();
    protected SOSRectangle matchedBounds = new SOSRectangle();
    protected SOSRectangle moveArea = new SOSRectangle();
    protected double horizontalOverlapRatio;
    protected double verticalOverlapRatio;
    protected double minOverlapRatio;
    private AffineTransform scaleTransform = new AffineTransform();
    private BufferedImage fixedImages;
    private ImagePiece[][] ipArray;
    private int nRow;
    private int nColumn;
    private Point startCell;
    private GraphicsAffineTransform transform;
    private JObjectCanvas jCanvasMain;

    public Matching() {
        this.moveArea.setColor(transBlue);
    }

    public void init(ImagePiece[][] array) {
        this.initComponents();
        this.ipArray = array;
        this.nRow = this.ipArray.length;
        this.nColumn = this.ipArray[0].length;
        int count = 0;
        for (int y = 0; y < this.nRow; ++y) {
            for (int x = 0; x < this.nColumn; ++x) {
                if (this.ipArray[y][x] == null) continue;
                this.ipArray[y][x].setIndex(count);
                ++count;
            }
        }
        this.setupCanvas();
        this.pack();
        this.setVisible(true);
        this.pauseFlag = false;
    }

    private void setupCanvas() {
        int rowWidth = 0;
        int originalHeight = 0;
        MinMaxInteger mmiHeight = new MinMaxInteger();
        MinMaxInteger mmiWidth = new MinMaxInteger();
        mmiWidth.setInit(0);
        for (int y = 0; y < this.nRow; ++y) {
            rowWidth = 0;
            mmiHeight.setInit(0);
            for (int x = 0; x < this.nColumn; ++x) {
                if (this.ipArray[y][x] == null) continue;
                Dimension size = this.ipArray[y][x].getSize();
                mmiHeight.compareMax(size.height);
                if (x == 0 || x == this.nColumn - 1) {
                    rowWidth += (int)((double)size.width * 1.5);
                    continue;
                }
                rowWidth += size.width;
            }
            originalHeight = y == 0 || y == this.nRow - 1 ? (originalHeight += (int)((double)mmiHeight.getValue() * 1.5)) : (originalHeight += mmiHeight.getValue());
            mmiWidth.compareMax(rowWidth);
        }
        int originalWidth = mmiWidth.getValue();
        int canvasWidth = this.jCanvasMain.getWidth();
        int canvasHeight = (int)(1.0 * (double)originalHeight * (double)canvasWidth / (double)originalWidth);
        if (this.jCanvasMain.getHeight() < canvasHeight) {
            canvasHeight = this.jCanvasMain.getHeight();
            canvasWidth = (int)(1.0 * (double)originalWidth * (double)canvasHeight / (double)originalHeight);
        }
        this.jCanvasMain.setSize(canvasWidth, canvasHeight);
        double meanX = (double)(this.nColumn - 1) / 2.0;
        double meanY = (double)(this.nRow - 1) / 2.0;
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.setInit(Double.POSITIVE_INFINITY);
        for (int y = 0; y < this.nRow; ++y) {
            for (int x = 0; x < this.nColumn; ++x) {
                if (this.ipArray[y][x] == null) continue;
                double value = (meanX - (double)x) * (meanX - (double)x) + (meanY - (double)y) * (meanY - (double)y);
                mmd.compareMin(value, new Point(x, y));
            }
        }
        this.startCell = (Point)mmd.getObject();
        int unitWidth = this.jCanvasMain.getWidth() / (this.nColumn + 1);
        int unitHeight = this.jCanvasMain.getHeight() / (this.nRow + 1);
        double startX = (double)unitWidth * ((double)this.startCell.x + 0.5);
        double startY = (double)unitHeight * ((double)this.startCell.y + 0.5);
        this.scaleTransform.setToTranslation(startX, startY);
        double ratioWidth = 1.0 * (double)this.jCanvasMain.getWidth() / (double)originalWidth;
        double ratioHeight = 1.0 * (double)canvasHeight / (double)originalHeight;
        this.scaleTransform.scale(ratioWidth, ratioHeight);
        this.fixedImages = (BufferedImage)this.createImage(canvasWidth, canvasHeight);
        this.jCanvasMain.setImage(this.fixedImages);
        this.jCanvasMain.getImageTransform().setFullSrc();
        this.transform = new GraphicsAffineTransform(this.scaleTransform);
    }

    public void start(double horizontal, double vertical, double min) {
        this.horizontalOverlapRatio = horizontal;
        this.verticalOverlapRatio = vertical;
        this.minOverlapRatio = min;
        LinkedList<Point> fifo = new LinkedList<Point>();
        fifo.add(this.startCell);
        ImagePiece ip1 = this.ipArray[this.startCell.y][this.startCell.x];
        ip1.setFixed(true);
        this.drawFixedImage(ip1);
        ImagePiece ip2 = null;
        ImagePiece ipSub = null;
        do {
            Point p = (Point)fifo.removeFirst();
            ip1 = this.ipArray[p.y][p.x];
            for (int i = 0; i < dX.length; ++i) {
                int x2 = p.x + dX[i];
                int y2 = p.y + dY[i];
                if (this.pauseFlag || 0 > x2 || x2 >= this.nColumn || 0 > y2 || y2 >= this.nRow || (ip2 = this.ipArray[y2][x2]) == null || ip2.isFixed()) continue;
                ipSub = this.getSubImagePiece(x2, y2, i);
                switch (i) {
                    case 0: {
                        this.setDirectionAndSearch(ip1, ip2, ipSub, false);
                        break;
                    }
                    case 1: {
                        this.setDirectionAndSearch(ip1, ip2, ipSub, true);
                        break;
                    }
                    case 2: {
                        this.setDirectionAndSearch(ip2, ip1, ipSub, false);
                        break;
                    }
                    case 3: {
                        this.setDirectionAndSearch(ip2, ip1, ipSub, true);
                    }
                }
                fifo.add(new Point(x2, y2));
            }
        } while (0 < fifo.size());
    }

    private ImagePiece getSubImagePiece(int x, int y, int i) {
        ImagePiece ip = null;
        int nx = x + dY[i];
        int ny = y + dX[i];
        if (0 <= nx && nx < this.nColumn && 0 <= ny && ny < this.nRow && (ip = this.ipArray[ny][nx]) != null && ip.isFixed()) {
            return ip;
        }
        nx = x - dY[i];
        ny = y - dX[i];
        if (0 <= nx && nx < this.nColumn && 0 <= ny && ny < this.nRow && (ip = this.ipArray[ny][nx]) != null && ip.isFixed()) {
            return ip;
        }
        return null;
    }

    private void setDirectionAndSearch(ImagePiece ip1, ImagePiece ip2, ImagePiece ipSub, boolean isHorizontal) {
        ImagePiece ipMove;
        ImagePiece ipUnmove;
        if (ip1.isFixed() & ip2.isFixed()) {
            return;
        }
        if (ip1.isFixed()) {
            ipUnmove = ip1;
            ipMove = ip2;
        } else {
            ipUnmove = ip2;
            ipMove = ip1;
        }
        this.searchBounds = this.getSearchBounds(ipUnmove, ipMove, isHorizontal);
        this.drawRects(ipUnmove, ipMove, ipSub, null, null);
        if (ipSub != null) {
            Rectangle anotherSearchBounds = this.getSearchBounds(ipSub, ipMove, !isHorizontal);
            this.searchBounds = this.searchBounds.intersection(anotherSearchBounds);
            this.matchThreeImage(ipUnmove, ipMove, ipSub, isHorizontal);
        } else {
            this.matchTwoImage(ipUnmove, ipMove, isHorizontal);
        }
        ipMove.getBounds().setLocation(this.matchedBounds.getLocation());
        ipMove.setFixed(true);
        this.drawFixedImage(ipMove);
    }

    protected abstract Rectangle getSearchBounds(ImagePiece var1, ImagePiece var2, boolean var3);

    protected abstract void matchThreeImage(ImagePiece var1, ImagePiece var2, ImagePiece var3, boolean var4);

    protected abstract void matchTwoImage(ImagePiece var1, ImagePiece var2, boolean var3);

    private void updateFixedImage(ImagePiece ip) {
        Graphics2D g = (Graphics2D)this.fixedImages.getGraphics();
        AffineTransform positionTransform = new AffineTransform(this.scaleTransform);
        Rectangle rect = ip.getBounds();
        positionTransform.translate(rect.x, rect.y);
        g.drawImage(ip.getImage(), positionTransform, this.jCanvasMain);
    }

    protected void drawRects(ImagePiece ipUnmove, ImagePiece ipMove, ImagePiece ipSub, SearchPoint sp1, SearchPoint sp2) {
        this.jCanvasMain.clearGraphicObject();
        this.jCanvasMain.addGraphicObject(this.transform);
        this.jCanvasMain.addGraphicObject(ipUnmove);
        if (ipSub != null) {
            this.jCanvasMain.addGraphicObject(ipSub);
        }
        Rectangle rectMove = ipMove.getBounds();
        this.moveArea.setBounds(this.searchBounds);
        this.moveArea.width += rectMove.width;
        this.moveArea.height += rectMove.height;
        this.jCanvasMain.addGraphicObject(this.moveArea);
        if (this.matchedBounds != null) {
            this.matchedBounds.setSize(rectMove.width, rectMove.height);
            this.jCanvasMain.addGraphicObject(this.matchedBounds);
        }
        if (sp1 != null) {
            this.jCanvasMain.addGraphicObject(sp1);
        }
        if (sp2 != null) {
            this.jCanvasMain.addGraphicObject(sp2);
        }
        this.jCanvasMain.repaint();
    }

    private void drawFixedImage(ImagePiece ip) {
        this.updateFixedImage(ip);
        this.jCanvasMain.repaint();
    }

    private void initComponents() {
        this.jCanvasMain = new JObjectCanvas();
        this.setDefaultCloseOperation(3);
        this.setTitle("Matching");
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                Matching.this.formKeyPressed(evt);
            }
        });
        this.jCanvasMain.setPreferredSize(new Dimension(640, 480));
        this.getContentPane().add((Component)this.jCanvasMain, "Center");
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.pauseFlag = true;
        }
    }
}

