/*
 * Decompiled with CFR 0.152.
 */
package orch.plugin;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import orch.ImagePiece;
import orch.Matching;
import orch.SearchPoint;
import sos.util.SortDouble;

public class CoarseFineMatching
extends Matching {
    protected Rectangle getSearchBounds(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal) {
        boolean reverseUnion = ipUnmove.getIndex() >= ipMove.getIndex();
        Rectangle rect = ipUnmove.getBounds();
        Rectangle result = new Rectangle();
        Dimension size = new Dimension();
        size.width = (int)((double)rect.width * this.horizontalOverlapRatio);
        size.height = (int)((double)rect.height * this.verticalOverlapRatio);
        Dimension minSize = new Dimension();
        minSize.width = (int)((double)rect.width * this.minOverlapRatio);
        minSize.height = (int)((double)rect.height * this.minOverlapRatio);
        if (isHorizontal) {
            if (reverseUnion) {
                result.setLocation(rect.x - rect.width + minSize.width, rect.y - size.height);
            } else {
                result.setLocation(rect.x + rect.width - size.width, rect.y - size.height);
            }
            result.setSize(size.width - minSize.width, size.height * 2);
        } else {
            if (reverseUnion) {
                result.setLocation(rect.x - size.width, rect.y - rect.height + minSize.height);
            } else {
                result.setLocation(rect.x - size.width, rect.y + rect.height - size.height);
            }
            result.setSize(size.width * 2, size.height - minSize.height);
        }
        return result;
    }

    protected void matchThreeImage(ImagePiece ipUnmove, ImagePiece ipMove, ImagePiece ipSub, boolean isHorizontal) {
        int step = ipMove.getThumbnailOriginalRatio();
        SearchPoint[][] points = this.getSearchPoints(ipUnmove.getBounds(), ipMove.getBounds(), ipSub.getBounds(), step);
        SearchPoint[] pointsMain = points[0];
        SearchPoint[] pointsSub = points[1];
        double currentFitness = 0.0;
        do {
            double[] fitnesses = new double[pointsMain.length];
            for (int i = 0; i < fitnesses.length && !this.pauseFlag; ++i) {
                currentFitness = this.calcFitness(ipUnmove, ipMove, pointsMain[i], step);
                double ratioPre = 1.0 * (double)pointsMain[i].getRectSize() / (double)(pointsMain[i].getRectSize() + pointsSub[i].getRectSize());
                fitnesses[i] = ratioPre * currentFitness + (1.0 - ratioPre) * this.calcFitness(ipSub, ipMove, pointsSub[i], step);
            }
            SortDouble sd = new SortDouble(fitnesses);
            this.matchedBounds.setLocation(pointsMain[sd.getOrder(0)].getLocation());
            this.drawRects(ipUnmove, ipMove, ipSub, pointsMain[sd.getOrder(0)], pointsSub[sd.getOrder(0)]);
            pointsMain = this.sortSearchPoints(sd, pointsMain, step /= 2);
            pointsSub = this.sortSearchPoints(sd, pointsSub, step);
            ipUnmove.clearRGB();
            ipMove.clearRGB();
        } while (0 < step && !this.pauseFlag);
    }

    protected void matchTwoImage(ImagePiece ipUnmove, ImagePiece ipMove, boolean isHorizontal) {
        int step = ipMove.getThumbnailOriginalRatio();
        SearchPoint[] pointsMain = this.getSearchPoints(ipUnmove.getBounds(), ipMove.getBounds(), step);
        do {
            double[] fitnesses = new double[pointsMain.length];
            for (int i = 0; i < fitnesses.length; ++i) {
                fitnesses[i] = this.calcFitness(ipUnmove, ipMove, pointsMain[i], step);
            }
            SortDouble sd = new SortDouble(fitnesses);
            System.out.println(this.matchedBounds);
            this.matchedBounds.setLocation(pointsMain[sd.getOrder(0)].getLocation());
            this.drawRects(ipUnmove, ipMove, null, pointsMain[sd.getOrder(0)], null);
            pointsMain = this.sortSearchPoints(sd, pointsMain, step /= 2);
            ipUnmove.clearRGB();
            ipMove.clearRGB();
        } while (0 < step && !this.pauseFlag);
    }

    private SearchPoint[] getSearchPoints(Rectangle rect1, Rectangle rect2, int step) {
        ArrayList<SearchPoint> tempList = new ArrayList<SearchPoint>(this.searchBounds.width * this.searchBounds.height / (step * step));
        for (int y = this.searchBounds.y; y < this.searchBounds.y + this.searchBounds.height; y += step) {
            for (int x = this.searchBounds.x; x < this.searchBounds.x + this.searchBounds.width; x += step) {
                rect2.setLocation(x, y);
                Rectangle intersectRect = rect1.intersection(rect2);
                if (0 >= intersectRect.width * intersectRect.height) continue;
                SearchPoint searchPoint = new SearchPoint(x, y);
                searchPoint.setIntersectRect(intersectRect);
                tempList.add(searchPoint);
            }
        }
        tempList.toArray();
        SearchPoint[] result = new SearchPoint[tempList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (SearchPoint)tempList.get(i);
        }
        return result;
    }

    private SearchPoint[][] getSearchPoints(Rectangle rect1, Rectangle rect2, Rectangle rect3, int step) {
        SearchPoint[] tempList1 = new SearchPoint[this.searchBounds.width * this.searchBounds.height / (step * step)];
        SearchPoint[] tempList2 = new SearchPoint[this.searchBounds.width * this.searchBounds.height / (step * step)];
        int count = 0;
        for (int y = this.searchBounds.y; y < this.searchBounds.y + this.searchBounds.height; y += step) {
            for (int x = this.searchBounds.x; x < this.searchBounds.x + this.searchBounds.width; x += step) {
                rect2.setLocation(x, y);
                Rectangle intersectRect1 = rect1.intersection(rect2);
                rect2.setLocation(x, y);
                Rectangle intersectRect2 = rect3.intersection(rect2);
                if (0 >= intersectRect1.width * intersectRect1.height * intersectRect2.width * intersectRect2.height) continue;
                SearchPoint searchPoint1 = new SearchPoint(x, y);
                searchPoint1.setIntersectRect(intersectRect1);
                SearchPoint searchPoint2 = new SearchPoint(searchPoint1.getLocation());
                searchPoint2.setIntersectRect(intersectRect2);
                tempList1[count] = searchPoint1;
                tempList2[count] = searchPoint2;
                ++count;
            }
        }
        SearchPoint[][] result = new SearchPoint[2][count];
        for (int i = 0; i < count; ++i) {
            result[0][i] = tempList1[i];
            result[1][i] = tempList2[i];
        }
        return result;
    }

    private SearchPoint[] sortSearchPoints(SortDouble sd, SearchPoint[] points, int step) {
        Point loc;
        int i;
        int newN = step == 1 ? 1 : points.length / 16;
        SearchPoint[] result = new SearchPoint[newN * 4];
        for (int i2 = 0; i2 < newN; ++i2) {
            int index = sd.getOrder(i2);
            result[i2] = points[index];
        }
        int offset = newN;
        for (i = 0; i < newN; ++i) {
            loc = result[i].getLocation();
            result[i + offset] = new SearchPoint(loc.x + step, loc.y);
        }
        offset = newN * 2;
        for (i = 0; i < newN; ++i) {
            loc = result[i].getLocation();
            result[i + offset] = new SearchPoint(loc.x, loc.y + step);
        }
        offset = newN * 3;
        for (i = 0; i < newN; ++i) {
            loc = result[i].getLocation();
            result[i + offset] = new SearchPoint(loc.x + step, loc.y + step);
        }
        return result;
    }

    private double calcFitness(ImagePiece ipFixed, ImagePiece ipFloppy, SearchPoint searchPoint, int step) {
        if (searchPoint.isSaturated()) {
            return searchPoint.getSaturatedFitness();
        }
        Rectangle rectFixed = ipFixed.getBounds();
        Rectangle rectFloppy = ipFloppy.getBounds();
        int[] grayFixed = ipFixed.getPixelsData(step);
        int[] grayFloppy = ipFloppy.getPixelsData(step);
        rectFloppy.setLocation(searchPoint.getLocation());
        Rectangle interRect = searchPoint.getIntersectRect();
        if (interRect == null) {
            interRect = rectFixed.intersection(rectFloppy);
            searchPoint.setIntersectRect(interRect);
        }
        int sum = 0;
        int count = 0;
        int offStart1 = interRect.x - rectFixed.x + (interRect.y - rectFixed.y) * rectFixed.width;
        int offStart2 = interRect.x - rectFloppy.x + (interRect.y - rectFloppy.y) * rectFloppy.width;
        for (int y = interRect.y; y < interRect.y + interRect.height; y += step) {
            int off1 = offStart1 + (y - interRect.y) * rectFixed.width;
            int off2 = offStart2 + (y - interRect.y) * rectFloppy.width;
            for (int x = interRect.x; x < interRect.x + interRect.width; x += step) {
                sum += Math.abs(grayFixed[off1] - grayFloppy[off2]);
                ++count;
                off1 += step;
                off2 += step;
            }
        }
        double result = 1.0 * (double)sum / (double)count;
        return result;
    }
}

