/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import jp.sourceforge.sos.gunmetry.main.RegionSet;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.IGraphics;

abstract class AbstractRegion
implements IGraphics {
    protected RegionSet regionSet;
    private ButtonModel buttonModel = new JToggleButton.ToggleButtonModel();
    private ColorModel colorModel;

    AbstractRegion(RegionSet regionSet) {
        this.buttonModel.setSelected(true);
        this.colorModel = new ColorModel();
        this.regionSet = regionSet;
    }

    public String toString() {
        return this.getClass() + "." + this.regionSet;
    }

    ButtonModel getButtonModel() {
        return this.buttonModel;
    }

    ColorModel getColorModel() {
        return this.colorModel;
    }

    Color getColor() {
        return this.colorModel.getColor();
    }

    void setColor(Color color) {
        this.colorModel.setColor(color);
    }

    protected boolean needToDraw() {
        return this.buttonModel.isSelected() && this.regionSet.size() > 0;
    }
}

