/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.gunmetry.graphics.AbstractRegion;
import jp.sourceforge.sos.gunmetry.graphics.RegionCentroid;
import jp.sourceforge.sos.gunmetry.graphics.RegionContour;
import jp.sourceforge.sos.gunmetry.graphics.RegionPath;
import jp.sourceforge.sos.gunmetry.main.ModelMain;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;

public class ModelGraphics
implements IModel {
    static final Color[] defaultColors = new Color[]{Color.black, Color.black, Color.cyan, Color.blue, Color.white};
    private AbstractRegion[] regions = new AbstractRegion[5];
    private ModelMain model;

    public void setAbstraction(IAbstraction abstraction) {
        this.model = (ModelMain)abstraction;
        this.regions[0] = new RegionContour(this.model.getNuclei());
        this.regions[1] = new RegionContour(this.model.getSkiz());
        this.regions[2] = new RegionCentroid(this.model.getNuclei());
        this.regions[3] = new RegionCentroid(this.model.getSkiz());
        this.regions[4] = new RegionPath(this.model.getNuclei());
        JObjectCanvas canvas = this.model.getCanvas();
        int i = 0;
        while (i < this.regions.length) {
            this.regions[i].setColor(defaultColors[i]);
            canvas.addGraphicObject(3 + i, this.regions[i]);
            ++i;
        }
    }

    AbstractRegion getRegion(int i) {
        return this.regions[i];
    }

    AbstractRegion[] getRegions() {
        return this.regions;
    }
}

