/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.graphics.ModelGraphics;
import jp.sourceforge.sos.gunmetry.graphics.PanelRegion;

public class ViewPanel
extends JPanel
implements IPresentation {
    private static final String pathResource = "/jp/sourceforge/sos/gunmetry/resources/";
    private ModelGraphics model;
    private PanelRegion regionCentroid = null;
    private PanelRegion regionContour = null;
    private PanelRegion skizContour = null;
    private PanelRegion skizCentroid = null;
    private PanelRegion regionPath = null;

    public ViewPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder(null, "Results", 0, 0, null, null));
        this.add((Component)this.getRegionContour(), null);
        this.add((Component)this.getSkizContour(), null);
        this.add((Component)this.getRegionCentroid(), null);
        this.add((Component)this.getSkizCentroid(), null);
        this.add((Component)this.getRegionPath(), null);
    }

    public void setAbstraction(IAbstraction abstraction) {
        this.model = (ModelGraphics)abstraction;
        this.regionContour.init(this.model.getRegion(0), this.getIcon("reBtn1.gif"));
        this.skizContour.init(this.model.getRegion(1), this.getIcon("reBtn2.gif"));
        this.regionCentroid.init(this.model.getRegion(2), this.getIcon("reBtn3.gif"));
        this.skizCentroid.init(this.model.getRegion(3), this.getIcon("reBtn4.gif"));
        this.regionPath.init(this.model.getRegion(4), this.getIcon("reBtn5.gif"));
    }

    private ImageIcon getIcon(String path) {
        URL url = this.getClass().getResource(pathResource + path);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    private PanelRegion getRegionCentroid() {
        if (this.regionCentroid == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.gridy = -1;
            this.regionCentroid = new PanelRegion();
        }
        return this.regionCentroid;
    }

    PanelRegion getRegionContour() {
        if (this.regionContour == null) {
            this.regionContour = new PanelRegion();
        }
        return this.regionContour;
    }

    PanelRegion getSkizContour() {
        if (this.skizContour == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            this.skizContour = new PanelRegion();
        }
        return this.skizContour;
    }

    private PanelRegion getSkizCentroid() {
        if (this.skizCentroid == null) {
            this.skizCentroid = new PanelRegion();
        }
        return this.skizCentroid;
    }

    private PanelRegion getRegionPath() {
        if (this.regionPath == null) {
            this.regionPath = new PanelRegion();
        }
        return this.regionPath;
    }
}

