/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.gunmetry.image.ModelImage;
import jp.sourceforge.sos.lib.design.observer.IObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewPanel
extends JPanel
implements IPresentation,
IObserver<Image> {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton jRadioOriginal = null;
    private JRadioButton jRadioGradient = null;
    private JRadioButton jRadioCluster = null;
    private JButton jButton = null;
    private JButton jButtonSetCluster = null;
    protected ModelImage modelImage;
    private JButton jButtonReset = null;

    ViewPanel() {
        this.initialize();
        this.buttonGroup.add(this.jRadioCluster);
        this.buttonGroup.add(this.jRadioGradient);
        this.buttonGroup.add(this.jRadioOriginal);
        Mediator.add(Mediator.Subjects.LOAD, this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.gridy = 3;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridx = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Image", 0, 0, null, null));
        this.add((Component)this.getJRadioOriginal(), gridBagConstraints5);
        this.add((Component)this.getJRadioGradient(), gridBagConstraints4);
        this.add((Component)this.getJRadioCluster(), gridBagConstraints);
        this.add((Component)this.getJButton(), gridBagConstraints2);
        this.add((Component)this.getJButtonSetCluster(), gridBagConstraints3);
        this.add((Component)this.getJButtonReset(), gridBagConstraints1);
    }

    @Override
    public void setAbstraction(IAbstraction abstraction) {
        this.modelImage = (ModelImage)abstraction;
    }

    private JRadioButton getJRadioCluster() {
        if (this.jRadioCluster == null) {
            this.jRadioCluster = new JRadioButton();
            this.jRadioCluster.setEnabled(false);
            this.jRadioCluster.setPreferredSize(new Dimension(75, 24));
            this.jRadioCluster.setText("cluster");
            this.jRadioCluster.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (ViewPanel.this.jRadioCluster.isSelected()) {
                        ViewPanel.this.modelImage.setCluster();
                    }
                }
            });
        }
        return this.jRadioCluster;
    }

    private JRadioButton getJRadioOriginal() {
        if (this.jRadioOriginal == null) {
            this.jRadioOriginal = new JRadioButton();
            this.jRadioOriginal.setSelected(true);
            this.jRadioOriginal.setPreferredSize(new Dimension(75, 24));
            this.jRadioOriginal.setText("original");
            this.jRadioOriginal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewPanel.this.modelImage.setOriginal();
                }
            });
        }
        return this.jRadioOriginal;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setFocusCycleRoot(true);
            this.jButton.setText("Load");
            this.jButton.setFocusPainted(false);
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean value = ViewPanel.this.modelImage.loadOriginal();
                    if (value) {
                        Mediator.inform(Mediator.Subjects.LOAD, ViewPanel.this.modelImage.getImage());
                    } else {
                        Mediator.inform(Mediator.Subjects.LOAD, null);
                    }
                    ViewPanel.this.jRadioOriginal.setSelected(true);
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButtonSetCluster() {
        if (this.jButtonSetCluster == null) {
            this.jButtonSetCluster = new JButton();
            this.jButtonSetCluster.setEnabled(false);
            this.jButtonSetCluster.setText("Load");
            this.jButtonSetCluster.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean value = ViewPanel.this.modelImage.loadCluster();
                    ViewPanel.this.jRadioCluster.setEnabled(value);
                    ViewPanel.this.jButtonReset.setEnabled(value);
                }
            });
        }
        return this.jButtonSetCluster;
    }

    private JRadioButton getJRadioGradient() {
        if (this.jRadioGradient == null) {
            this.jRadioGradient = new JRadioButton();
            this.jRadioGradient.setEnabled(false);
            this.jRadioGradient.setPreferredSize(new Dimension(75, 24));
            this.jRadioGradient.setText("gradient");
            this.jRadioGradient.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewPanel.this.modelImage.setGradient();
                }
            });
        }
        return this.jRadioGradient;
    }

    @Override
    public void update(Image img) {
        boolean b = img != null;
        this.jRadioGradient.setEnabled(b);
        this.jButtonSetCluster.setEnabled(b);
    }

    private JButton getJButtonReset() {
        if (this.jButtonReset == null) {
            this.jButtonReset = new JButton();
            this.jButtonReset.setText("re-set markers");
            this.jButtonReset.setEnabled(false);
            this.jButtonReset.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewPanel.this.modelImage.setMarker();
                }
            });
        }
        return this.jButtonReset;
    }
}

