/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.main;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class Region {
    private int size = 0;
    private Rectangle bounds;
    private boolean[] unmask;
    private int minDistance;
    private Region nearestNeighbor;

    public Region() {
    }

    public Region(Point p) {
        this.bounds = new Rectangle(p.x, p.y, 1, 1);
    }

    public void expandRegion(int x, int y) {
        if (this.bounds == null) {
            this.bounds = new Rectangle(x, y, 1, 1);
        } else {
            this.bounds.add(x, y);
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void initUnmask() {
        this.size = 0;
        if (this.bounds != null) {
            this.unmask = new boolean[this.bounds.width * this.bounds.height];
        }
    }

    public void setUnmask(int x, int y) {
        int index = x + y * this.bounds.width;
        this.unmask[index] = true;
        ++this.size;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    /*
     * WARNING - void declaration
     */
    public Point2D.Double getCentroid() {
        void var2_2;
        void var1_1;
        if (this.bounds != null) {
            int cumX = this.bounds.x * this.size;
            int cumY = this.bounds.y * this.size;
            int y = 0;
            while (y < this.bounds.height) {
                int offset = y * this.bounds.width;
                int x = 0;
                while (x < this.bounds.width) {
                    if (this.unmask[offset + x]) {
                        cumX += x;
                        cumY += y;
                    }
                    ++x;
                }
                ++y;
            }
        } else {
            return null;
        }
        return new Point2D.Double(1.0 * (double)var1_1 / (double)this.size, 1.0 * (double)var2_2 / (double)this.size);
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(int minDistance) {
        this.minDistance = minDistance;
    }

    public Region getNearestNeighbor() {
        return this.nearestNeighbor;
    }

    public void setNearestNeighbor(Region nearestNeighbor) {
        this.nearestNeighbor = nearestNeighbor;
    }

    public boolean getUnmask(int index) {
        return this.unmask[index];
    }

    public int getSize() {
        return this.size;
    }
}

