/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.IGraphics;
import jp.sourceforge.sos.lib.graphics.PointRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerSet
implements IGraphics {
    private ArrayList<Point> pointList = new ArrayList();
    private PointRect pointRect;
    private HashSet<Point> selectedMarker = new HashSet();
    private boolean visible = true;
    private ColorModel colorModel = new ColorModel();
    private String name;

    public MarkerSet() {
    }

    public MarkerSet(String string) {
        this.name = string;
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    @Override
    public void draw(Graphics g) {
        if (this.visible) {
            this.drawSelected(g);
            this.drawPoints(g);
        }
    }

    private void drawPoints(Graphics g) {
        if (this.pointList.size() > 0) {
            g.setColor(this.getColor());
            int i = 0;
            while (i < this.pointList.size()) {
                Point p = this.pointList.get(i);
                this.pointRect.setLocation(p.x, p.y);
                this.pointRect.draw(g);
                ++i;
            }
        }
    }

    private void drawSelected(Graphics g) {
        this.pointRect.setFillRect(true);
        if (this.selectedMarker.size() > 0) {
            g.setColor(Color.white);
            for (Point p : this.selectedMarker) {
                this.pointRect.setLocation(p.x, p.y);
                this.pointRect.draw(g);
            }
        }
        this.pointRect.setFillRect(false);
    }

    public void setAll(ArrayList<Point> points) {
        this.pointList.clear();
        this.pointList.addAll(points);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setColor(Color color) {
        this.colorModel.setColor(color);
    }

    public void setPointRect(PointRect pointRect) {
        this.pointRect = pointRect;
    }

    public Point get(Point2D point) {
        int i = 0;
        while (i < this.pointList.size()) {
            Point p = this.pointList.get(i);
            this.pointRect.setLocation(p.x, p.y);
            if (this.pointRect.contains(point)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public void add(String strPoint, double ratioX, double ratioY) {
        String[] location = strPoint.split(",");
        int x = (int)((double)Integer.valueOf(location[0]).intValue() * ratioX);
        int y = (int)((double)Integer.valueOf(location[1]).intValue() * ratioY);
        Point p = new Point(x, y);
        this.pointList.add(p);
    }

    public void select(Shape shape) {
        Rectangle rect = shape.getBounds();
        int i = 0;
        while (i < this.pointList.size()) {
            Point p = this.pointList.get(i);
            if (rect.contains(p)) {
                this.selectedMarker.add(p);
            }
            ++i;
        }
    }

    public void select(Point p) {
        int index = this.pointList.indexOf(p);
        if (-1 < index) {
            this.selectedMarker.add(this.pointList.get(index));
        }
    }

    public void clearSelection() {
        this.selectedMarker.clear();
    }

    public void removeSelected() {
        this.pointList.removeAll(this.selectedMarker);
        this.clearSelection();
    }

    public void translateSelected(int dx, int dy) {
        for (Point p : this.selectedMarker) {
            p.translate(dx, dy);
        }
    }

    public boolean add(Point o) {
        return this.pointList.add(o);
    }

    public void clear() {
        this.pointList.clear();
    }

    public Point get(int index) {
        return this.pointList.get(index);
    }

    public Iterator<Point> iterator() {
        return this.pointList.iterator();
    }

    public Point remove(int index) {
        return this.pointList.remove(index);
    }

    public boolean remove(Object o) {
        return this.pointList.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return this.pointList.removeAll(c);
    }

    public int size() {
        return this.pointList.size();
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Color getColor() {
        return this.colorModel.getColor();
    }

    public void addAll(Collection<Point> points) {
        this.pointList.addAll(points);
    }
}

