/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.gunmetry.main.ModelMain;
import jp.sourceforge.sos.gunmetry.main.RegionSet;
import jp.sourceforge.sos.gunmetry.marker.FocusedMarker;
import jp.sourceforge.sos.gunmetry.marker.MarkerColorPicker;
import jp.sourceforge.sos.gunmetry.marker.MarkerSet;
import jp.sourceforge.sos.gunmetry.marker.Memento;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.GraphicsRestoreTransform;
import jp.sourceforge.sos.lib.graphics.PointRect;
import jp.sourceforge.sos.lib.image.ImageInfo;
import jp.sourceforge.sos.lib.image.ROIRectangle;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.data.DataBinary;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.GeodesicDistance;
import jp.sourceforge.sos.lib.morphology.extra.Watershed;
import jp.sourceforge.sos.lib.util.SOSArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMarker
implements IModel {
    private static final int BACKGROUND = 0;
    private static SOSFileIO textFileIO = new SOSFileIO();
    private MarkerSet object = new MarkerSet("object");
    private MarkerSet background = new MarkerSet("background");
    private FocusedMarker focusedMarker;
    private PointRect pointRect = new PointRect(0, 0, 5);
    private ROIRectangle selectionRect = new ROIRectangle();
    private MarkerColorPicker colorPicker = new MarkerColorPicker();
    private JObjectCanvas canvas;
    private ModelMain modelMain;
    private ImageInfo imageInfo;
    private double[] gradient;
    private LinkedList<Memento> mementos = new LinkedList();

    public ModelMarker() {
        this.pointRect.setVisible(true);
        this.pointRect.setDrawBounds(true);
        this.object.setPointRect(this.pointRect);
        this.object.setColor(Color.red);
        this.background.setPointRect(this.pointRect);
        this.background.setColor(Color.yellow);
        this.focusedMarker = new FocusedMarker(this.object, this.background);
        this.setupKeyInput();
    }

    private void setupKeyInput() {
        KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor(){

            public boolean postProcessKeyEvent(KeyEvent evt) {
                if (evt.getID() == 401) {
                    int keyCode = evt.getKeyCode();
                    if (keyCode == 127) {
                        ModelMarker.this.object.removeSelected();
                        ModelMarker.this.background.removeSelected();
                        ModelMarker.this.updateNumber();
                    } else if (37 <= keyCode && keyCode <= 40) {
                        ModelMarker.this.translateSelected(keyCode);
                        ModelMarker.this.repaint();
                    }
                }
                return false;
            }
        });
    }

    private void translateSelected(int keyCode) {
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 37: {
                dx = -1;
                break;
            }
            case 38: {
                dy = -1;
                break;
            }
            case 39: {
                dx = 1;
                break;
            }
            case 40: {
                dy = 1;
            }
        }
        this.object.translateSelected(dx, dy);
        this.background.translateSelected(dx, dy);
        this.setMemento();
    }

    @Override
    public void setAbstraction(IAbstraction abstraction) {
        this.modelMain = (ModelMain)abstraction;
        this.canvas = this.modelMain.getCanvas();
        this.canvas.addGraphicObject(this.object);
        this.canvas.addGraphicObject(this.background);
        this.canvas.addGraphicObject(new GraphicsRestoreTransform());
        this.canvas.addGraphicObject(this.selectionRect);
    }

    void clearSelection() {
        this.object.clearSelection();
        this.background.clearSelection();
    }

    void selectFromFocus() {
        this.object.select(this.focusedMarker.get());
        this.background.select(this.focusedMarker.get());
        this.repaint();
    }

    int getBackgroundNumber() {
        return this.background.size();
    }

    int getObjectNumber() {
        return this.object.size();
    }

    void select(Shape rect) {
        this.object.select(rect);
        this.background.select(rect);
        this.selectionRect.setVisible(false);
        this.repaint();
    }

    void setBackgroundColor(Color color) {
        this.background.setColor(color);
        this.repaint();
    }

    void setObjectColor(Color color) {
        this.object.setColor(color);
        this.repaint();
    }

    MarkerSet getObject() {
        return this.object;
    }

    boolean isFocusActive() {
        return this.focusedMarker.isActive();
    }

    void setFocusPoint(Point2D p) {
        int x = (int)p.getX();
        int y = (int)p.getY();
        if (x < 0) {
            x = 0;
        } else if (this.imageInfo.getWidth() <= x) {
            x = this.imageInfo.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (this.imageInfo.getHeight() <= y) {
            y = this.imageInfo.getHeight() - 1;
        }
        this.focusedMarker.setLocation(x, y);
        this.focusedMarker.addToMarkers();
        this.repaint();
        this.setMemento();
    }

    void removeFocus() {
        this.focusedMarker.removeFromMarkers();
        this.repaint();
    }

    boolean isSameFocus(Point2D mousePoint2D) {
        Point preFocus = this.focusedMarker.get();
        this.focusedMarker.set(mousePoint2D);
        return this.focusedMarker.equals(preFocus);
    }

    void repaint() {
        this.canvas.repaint();
    }

    private void updateNumber() {
        this.checkReadyToAnalyze();
        this.setMemento();
        this.repaint();
    }

    ColorModel getObjColorModel() {
        return this.object.getColorModel();
    }

    ColorModel getBackColorModel() {
        return this.background.getColorModel();
    }

    public void setColorPicker(ImageInfo imiCluster) {
        int[] colorCluster = imiCluster.getPixelsLabel();
        this.colorPicker.setColorTable(imiCluster.getPixels(), colorCluster);
        boolean[] flag = this.colorPicker.getFlag();
        this.setMarkers(flag, colorCluster);
    }

    private void setMarkers(boolean[] flag, int[] colorCluster) {
        boolean[] binaryMap = SOSArrays.toBoolean(flag, colorCluster);
        this.object.setAll(this.colorPicker.extractMarkerObj(this.imageInfo.getWidth(), this.imageInfo.getHeight(), binaryMap));
        int i = 0;
        while (i < binaryMap.length) {
            binaryMap[i] = !binaryMap[i];
            ++i;
        }
        this.background.setAll(this.colorPicker.extractMarkerBack(this.imageInfo.getWidth(), this.imageInfo.getHeight(), binaryMap));
        this.updateNumber();
    }

    private void checkReadyToAnalyze() {
        boolean isReady = this.getObjectNumber() > 0 && this.getBackgroundNumber() > 0;
        Mediator.inform(Mediator.Subjects.READY_TO_ANALYSIS, isReady);
    }

    public JObjectCanvas getCanvas() {
        return this.canvas;
    }

    void setPointRectSize(int value) {
        this.pointRect.setSize(value);
        this.repaint();
    }

    void saveMarkers() {
        ArrayList<String> data = new ArrayList<String>();
        data.add(String.valueOf(this.imageInfo.getWidth()) + "," + this.imageInfo.getHeight());
        data.add(Integer.toString(this.getObjectNumber() + 2));
        this.addToData(data, this.object);
        this.addToData(data, this.background);
        textFileIO.resetChoosableFileFilters();
        textFileIO.writeStrings(data);
    }

    private void addToData(ArrayList<String> data, MarkerSet markers) {
        int i = 0;
        while (i < markers.size()) {
            Point p = markers.get(i);
            String arg = String.valueOf(p.x) + "," + p.y;
            data.add(arg);
            ++i;
        }
    }

    void openMarker() {
        ArrayList<String> data = textFileIO.readStrings();
        if (data == null || data.size() == 0) {
            return;
        }
        String[] size = data.get(0).split(",");
        Dimension dim = new Dimension();
        double w = 1.0 * (double)this.imageInfo.getWidth() / (double)Integer.valueOf(size[0]).intValue();
        double h = 1.0 * (double)this.imageInfo.getHeight() / (double)Integer.valueOf(size[1]).intValue();
        dim.setSize(w, h);
        int nObject = Integer.valueOf(data.get(1));
        this.add(this.object, data, 2, nObject, dim);
        this.add(this.background, data, nObject, data.size(), dim);
        this.updateNumber();
    }

    private void add(MarkerSet marker, ArrayList<String> data, int start, int end, Dimension d) {
        marker.clear();
        int i = start;
        while (i < end) {
            String[] location = data.get(i).split(",");
            int x = (int)((double)Integer.valueOf(location[0]).intValue() * d.getWidth());
            int y = (int)((double)Integer.valueOf(location[1]).intValue() * d.getHeight());
            marker.add(new Point(x, y));
            ++i;
        }
    }

    MarkerSet getBackground() {
        return this.background;
    }

    ROIRectangle getSelectionRect() {
        return this.selectionRect;
    }

    void doWatershed() {
        int INIT = -4;
        this.setLabel(INIT);
        Watershed watershed = new Watershed(this.imageInfo, 0);
        watershed.setOrder(this.gradient);
        this.flood(watershed);
        this.setRegion(this.modelMain.getNuclei(), watershed);
        this.modelMain.createImage(this.object.getColor(), this.background.getColor(), this.imageInfo, 0);
        int[] dist = this.makeBackgroungMap(INIT);
        watershed = new Watershed(this.imageInfo, 1);
        watershed.setOrder(dist);
        this.flood(watershed);
        this.setRegion(this.modelMain.getSkiz(), watershed);
        this.modelMain.setNearestNeighbor(dist, this.imageInfo, 0);
        Mediator.inform(Mediator.Subjects.POST_ANALYSIS, Boolean.TRUE);
    }

    private void setLabel(int init) {
        this.imageInfo.fillLabel(init);
        int count = 1;
        boolean[] mask = this.imageInfo.getNeighbor().getMask();
        if (mask == null) {
            this.setLabelSimple(count);
        } else {
            this.setLabelMasked(count, mask);
        }
    }

    private void setLabelMasked(int count, boolean[] mask) {
        int pn;
        int i = 0;
        while (i < this.object.size()) {
            pn = this.imageInfo.pointToOffset(this.object.get(i));
            if (pn >= 0 && !mask[pn]) {
                this.imageInfo.setPixelsLabel(pn, count);
                ++count;
            }
            ++i;
        }
        i = 0;
        while (i < this.background.size()) {
            pn = this.imageInfo.pointToOffset(this.background.get(i));
            if (pn >= 0 && !mask[pn]) {
                this.imageInfo.setPixelsLabel(pn, 0);
            }
            ++i;
        }
    }

    private void setLabelSimple(int count) {
        int i = 0;
        while (i < this.object.size()) {
            this.imageInfo.setPixelsLabel(this.object.get(i), count);
            ++count;
            ++i;
        }
        i = 0;
        while (i < this.background.size()) {
            this.imageInfo.setPixelsLabel(this.background.get(i), 0);
            ++i;
        }
    }

    private void setRegion(RegionSet regions, Watershed watershed) {
        int[] contour = watershed.getWatershed();
        regions.setContour(contour);
        regions.setContourPoints(this.convertToPoints(contour));
        regions.setRegion(this.object, this.imageInfo, 0);
    }

    private Point[] convertToPoints(int[] contour) {
        Point[] result = new Point[contour.length];
        int w = this.imageInfo.getWidth();
        int i = 0;
        while (i < result.length) {
            result[i] = new Point(contour[i] % w, contour[i] / w);
            ++i;
        }
        return result;
    }

    private int[] makeBackgroungMap(int INIT) {
        int[] labels = this.imageInfo.getPixelsLabel();
        boolean[] backgroundMap = new boolean[labels.length];
        int pn = 0;
        while (pn < labels.length) {
            if (labels[pn] > 0) {
                backgroundMap[pn] = false;
            } else {
                labels[pn] = INIT;
                backgroundMap[pn] = true;
            }
            ++pn;
        }
        Neighbor neighbor = this.imageInfo.getNeighbor();
        neighbor.set4();
        GeodesicDistance distance = new GeodesicDistance();
        Elements elements = new Elements(neighbor, new DataBinary(backgroundMap));
        distance.operate(elements);
        return (int[])elements.getResultData();
    }

    private void flood(Watershed watershed) {
        do {
            watershed.flood4();
        } while (!watershed.isConvergence());
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public void setGradient(double[] gradient) {
        this.gradient = gradient;
    }

    public int getImageWidth() {
        return this.imageInfo.getWidth();
    }

    public int getImageHeight() {
        return this.imageInfo.getHeight();
    }

    private void setMemento() {
        this.mementos.add(new Memento(this.object, this.background));
    }

    void restoreMemento() {
        if (!this.mementos.isEmpty()) {
            this.mementos.removeLast();
            Memento memento = this.mementos.getLast();
            memento.restore(this.object, this.background);
            this.repaint();
            this.checkReadyToAnalyze();
        }
    }

    void addPoint(MarkerSet currentMarker, Point2D p2D) {
        Point p = new Point((int)p2D.getX(), (int)p2D.getY());
        if (p.x < 0 || this.imageInfo.getWidth() <= p.x || p.y < 0 || this.imageInfo.getHeight() <= p.y) {
            return;
        }
        currentMarker.add(p);
        this.updateNumber();
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void init() {
        this.object.clear();
        this.background.clear();
        this.modelMain.init();
    }
}

