/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.gunmetry.common.Operation;
import jp.sourceforge.sos.gunmetry.marker.MarkerSet;
import jp.sourceforge.sos.gunmetry.marker.ModelMarker;
import jp.sourceforge.sos.lib.image.ROIRectangle;

class ViewButton
extends Operation {
    private static final Cursor CURSOR_MOVE = new Cursor(13);
    private static MarkerSet currentMarker;
    private ModelMarker modelMarker;
    private MarkerSet marker;
    private BufferedImage imgCursor = new BufferedImage(32, 32, 2);
    private ROIRectangle selectionRect;

    ViewButton(IAbstraction model, MarkerSet marker) {
        this.modelMarker = (ModelMarker)model;
        this.marker = marker;
        this.selectionRect = this.modelMarker.getSelectionRect();
    }

    protected Cursor createCursor() {
        int size = this.imgCursor.getWidth();
        int hSize = size / 2;
        int fqSize = size / 4;
        Graphics g = this.imgCursor.getGraphics();
        Color colorClear = new Color(0, 0, 0, 0);
        g.setColor(colorClear);
        g.fillRect(0, 0, size, size);
        g.setColor(Color.black);
        g.fillRect(fqSize, hSize - 1, hSize + 1, 3);
        g.fillRect(hSize - 1, fqSize, 3, hSize + 1);
        g.setColor(this.marker.getColor());
        g.drawLine(fqSize, hSize, size - fqSize, hSize);
        g.drawLine(hSize, fqSize, hSize, size - fqSize);
        return Toolkit.getDefaultToolkit().createCustomCursor(this.imgCursor, new Point(hSize, hSize), "object");
    }

    protected void setListeners() {
        currentMarker = this.marker;
        super.setListeners();
    }

    private void checkSelectionType(int modifier) {
        if ((modifier & 1) == 0) {
            this.modelMarker.clearSelection();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.modelMarker.isFocusActive()) {
            this.modelMarker.selectFromFocus();
        } else {
            Point2D p2D = canvas.getGraphicsTransform().inverseTransform(e.getPoint());
            this.modelMarker.addPoint(currentMarker, p2D);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() != 4) {
            this.checkSelectionType(e.getModifiers());
            this.selectionRect.handleMousePressed(e.getPoint());
        }
        if (this.modelMarker.isFocusActive()) {
            this.modelMarker.removeFocus();
        } else {
            this.selectionRect.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.modelMarker.isFocusActive()) {
            if (this.selectionRect.isVisible()) {
                Shape rect = canvas.getGraphicsTransform().inverseTransform(this.selectionRect);
                this.modelMarker.select(rect);
            }
        } else {
            Point2D p = canvas.getGraphicsTransform().inverseTransform(e.getPoint());
            this.modelMarker.setFocusPoint(p);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.modelMarker.isFocusActive()) {
            this.selectionRect.handleMouseDragged(e.getPoint());
            this.modelMarker.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point2D mousePoint2D = canvas.getGraphicsTransform().inverseTransform(e.getPoint());
        if (!this.modelMarker.isSameFocus(mousePoint2D)) {
            if (this.modelMarker.isFocusActive()) {
                canvas.setCursor(CURSOR_MOVE);
            } else {
                canvas.setCursor(this.cursorCanvas);
            }
        }
    }

    protected void setCursor() {
        this.cursorCanvas = new Cursor(1);
    }
}

