/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.mask;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.gunmetry.common.JDialogColorPicker;
import jp.sourceforge.sos.gunmetry.main.ViewFrameMain;
import jp.sourceforge.sos.gunmetry.marker.ModelMarker;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.GraphicsImage;
import jp.sourceforge.sos.lib.image.ImageInfo;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.connection.NeighborMasked;
import jp.sourceforge.sos.lib.morphology.connection.NeighborSimple;
import jp.sourceforge.sos.lib.util.SOSArrays;

public class ModelMask
implements IModel {
    private static final int[] COLOR_TRANSPARENT = new int[4];
    private ModelMarker modelMarker;
    private boolean[] analyzeMask;
    private SOSImageIO imageFileIO = new SOSImageIO();
    private ColorModel colorModel = new ColorModel();
    private JDialogColorPicker colorPicker = new JDialogColorPicker();
    private JObjectCanvas canvas;
    private GraphicsImage graphicsImage;
    private BufferedImage img;

    boolean createMask() {
        this.analyzeMask = null;
        this.imageFileIO.resetChoosableFileFilters();
        this.imageFileIO.setFileFilter(ViewFrameMain.filterGifPng);
        File fileMask = this.imageFileIO.getOpenFile("Select a GIF file for mask...");
        if (fileMask == null) {
            return false;
        }
        BufferedImage img = SOSImageIO.readImage(fileMask);
        ImageInfo imiMask = new ImageInfo(img);
        this.colorPicker.setColorTable(imiMask.getPixels(), imiMask.getPixelsLabel());
        this.analyzeMask = SOSArrays.toBoolean(this.colorPicker.getFlag(), imiMask.getPixelsLabel());
        if (this.analyzeMask == null) {
            return false;
        }
        this.createMaskImage();
        return true;
    }

    void createMaskImage() {
        int[][] result = new int[this.analyzeMask.length][];
        int[] rgb = this.colorModel.getColorArray();
        int[] colorMask = new int[4];
        System.arraycopy(rgb, 0, colorMask, 0, 3);
        colorMask[3] = 255;
        int i = 0;
        while (i < this.analyzeMask.length) {
            result[i] = this.analyzeMask[i] ? colorMask : COLOR_TRANSPARENT;
            ++i;
        }
        this.img = ImagePixelMediator.toAlphaImage(result, this.modelMarker.getImageWidth(), this.modelMarker.getImageHeight());
        this.graphicsImage.setImage(this.img);
    }

    void setMask(boolean setMask) {
        ImageInfo imageInfo = this.modelMarker.getImageInfo();
        Neighbor neighbor = null;
        if (setMask) {
            if (this.analyzeMask == null) {
                this.createMask();
            }
            this.graphicsImage.setImage(this.img);
            neighbor = new NeighborMasked(imageInfo.getWidth(), imageInfo.getHeight());
            neighbor.setMask(this.analyzeMask);
        } else {
            this.graphicsImage.setImage(null);
            neighbor = new NeighborSimple(imageInfo.getWidth(), imageInfo.getHeight());
        }
        imageInfo.setNeighbor(neighbor);
        this.repaint();
    }

    void repaint() {
        this.canvas.repaint();
    }

    ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setAbstraction(IAbstraction abstraction) {
        this.modelMarker = (ModelMarker)abstraction;
        this.canvas = this.modelMarker.getCanvas();
        this.graphicsImage = new GraphicsImage();
        this.canvas.addGraphicObject(2, this.graphicsImage);
    }

    IGraphicsContainer getCanvas() {
        return this.canvas;
    }

    Color getColor() {
        return this.colorModel.getColor();
    }

    void setColor(Color color) {
        this.colorModel.setColor(color);
    }
}

