/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.gunmetry.mask;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.gunmetry.common.Mediator;
import jp.sourceforge.sos.gunmetry.mask.ModelMask;
import jp.sourceforge.sos.lib.color.JCanvasColor;
import jp.sourceforge.sos.lib.design.observer.IObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewPanel
extends JPanel
implements IPresentation,
IObserver<Image> {
    private JCheckBox jCheckBox = null;
    private JCanvasColor jCanvasColor = null;
    protected ModelMask modelMask;
    private JButton jButton = null;

    public ViewPanel() {
        this.initialize();
        Mediator.add(Mediator.Subjects.LOAD, this);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, "Mask", 0, 0, null, null));
        this.add((Component)this.getJCheckBox(), gridBagConstraints);
        this.add((Component)this.getJCanvasColor(), gridBagConstraints1);
        this.add((Component)this.getJButton(), gridBagConstraints2);
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setText("use");
            this.jCheckBox.setEnabled(false);
            this.jCheckBox.setPreferredSize(new Dimension(75, 24));
            this.jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewPanel.this.modelMask.setMask(ViewPanel.this.jCheckBox.isSelected());
                }
            });
            this.jCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ViewPanel.this.jCanvasColor.setEnabled(ViewPanel.this.jCheckBox.isSelected());
                }
            });
        }
        return this.jCheckBox;
    }

    private JCanvasColor getJCanvasColor() {
        if (this.jCanvasColor == null) {
            this.jCanvasColor = new JCanvasColor();
            this.jCanvasColor.setEnabled(false);
            this.jCanvasColor.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    ViewPanel.this.modelMask.createMaskImage();
                    ViewPanel.this.modelMask.repaint();
                }
            });
        }
        return this.jCanvasColor;
    }

    @Override
    public void setAbstraction(IAbstraction abstraction) {
        this.modelMask = (ModelMask)abstraction;
        this.jCanvasColor.setModel(this.modelMask.getColorModel());
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Load");
            this.jButton.setEnabled(false);
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean value = ViewPanel.this.modelMask.createMask();
                    ViewPanel.this.modelMask.setMask(value);
                    ViewPanel.this.jCheckBox.setEnabled(value);
                    ViewPanel.this.jCheckBox.setSelected(value);
                }
            });
        }
        return this.jButton;
    }

    @Override
    public void update(Image obj) {
        boolean b = obj != null;
        this.jButton.setEnabled(b);
        if (!b) {
            this.jCheckBox.setEnabled(b);
        }
    }
}

