/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GraphicsTransform {
    private AffineTransform affineTransform = new AffineTransform();
    private AffineTransform inverseTransform = null;
    private double magnification;
    private transient Dimension sourceSize;
    private transient Dimension destinationSize;
    private transient Point2D.Double pointAtImage;
    private transient Point2D.Double pointAtScreen;
    private transient Point2D.Double canvasCenter;
    private transient Point2D.Double screenOffset;
    private transient AffineTransform screenMx;

    public GraphicsTransform() {
        this.initTransient();
    }

    public GraphicsTransform(int width, int height) {
        this.initTransient();
        this.setDestSize(width, height);
        if (this.sourceSize != null) {
            this.setFullSrc();
        }
    }

    public void initTransient() {
        this.destinationSize = new Dimension();
        this.pointAtImage = new Point2D.Double();
        this.pointAtScreen = new Point2D.Double();
        this.canvasCenter = new Point2D.Double();
        this.screenOffset = new Point2D.Double();
        this.screenMx = new AffineTransform();
    }

    public void setDestSize(int width, int height) {
        this.destinationSize.setSize(width, height);
        this.canvasCenter.x = (double)width / 2.0;
        this.canvasCenter.y = (double)height / 2.0;
    }

    public Dimension getDestSize() {
        return this.destinationSize;
    }

    public void scale(double newRatio) {
        this.scale(newRatio, this.canvasCenter.x, this.canvasCenter.y);
    }

    public void scale(double rate, double screenX, double screenY) {
        this.magnification *= rate;
        this.transformScreenToImage(screenX, screenY);
        this.affineTransform.translate(this.pointAtImage.x, this.pointAtImage.y);
        this.affineTransform.scale(rate, rate);
        this.affineTransform.translate(-this.pointAtImage.x, -this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public void locateCenter() {
        this.magnification = 1.0;
        double dx = this.canvasCenter.x - (double)this.sourceSize.width / 2.0;
        double dy = this.canvasCenter.y - (double)this.sourceSize.height / 2.0;
        this.affineTransform.setToTranslation(dx, dy);
        this.screenOffset.setLocation(this.canvasCenter.x, this.canvasCenter.y);
        this.inverseTransform = null;
    }

    public void setFullSrc() {
        this.locateCenter();
        double rw = 1.0 * this.destinationSize.getWidth() / (double)this.sourceSize.width;
        double rh = 1.0 * this.destinationSize.getHeight() / (double)this.sourceSize.height;
        this.scale(Math.min(rw, rh));
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double value) {
        this.magnification = value;
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.affineTransform.setToTranslation(this.canvasCenter.x - this.pointAtImage.x, this.canvasCenter.y - this.pointAtImage.y);
        this.screenOffset.setLocation(this.pointAtImage.x, this.pointAtImage.y);
        this.scale(value);
    }

    public void translateScreen(double dx, double dy) {
        this.screenMx.setToTranslation(dx, dy);
        this.affineTransform.preConcatenate(this.screenMx);
        this.screenOffset.x += dx;
        this.screenOffset.y += dy;
        this.inverseTransform = null;
    }

    private void transformScreenToImage(double screenX, double screenY) {
        this.pointAtScreen.x = screenX;
        this.pointAtScreen.y = screenY;
        try {
            this.affineTransform.inverseTransform(this.pointAtScreen, this.pointAtImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Point2D inverseTransform(Point source) {
        try {
            this.affineTransform.inverseTransform(source, this.pointAtImage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.pointAtImage;
    }

    public Shape inverseTransform(Shape src) {
        if (this.inverseTransform == null) {
            try {
                this.inverseTransform = this.affineTransform.createInverse();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.inverseTransform.createTransformedShape(src);
    }

    public void rotateImage(double theta) {
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.affineTransform.rotate(theta, this.pointAtImage.x, this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public void deformImage(double theta, double scaleRatio) {
        this.transformScreenToImage(this.canvasCenter.x, this.canvasCenter.y);
        this.affineTransform.translate(this.pointAtImage.x, this.pointAtImage.y);
        this.affineTransform.scale(scaleRatio, scaleRatio);
        this.affineTransform.rotate(theta);
        this.affineTransform.translate(-this.pointAtImage.x, -this.pointAtImage.y);
        this.inverseTransform = null;
    }

    public Point2D.Double getScreenOffset() {
        return this.screenOffset;
    }

    public Rectangle2D.Double getVisibleBounds() {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        this.transformScreenToImage(0.0, 0.0);
        rect.x = this.pointAtImage.x;
        rect.y = this.pointAtImage.y;
        rect.width = this.destinationSize.getWidth() / this.magnification;
        rect.height = this.destinationSize.getHeight() / this.magnification;
        return rect;
    }

    public Rectangle getVisibleBounds(int scale) {
        Rectangle rect = new Rectangle();
        this.transformScreenToImage(0.0, 0.0);
        rect.x = (int)((double)scale * this.pointAtImage.x);
        rect.y = (int)((double)scale * this.pointAtImage.y);
        rect.width = (int)((double)scale * this.destinationSize.getWidth() / this.magnification);
        rect.height = (int)((double)scale * this.destinationSize.getHeight() / this.magnification);
        return rect;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.affineTransform = affineTransform;
    }

    public void calcMagnification() {
        this.magnification = this.affineTransform.getScaleX();
    }

    public void setSourceSize(Dimension size) {
        this.sourceSize = size;
    }

    public void setSourceSize(int width, int height) {
        if (this.sourceSize == null) {
            this.sourceSize = new Dimension(width, height);
            return;
        }
        this.sourceSize.setSize(width, height);
    }

    public int getSourceWidth() {
        if (this.sourceSize == null) {
            return 0;
        }
        return this.sourceSize.width;
    }

    public int getSourceHeight() {
        if (this.sourceSize == null) {
            return 0;
        }
        return this.sourceSize.height;
    }
}

