/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;
import jp.sourceforge.sos.lib.graphics.GraphicsArray;
import jp.sourceforge.sos.lib.graphics.IGraphics;

public class JObjectCanvas
extends JPanel
implements IGraphicsContainer {
    GraphicsArray graphicObjects = new GraphicsArray();

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.graphicObjects.draw(g);
        g.dispose();
    }

    public int getObjectsSize() {
        return this.graphicObjects.size();
    }

    public IGraphics getGraphicObject(int index) {
        return (IGraphics)this.graphicObjects.get(index);
    }

    public void addGraphicObject(IGraphics graphicComponent) {
        this.graphicObjects.add(graphicComponent);
    }

    public void addGraphicObject(int index, IGraphics graphicComponent) {
        this.graphicObjects.add(index, graphicComponent);
    }

    public void removeGraphicObject(IGraphics graphicComponent) {
        this.graphicObjects.remove(graphicComponent);
    }

    public void removeGraphicObject(int index) {
        this.graphicObjects.remove(index);
    }

    public void clearGraphicObject() {
        this.graphicObjects.clear();
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.setPreferredSize(new Dimension(x, y));
    }

    public void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JObjectCanvas.this.repaint();
            }
        });
    }

    public BufferedImage getScreenImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.graphicObjects.draw(img.getGraphics());
        return img;
    }
}

