/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import jp.sourceforge.sos.lib.canvas.GraphicsTransform;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.PointerManager;
import jp.sourceforge.sos.lib.canvas.SizeManager;
import jp.sourceforge.sos.lib.graphics.GraphicsAffineTransform;

public class JTransformCanvas
extends JObjectCanvas
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected SizeManager sizeManager = new SizeManager();
    private PointerManager pointerManager = new PointerManager();
    protected GraphicsTransform graphicsTransform;

    public JTransformCanvas() {
        this(new GraphicsTransform());
    }

    public JTransformCanvas(GraphicsTransform graphicsTransform) {
        this.graphicsTransform = graphicsTransform;
        this.addGraphicObject(new GraphicsAffineTransform(graphicsTransform.getAffineTransform()));
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.sizeManager.resized(width, height);
        if (this.graphicsTransform != null) {
            this.graphicsTransform.setDestSize(width, height);
            this.graphicsTransform.translateScreen(this.sizeManager.deltaWidth, this.sizeManager.deltaHeight);
        }
    }

    public void setSourceSize(Dimension dim) {
        this.graphicsTransform.setDestSize(this.getWidth(), this.getHeight());
        this.graphicsTransform.setSourceSize(dim);
    }

    public void setSourceSize(int width, int height) {
        this.graphicsTransform.setSourceSize(width, height);
    }

    public void setGraphicsTransform(GraphicsTransform graphicsTransform) {
        this.graphicsTransform = graphicsTransform;
    }

    public GraphicsTransform getGraphicsTransform() {
        return this.graphicsTransform;
    }

    public void mouseClicked(MouseEvent evt) {
        int modifier = evt.getModifiers();
        double rate = 2.0;
        if ((modifier & 8) != 0 || (modifier & 4) != 0) {
            rate = 0.5;
        }
        this.graphicsTransform.scale(rate, evt.getX(), evt.getY());
    }

    public void mouseDragged(MouseEvent evt) {
        this.pointerManager.move(evt.getX(), evt.getY());
        this.graphicsTransform.translateScreen(this.pointerManager.deltaX, this.pointerManager.deltaY);
    }

    public void mousePressed(MouseEvent evt) {
        this.pointerManager.move(evt.getX(), evt.getY());
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        double ratio = 1.0 + (double)evt.getWheelRotation() * 0.05;
        this.graphicsTransform.scale(ratio);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public int getSourceHeight() {
        return this.graphicsTransform.getSourceHeight();
    }

    public int getSourceWidth() {
        return this.graphicsTransform.getSourceWidth();
    }
}

