/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.design.observer.IObserver;

public class JCanvasColor
extends JPanel
implements IObserver {
    private static final Color unenabledColor = new Color(156, 154, 156);
    private ColorModel colorModel;
    private boolean colorChoosable;
    private String label;

    public JCanvasColor() {
        this(new ColorModel());
    }

    public JCanvasColor(ColorModel model) {
        this.setPreferredSize(new Dimension(100, 15));
        this.colorChoosable = true;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JCanvasColor.this.showJColorChooser();
            }
        });
        this.setModel(model);
    }

    public void setModel(ColorModel model) {
        this.colorModel = model;
        this.colorModel.addObserver(this);
    }

    public ColorModel getModel() {
        return this.colorModel;
    }

    private void showJColorChooser() {
        if (this.isEnabled() && this.colorChoosable) {
            Color newColor = JColorChooser.showDialog(this, "Choose color...", this.colorModel.getColor());
            this.colorModel.setColor(newColor);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(unenabledColor);
        }
        g.drawString(this.colorModel.getColorString(), 20, 11);
        g.drawLine(0, 0, 14, 0);
        g.drawLine(0, 0, 0, 14);
        g.setColor(this.colorModel.getColor());
        g.fillRect(1, 1, 14, 14);
        g.dispose();
    }

    public void setColorChoosable(boolean colorChoosable) {
        this.colorChoosable = colorChoosable;
    }

    public void update(Object arg) {
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public void setModel() {
        this.colorModel = new ColorModel();
    }

    public Color getColor() {
        return this.colorModel.getColor();
    }

    public void setColor(Color color) {
        this.colorModel.setColor(color);
    }
}

