/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.color.JCanvasColor;
import jp.sourceforge.sos.lib.design.observer.IObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JColorPanel
extends JPanel
implements IObserver<ColorModel> {
    private ArrayList<JCanvasColor> listCanvas = new ArrayList();
    private ColorPanelModel model;
    private boolean isChoosable = false;
    private String labelBase;
    private String strName;

    public JColorPanel() {
        this.initComponents();
    }

    public void setStrName(String arg) {
        this.strName = arg;
    }

    @Override
    public String toString() {
        return this.strName;
    }

    public ColorPanelModel getModel() {
        return this.model;
    }

    public void init(boolean choosable, String arg) {
        this.isChoosable = choosable;
        this.labelBase = arg;
    }

    public void setModel(ColorPanelModel aModel) {
        this.model = aModel;
        this.model.addObserver(this);
        this.synchronizeCanvasToModel();
    }

    private void synchronizeCanvasToModel() {
        int n = this.model.getColorNumber();
        int oldN = this.listCanvas.size();
        if (oldN == n) {
            return;
        }
        if (oldN < n) {
            this.addCanvases(oldN, n);
        } else {
            this.removeCanvases(oldN - n);
        }
        this.pack();
    }

    private void removeCanvases(int diff) {
        int i = 0;
        while (i < diff) {
            this.removeCanvas(this.listCanvas.size() - 1);
            ++i;
        }
    }

    private void addCanvases(int start, int end) {
        int i = start;
        while (i < end) {
            this.addCanvas(this.model.get(i));
            ++i;
        }
    }

    public int getColorNumber() {
        return this.listCanvas.size();
    }

    public void addCanvas() {
        JCanvasColor canvasColor = this.createCanvasAndLabel();
        canvasColor.setModel(this.model.add());
    }

    protected void addCanvas(ColorModel colorModel) {
        JCanvasColor canvasColor = this.createCanvasAndLabel();
        canvasColor.setModel(colorModel);
    }

    private JCanvasColor createCanvasAndLabel() {
        JCanvasColor canvasColor = this.createCanvas();
        this.add((Component)canvasColor, this.getCanvasConstraints());
        JLabel label = new JLabel(String.valueOf(canvasColor.getLabel()) + ": ");
        label.setForeground(new Color(102, 102, 102));
        this.add((Component)label, this.getLabelConstraints());
        return canvasColor;
    }

    private JCanvasColor createCanvas() {
        JCanvasColor canvas = new JCanvasColor();
        canvas.setColorChoosable(this.isChoosable);
        String label = String.valueOf(this.labelBase) + new Integer(this.listCanvas.size() + 1).toString();
        canvas.setLabel(label);
        this.listCanvas.add(canvas);
        return canvas;
    }

    private GridBagConstraints getCanvasConstraints() {
        GridBagConstraints canvasConst = new GridBagConstraints();
        canvasConst.gridx = 1;
        canvasConst.gridy = -1;
        return canvasConst;
    }

    private GridBagConstraints getLabelConstraints() {
        GridBagConstraints labelConst = new GridBagConstraints();
        labelConst.gridx = 0;
        labelConst.gridy = -1;
        labelConst.anchor = 13;
        labelConst.insets = new Insets(0, 0, 3, 5);
        return labelConst;
    }

    public void removeCanvas(int index) {
        this.remove(index * 2);
        this.remove(index * 2);
        this.listCanvas.remove(index);
    }

    public int[] getColorInt() {
        int[] result = new int[this.model.getColorNumber()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.model.getColorInt(i);
            ++i;
        }
        return result;
    }

    public void setColorInt(int[] data) {
        if (this.model != null) {
            this.model.setColorNumber(data.length);
            int i = 0;
            while (i < data.length) {
                this.model.updateColor(i, new Color(data[i]));
                ++i;
            }
        }
    }

    public String getColorString(String separator) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.model.getColorString(0));
        int i = 1;
        while (i < this.listCanvas.size()) {
            builder.append(this.model.getColorString(i));
            ++i;
        }
        return builder.toString();
    }

    private void pack() {
        Window window = SwingUtilities.getWindowAncestor(this);
        window.pack();
    }

    @Override
    public void update(ColorModel arg) {
        if (arg == null) {
            this.removeCanvas(this.listCanvas.size() - 1);
        } else {
            this.addCanvas(arg);
        }
        this.pack();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }
}

