/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;
import jp.sourceforge.sos.lib.graphics.GraphicsArray;
import jp.sourceforge.sos.lib.graphics.IGraphics;

public class GraphicsOffscreen
implements IGraphics,
IGraphicsContainer {
    private BufferedImage imgOffscreen;
    private GraphicsArray graphicObjects = new GraphicsArray();

    public void draw(Graphics g) {
        g.drawImage(this.imgOffscreen, 0, 0, null);
    }

    public void create(int width, int height) {
        this.imgOffscreen = new BufferedImage(width, height, 2);
    }

    public void update() {
        if (this.imgOffscreen != null) {
            Graphics g = this.imgOffscreen.getGraphics();
            int i = 0;
            while (i < this.graphicObjects.size()) {
                ((IGraphics)this.graphicObjects.get(i)).draw(g);
                ++i;
            }
        }
    }

    public void addGraphicObject(IGraphics obj) {
        this.graphicObjects.add(obj);
        this.update();
    }

    public void addGraphicObject(int i, IGraphics obj) {
        this.graphicObjects.add(i, obj);
        this.update();
    }

    public int getObjectsSize() {
        return this.graphicObjects.size();
    }

    public IGraphics getGraphicObject(int index) {
        return (IGraphics)this.graphicObjects.get(index);
    }

    public void removeGraphicObject(IGraphics graphicComponent) {
        this.graphicObjects.remove(graphicComponent);
    }

    public void removeGraphicObject(int index) {
        this.graphicObjects.remove(index);
    }

    public void clearGraphicObject() {
        this.graphicObjects.clear();
    }
}

