/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.io;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.io.ExtensionFilter;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SOSImageIO
extends SOSFileIO {
    public static final int TYPE_JPEG;
    public static final int TYPE_PNG;
    public static final int TYPE_GIF;
    public static final int TYPE_TIFF;
    public static final int TYPE_BMP;
    public static final int TYPE_JPEG2000;
    private static final String[] mimeReader;
    private static final String[] mimeWriter;
    private static ExtensionFilter[] imageFilters;
    private static boolean[] writableFilters;
    private static ImageReader currentImageReader;
    private int fileType;

    static {
        mimeReader = ImageIO.getReaderMIMETypes();
        imageFilters = new ExtensionFilter[mimeReader.length - 1];
        int i = 0;
        while (i < mimeReader.length - 1) {
            String ext = Extension.getFromMIME(mimeReader[i]);
            if (ext != null) {
                SOSImageIO.imageFilters[i] = new ExtensionFilter(new String[]{ext}, String.valueOf(ext) + " file");
                imageFilters[i].setIndex(i);
            }
            ++i;
        }
        mimeWriter = ImageIO.getWriterMIMETypes();
        writableFilters = new boolean[imageFilters.length];
        i = 0;
        while (i < mimeWriter.length - 1) {
            int type = SOSImageIO.getReadableMIMEIndex(mimeWriter[i]);
            SOSImageIO.writableFilters[type] = true;
            ++i;
        }
        TYPE_JPEG = SOSImageIO.getReadableMIMEIndex("image/jpeg");
        TYPE_PNG = SOSImageIO.getReadableMIMEIndex("image/png");
        TYPE_GIF = SOSImageIO.getReadableMIMEIndex("image/gif");
        TYPE_TIFF = SOSImageIO.getReadableMIMEIndex("image/tif");
        TYPE_BMP = SOSImageIO.getReadableMIMEIndex("image/bmp");
        TYPE_JPEG2000 = SOSImageIO.getReadableMIMEIndex("image/jpeg2000");
    }

    private static int getReadableMIMEIndex(String mime) {
        int indexMIME = -1;
        int i = 0;
        while (i < mimeReader.length) {
            if (mimeReader[i].equals(mime)) {
                indexMIME = i;
                break;
            }
            ++i;
        }
        return indexMIME;
    }

    private static void setCurrentImageReader(File file) {
        String suffix = Extension.getFromFileName(file.getName());
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
        while (readers.hasNext()) {
            currentImageReader = readers.next();
            try {
                ImageInputStream stream = ImageIO.createImageInputStream(file);
                currentImageReader.setInput(stream);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ImageReadParam getImageReadParam(File file) {
        SOSImageIO.setCurrentImageReader(file);
        ImageReadParam result = null;
        try {
            result = currentImageReader.getDefaultReadParam();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IIOMetadata getMetadata(File file) {
        String suffix = Extension.getFromFileName(file.getName());
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(suffix);
        IIOMetadata result = null;
        while (readers.hasNext()) {
            currentImageReader = readers.next();
            try {
                ImageInputStream stream = ImageIO.createImageInputStream(file);
                currentImageReader.setInput(stream);
                result = currentImageReader.getImageMetadata(0);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
            }
            finally {
                SOSImageIO.disposeCurrentImageReader();
            }
        }
        return result;
    }

    public static IIOMetadata getDefaultMetadata(String suffix, BufferedImage img) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(suffix);
        IIOMetadata result = null;
        while (writers.hasNext()) {
            ImageWriter imageWriter = writers.next();
            result = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(img), null);
            if (result != null) break;
            imageWriter.dispose();
        }
        return result;
    }

    public static void disposeCurrentImageReader() {
        if (currentImageReader != null) {
            currentImageReader.dispose();
        }
    }

    public static Dimension getImageSize(File file) {
        SOSImageIO.setCurrentImageReader(file);
        Dimension result = null;
        try {
            try {
                result = new Dimension(currentImageReader.getWidth(0), currentImageReader.getHeight(0));
            }
            catch (Exception exception) {}
        }
        finally {
            SOSImageIO.disposeCurrentImageReader();
        }
        return result;
    }

    public static final String getFormatName(File file) {
        SOSImageIO.setCurrentImageReader(file);
        String result = null;
        try {
            try {
                result = currentImageReader.getFormatName();
            }
            catch (Exception exception) {}
        }
        finally {
            SOSImageIO.disposeCurrentImageReader();
        }
        return result;
    }

    public static final Image getSubsampledImage(File file, int subsamplingX, int subsamplingY) {
        ImageReadParam param = SOSImageIO.getImageReadParam(file);
        if (param != null) {
            param.setSourceSubsampling(subsamplingX, subsamplingY, 0, 0);
            return SOSImageIO.readCurrentImage(param);
        }
        return null;
    }

    public static final Image getPartialImage(File file, Rectangle sourceRect) {
        ImageReadParam param = SOSImageIO.getImageReadParam(file);
        if (param != null) {
            if (sourceRect.x < 0 || sourceRect.y < 0) {
                Point offset = new Point();
                if (sourceRect.x < 0) {
                    offset.x = -sourceRect.x;
                    sourceRect.x = 0;
                }
                if (sourceRect.y < 0) {
                    offset.y = -sourceRect.y;
                    sourceRect.y = 0;
                }
                param.setDestinationOffset(offset);
            }
            param.setSourceRegion(sourceRect);
            return SOSImageIO.readCurrentImage(param);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage readCurrentImage(ImageReadParam param) {
        try {
            BufferedImage bufferedImage = currentImageReader.read(0, param);
            return bufferedImage;
        }
        catch (Exception exception) {
        }
        finally {
            SOSImageIO.disposeCurrentImageReader();
        }
        SOSImageIO.disposeCurrentImageReader();
        return null;
    }

    public BufferedImage readImage() {
        File file = this.getOpenFile("Open image...");
        if (file != null) {
            return SOSImageIO.readImage(file);
        }
        return null;
    }

    public static BufferedImage readImage(File file) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public static String getMIME(int type) {
        return mimeReader[type];
    }

    public void setAllReadableFilters() {
        this.resetChoosableFileFilters();
        int i = 0;
        while (i < imageFilters.length) {
            this.setFileFilter(imageFilters[i]);
            ++i;
        }
    }

    public void setAllWritableFilters() {
        this.resetChoosableFileFilters();
        int i = 0;
        while (i < imageFilters.length) {
            if (writableFilters[i]) {
                this.setFileFilter(imageFilters[i]);
            }
            ++i;
        }
    }

    public void writeImage(BufferedImage img) {
        File file = this.getSaveFile();
        SOSImageIO.writeImage(file, this.fileType, img);
    }

    public void writeImage(int type, BufferedImage img) {
        if (type >= 0) {
            this.resetChoosableFileFilters();
            this.setFileFilter(imageFilters[type]);
            File file = this.getSaveFile();
            SOSImageIO.writeImage(file, type, img);
        }
    }

    public static void writeImage(File file, int type, RenderedImage img) {
        if (mimeReader.length <= type) {
            return;
        }
        if (file == null) {
            return;
        }
        String suffix = Extension.getFromMIME(mimeReader[type]);
        String modifiedPath = Extension.replace(file.getPath(), suffix);
        file = new File(modifiedPath);
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeReader[type]);
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            try {
                ImageOutputStream stream = ImageIO.createImageOutputStream(file);
                writer.setOutput(stream);
                writer.write(img);
                writer.dispose();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeImage(File file, RenderedImage img, IIOMetadata metadata) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(Extension.getFromFileName(file.getName()));
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            try {
                ImageOutputStream stream = ImageIO.createImageOutputStream(file);
                writer.setOutput(stream);
                writer.write(new IIOImage(img, null, metadata));
                writer.dispose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            writer.dispose();
        }
    }

    public int getFileType() {
        return this.fileType;
    }

    public File getSaveFile() {
        this.setAllWritableFilters();
        File file = super.getSaveFile();
        this.fileType = ((ExtensionFilter)this.chooser.getFileFilter()).getIndex();
        this.resetChoosableFileFilters();
        return file;
    }

    public File getSaveDirectory() {
        this.setAllWritableFilters();
        File file = super.getSaveDirectory();
        this.fileType = ((ExtensionFilter)this.chooser.getFileFilter()).getIndex();
        this.resetChoosableFileFilters();
        return file;
    }

    private static IIOMetadataNode getNode(IIOMetadataNode node, String nodeName) {
        IIOMetadataNode child = (IIOMetadataNode)node.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals(nodeName)) break;
            child = (IIOMetadataNode)child.getNextSibling();
        }
        return child;
    }

    public static IIOMetadataNode getNode(IIOMetadataNode node, String path, String[] attributes) {
        String[] name = path.split("/");
        int depth = name.length;
        IIOMetadataNode current = node;
        int i = 0;
        while (i < depth - 1) {
            IIOMetadataNode child = SOSImageIO.getNode(current, name[i]);
            if (child == null) {
                return null;
            }
            current = child;
            ++i;
        }
        boolean useAttributes = false;
        String[][] attr = null;
        if (attributes != null) {
            attr = SOSImageIO.splitAttributes(attributes);
            if (attributes.length > 0) {
                useAttributes = true;
            }
        }
        IIOMetadataNode child = (IIOMetadataNode)current.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals(name[depth - 1])) {
                if (useAttributes) {
                    if (child.hasAttributes()) {
                        NamedNodeMap map = child.getAttributes();
                        int length = map.getLength();
                        boolean matched = true;
                        int i2 = 0;
                        while (i2 < length) {
                            Node currentAttr = map.item(i2);
                            if (!currentAttr.getNodeName().equals(attr[i2][0]) || !currentAttr.getNodeValue().equals(attr[i2][1])) {
                                matched = false;
                                break;
                            }
                            ++i2;
                        }
                        if (matched) {
                            return child;
                        }
                    }
                } else {
                    return child;
                }
            }
            child = (IIOMetadataNode)child.getNextSibling();
        }
        return null;
    }

    public static IIOMetadataNode addNode(IIOMetadataNode node, String path, String[] attributes) {
        String[] name = path.split("/");
        IIOMetadataNode current = node;
        int i = 0;
        while (i < name.length) {
            IIOMetadataNode child = SOSImageIO.getNode(current, name[i]);
            if (child == null) {
                child = new IIOMetadataNode(name[i]);
                current.appendChild(child);
            }
            current = child;
            ++i;
        }
        if (attributes != null) {
            String[][] attr = SOSImageIO.splitAttributes(attributes);
            int i2 = 0;
            while (i2 < attr.length) {
                current.setAttribute(attr[i2][0], attr[i2][1]);
                ++i2;
            }
        }
        return current;
    }

    private static String[][] splitAttributes(String[] attributes) {
        String[][] result = new String[attributes.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = attributes[i].split("/");
            ++i;
        }
        return result;
    }
}

