/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.connection;

import jp.sourceforge.sos.lib.morphology.connection.Connection;
import jp.sourceforge.sos.lib.morphology.connection.Eight;
import jp.sourceforge.sos.lib.morphology.connection.Four;

public abstract class Neighbor {
    protected static final Connection[] connection = new Connection[2];
    private int width = 0;
    private int height = 0;
    private int size;
    protected int[] neighborIndex;
    protected Connection current;

    static {
        Neighbor.connection[0] = new Eight();
        Neighbor.connection[1] = new Four();
    }

    public Neighbor(int w, int h) {
        this.setSize(w, h);
        this.set8();
    }

    public void setSize(int w, int h) {
        if (this.width == w && this.height == h) {
            return;
        }
        if (w == 0 || h == 0) {
            return;
        }
        this.width = w;
        this.height = h;
        this.size = this.width * this.height;
        this.setNeighbors();
        this.setConnection();
    }

    private void setConnection() {
        int i = 0;
        while (i < connection.length) {
            connection[i].setWidth(this.width);
            ++i;
        }
    }

    private void setNeighbors() {
        this.neighborIndex = new int[this.size];
        int i = 0;
        while (i < this.neighborIndex.length) {
            this.neighborIndex[i] = 4;
            ++i;
        }
        i = 1;
        while (i < this.width - 1) {
            this.neighborIndex[i] = 1;
            this.neighborIndex[this.size - 1 - i] = 7;
            ++i;
        }
        i = 1;
        while (i < this.height - 1) {
            this.neighborIndex[this.width * i] = 3;
            this.neighborIndex[this.width * (i + 1) - 1] = 5;
            ++i;
        }
        this.neighborIndex[0] = 0;
        this.neighborIndex[this.width - 1] = 2;
        this.neighborIndex[this.size - this.width] = 6;
        this.neighborIndex[this.size - 1] = 8;
    }

    public final int getNumber() {
        return this.current.getNumber();
    }

    public int[] getDir(int pn) {
        return this.current.getDirect(this.neighborIndex[pn]);
    }

    public int[] getExist(int pn) {
        return this.current.getExist(this.neighborIndex[pn]);
    }

    public void set8() {
        this.current = connection[0];
    }

    public void set4() {
        this.current = connection[1];
    }

    public abstract void setMask(boolean[] var1);

    public abstract boolean[] getMask();

    public int getHeight() {
        return this.height;
    }

    public int getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }
}

