/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.extra;

import jp.sourceforge.sos.lib.morphology.data.DataInt;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.Operation;

public class GeodesicDistance
extends Operation {
    public void operate(Elements elements) {
        this.init(elements);
        elements.setResult(new DataInt(elements.size()));
        boolean[] binaryMap = (boolean[])elements.getInputData();
        int[] resultMap = (int[])elements.getResultData();
        int pn = 0;
        while (pn < elements.size()) {
            if (binaryMap[pn]) {
                int[] se = this.neighbor.getExist(pn);
                int n = 0;
                while (n < se.length) {
                    if (!binaryMap[pn + se[n]]) {
                        resultMap[pn] = 1;
                        this.fifo.add(pn);
                        break;
                    }
                    ++n;
                }
            }
            ++pn;
        }
        while (!this.fifo.isEmpty()) {
            int cp = this.fifo.get();
            int[] se = this.neighbor.getExist(cp);
            int n = 0;
            while (n < se.length) {
                int cn = cp + se[n];
                if (resultMap[cn] == 0 && binaryMap[cn]) {
                    resultMap[cn] = resultMap[cp] + 1;
                    this.fifo.add(cn);
                }
                ++n;
            }
        }
    }
}

