/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.threedim;

import java.awt.Point;
import jp.sourceforge.sos.lib.threedim.Object3D;
import jp.sourceforge.sos.lib.threedim.Vertex;
import jp.sourceforge.sos.lib.util.Oval;

public class Curve3D
extends Object3D {
    public Curve3D(int resolution, int radius) {
        Oval oval = new Oval(resolution);
        oval.makeOval(0.0, 0.0, radius);
        this.convertOvalToCurve(oval);
    }

    public Curve3D(int resolution, int radiusX, int radiusY) {
        double[][] mx = new double[][]{{1.0, 0.0}, {0.0, 1.0 * (double)radiusY / (double)radiusX}};
        Oval oval = new Oval(resolution);
        oval.makeOval(0.0, 0.0, radiusX, mx);
        this.convertOvalToCurve(oval);
    }

    private void convertOvalToCurve(Oval oval) {
        int i = 0;
        while (i < oval.getResolution()) {
            Point p = oval.getPoint(i);
            Vertex v = new Vertex(p.x, p.y, 0.0);
            this.vertices.add(v);
            ++i;
        }
        super.update();
    }
}

