/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.window;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.window.JImageFrame;

public class JImageStackFrame
extends JImageFrame {
    private ArrayList<Image> imageArray = new ArrayList();
    private SOSImageIO imageIO = new SOSImageIO();
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    private JMenuItem jMenuSaveAll;
    private JMenuItem jMenuSaveCurrent;
    private JScrollBar jScrollBar;

    public JImageStackFrame() {
        this.initComponents();
        this.jScrollBar.setMaximum(1);
    }

    public int getImageNumber() {
        return this.imageArray.size();
    }

    public void addImage(Image img) {
        if (img != null) {
            this.imageArray.add(img);
            this.updateScrollBar();
        }
    }

    public void removeImage(int index) {
        if (index >= 0 && index < this.imageArray.size()) {
            this.imageArray.remove(index);
            this.updateScrollBar();
        }
    }

    public void clearImage() {
        this.imageArray.clear();
    }

    private void updateScrollBar() {
        if (this.imageArray.size() > 0) {
            this.jScrollBar.setMaximum(this.imageArray.size());
        }
    }

    private void initComponents() {
        this.jScrollBar = new JScrollBar();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuSaveCurrent = new JMenuItem();
        this.jMenuSaveAll = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Image stack");
        this.jScrollBar.setOrientation(0);
        this.jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                JImageStackFrame.this.jScrollBarAdjustmentValueChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.jScrollBar, "South");
        this.jMenuFile.setText("File");
        this.jMenuSaveCurrent.setText("save current image");
        this.jMenuSaveCurrent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JImageStackFrame.this.jMenuSaveCurrentActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveCurrent);
        this.jMenuSaveAll.setText("save all images");
        this.jMenuSaveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JImageStackFrame.this.jMenuSaveAllActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveAll);
        this.jMenuBarMain.add(this.jMenuFile);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    private void jMenuSaveAllActionPerformed(ActionEvent evt) {
        File parent = this.imageIO.getSaveDirectory();
        int type = this.imageIO.getFileType();
        int i = 0;
        while (i < this.imageArray.size()) {
            BufferedImage img;
            try {
                img = (BufferedImage)this.imageArray.get(i);
            }
            catch (ClassCastException e) {
                Image tempImage = this.imageArray.get(i);
                img = new BufferedImage(tempImage.getWidth(null), tempImage.getHeight(null), 2);
                Graphics g = img.getGraphics();
                g.drawImage(tempImage, 0, 0, null);
            }
            File file = new File(String.valueOf(parent.getPath()) + File.separator + i);
            SOSImageIO.writeImage(file, type, img);
            ++i;
        }
    }

    private void jMenuSaveCurrentActionPerformed(ActionEvent evt) {
        BufferedImage img = (BufferedImage)this.imageArray.get(this.jScrollBar.getValue());
        this.imageIO.writeImage(img);
    }

    private void jScrollBarAdjustmentValueChanged(AdjustmentEvent evt) {
        if (this.imageArray.size() > 0) {
            Image img = this.imageArray.get(this.jScrollBar.getValue());
            this.setImage(img);
        }
    }
}

