/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework;

import java.util.HashMap;
import javax.swing.JFrame;
import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IAdapterPanel;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.framework.IPresentation;
import jp.sourceforge.sos.framework.ViewTopFrame;

public abstract class AbstractPACControl {
    protected static HashMap<String, IPresentation> presentations = new HashMap();
    protected static HashMap<String, IAbstraction> models = new HashMap();
    protected IAbstraction model;
    protected AbstractPACControl parent;
    protected static IAdapterPanel adapterPanel;

    public AbstractPACControl(AbstractPACControl parent) {
        this.parent = parent;
        this.setModel();
        this.setPresentations();
    }

    protected void setModel() {
        String controlName = this.getClass().getName();
        String modelName = controlName.replaceFirst("Control", "Model");
        try {
            Class<?> modelClass = Class.forName(modelName);
            this.model = (IAbstraction)modelClass.newInstance();
            models.put(modelName, this.model);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.addModelComposition();
    }

    protected abstract void setPresentations();

    public abstract void init();

    protected Object getPresentation(String name) {
        return this.get(presentations, name);
    }

    protected IAbstraction getAbstraction(String name) {
        return (IAbstraction)this.get(models, name);
    }

    private Object get(HashMap map, String name) throws NoClassDefFoundError {
        Object view = map.get(name);
        if (view != null) {
            return view;
        }
        throw new NoClassDefFoundError();
    }

    protected IAbstraction getParentModel() {
        return this.parent.model;
    }

    protected void addModelComposition() {
        if (this.model instanceof IModel) {
            ((IPresentation)((Object)this.model)).setAbstraction(this.getParentModel());
        }
    }

    protected void setView(IPresentation presentation) {
        String name = presentation.getClass().getName();
        presentations.put(name, presentation);
        presentation.setAbstraction(this.model);
    }

    protected JFrame getMainFrame() {
        return ViewTopFrame.getInstance();
    }
}

