
/*
 * NuclearSize.java
 *
 * Created on 2005/03/07, 1:25
 */

import java.util.ArrayList;

import jp.sourceforge.sos.gunmetry.common.AnalysisPlugin;
import jp.sourceforge.sos.gunmetry.main.Region;



/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/03/07)
 */
public class NearestSizeDifference implements AnalysisPlugin{
	
	private ArrayList<Double> result = null;

	public ArrayList<Double> analyze(Region[] nuclei, Region[] skiz) {
		if (result==null){
			result = new ArrayList<Double>();
			double value = 0.0;
			for (int i=0; i<nuclei.length; i++){
				value = nuclei[i].getSize();
				value -= nuclei[i].getNearestNeighbor().getSize();
				result.add(Math.abs(value));
			}
		}
		return result;
	}
	
}
