package jp.sourceforge.sos.gunmetry;

import jp.sourceforge.sos.gunmetry.graphics.ControlGraphics;
import jp.sourceforge.sos.gunmetry.image.ControlImage;
import jp.sourceforge.sos.gunmetry.main.ControlMain;
import jp.sourceforge.sos.gunmetry.marker.ControlMarker;
import jp.sourceforge.sos.gunmetry.mask.ControlMask;

public class Builder {

	public Builder() {
		ControlMain control = new ControlMain();
		
		ControlMarker controlMarker = new ControlMarker(control);
		new ControlImage(controlMarker);
		new ControlMask(controlMarker);
		
		new ControlGraphics(control);
			
		control.init();
	}

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new Builder();
			}
		});
	}

}
