package jp.sourceforge.sos.gunmetry.common;

import java.awt.Color;
import java.util.prefs.Preferences;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.lib.design.observer.IObserver;

public abstract class AbstractPref implements IObserver<Boolean> {

	static protected Preferences	prefs	= Preferences.systemNodeForPackage(AbstractPref.class);

	public AbstractPref(IAbstraction model) {
		super();
		Mediator.add(Mediator.Subjects.SAVE_COLORS, this);
		setModel(model);
		init();
	}

	protected abstract void setModel(IAbstraction model);
	
	protected abstract void init();

	protected Color getColor(String keyName, Color defaultColor) {
		int value = prefs.getInt(keyName, defaultColor.getRGB());
		return new Color(value);
	}
}
