package jp.sourceforge.sos.gunmetry.common;

import java.util.EnumMap;

import jp.sourceforge.sos.lib.design.observer.ConcreteSubject;
import jp.sourceforge.sos.lib.design.observer.IObserver;


public class Mediator {

	public enum Subjects{
		LOAD,
		READY_TO_ANALYSIS,
		POST_ANALYSIS,
		SAVE_COLORS
	}
	
	private static EnumMap<Subjects,ConcreteSubject> setSubjects;
	
	static{
		setSubjects = new EnumMap<Subjects,ConcreteSubject>(Subjects.class);
		for (Subjects obs: Subjects.values()){
			setSubjects.put(obs, new ConcreteSubject());
		}
	}
	
	@SuppressWarnings("unchecked")
	public static <T>void  add(Subjects key, IObserver<T> observer){
		ConcreteSubject<T> current = setSubjects.get(key);
		current.addObserver(observer);
	}
	
	@SuppressWarnings("unchecked")
	public static <T>void inform(Subjects key, T obj){
		ConcreteSubject current = setSubjects.get(key);
		current.inform(obj);
	}

}
