package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.gunmetry.common.AbstractPref;

class Pref extends AbstractPref{

	AbstractRegion[] regions;
	
	Pref(IAbstraction model) {
		super(model);
	}
	
	@Override
	protected void setModel(IAbstraction model) {
		ModelGraphics modelGraphics = (ModelGraphics)model;
		regions = modelGraphics.getRegions();		
	}
	
	@Override
	protected void init() {
		for (int i=0; i<regions.length; i++){
			Color color = getColor(regions[i].toString(), regions[i].getColor());
			regions[i].setColor(color);
		}
	}	
	
	public void update(Boolean obj) {
		for (int i=0; i<regions.length; i++){
			int value = regions[i].getColor().getRGB();
			prefs.putInt(regions[i].toString(), value);
		}
	}

}
