/*
 * RegionCentroid.java
 *
 * Created on 2005/06/06, 1:49
 *
 */

package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import jp.sourceforge.sos.gunmetry.main.RegionSet;

/**
 *
 * @author Scientific Open Source Project (Gaku Tanaka)
 */
@SuppressWarnings("serial")
public class RegionCentroid extends AbstractRegion{
	
	/** Creates a new instance of RegionCentroid */
	public RegionCentroid(RegionSet set) {
		super(set);
	}

	public void draw(java.awt.Graphics g) {
		if (super.needToDraw()){
			Graphics2D g2d = (Graphics2D)g;
			g2d.setColor(getColor());
			for (int i=0; i<regionSet.size(); i++){
				Point2D.Double p = regionSet.getCentroid(i);
				Rectangle2D.Double r = new Rectangle2D.Double(p.x,p.y,1,1);
				g2d.draw(r);
			}
		}
	}


	
}
