/*
 * RegionContour.java
 *
 * Created on 2005/06/06, 1:49
 *
 */

package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;

import jp.sourceforge.sos.gunmetry.main.RegionSet;

/**
 *
 * @author Scientific Open Source Project (Gaku Tanaka)
 */
@SuppressWarnings("serial")
public class RegionContour extends AbstractRegion{
	
	private BufferedImage img;
	private Color oldColor = Color.black;
	
	/** Creates a new instance of RegionContour */
	public RegionContour(RegionSet set) {
		super(set);
	}

	public void draw(java.awt.Graphics g) {
		if (super.needToDraw()){
			if (colorChanged()){
				updateImage();
				oldColor = new Color(getColor().getRGB());
			}
			g.drawImage(img, 0,0, null);
		}		
	}

	private boolean colorChanged() {
		Color color = getColor();
		return (!oldColor.equals(color));
	}

	Graphics getGraphics() {
		return img.getGraphics();
	}

	void setImage(BufferedImage img) {
		this.img = img;
	}

	void updateImage() {
		img = new BufferedImage(img.getWidth(), img.getHeight(), BufferedImage.TYPE_INT_ARGB);
		Graphics g = getGraphics();
		g.setColor(getColor());
		Point[] p = regionSet.getContourPoints();
		for (int i = 0; i < p.length; i++) {
			g.drawLine(p[i].x, p[i].y, p[i].x, p[i].y);
		}
		
	}
	
}
