/*
 * RegionPath.java
 *
 * Created on 2005/06/06, 1:50
 *
 */

package jp.sourceforge.sos.gunmetry.graphics;

import java.awt.geom.Point2D;

import jp.sourceforge.sos.gunmetry.main.Region;
import jp.sourceforge.sos.gunmetry.main.RegionSet;

/**
 * 
 * @author Scientific Open Source Project (Gaku Tanaka)
 */
@SuppressWarnings("serial")
public class RegionPath extends AbstractRegion {

	/** Creates a new instance of RegionPath */
	public RegionPath(RegionSet set) {
		super(set);
	}

	public void draw(java.awt.Graphics g) {
		if (super.needToDraw()) {
			g.setColor(super.getColor());
			for (int i = 0; i<regionSet.size(); i++) {
				Point2D.Double p1 = regionSet.getCentroid(i);
				Region neighbor = regionSet.getNearestNeighbor(i);
				if (neighbor!=null) {
					Point2D.Double p2 = neighbor.getCentroid();
					g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
				}
			}
		}
	}

}
